/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.Map;
import org.neo4j.function.BiFunction;
import org.neo4j.function.Consumer;
import org.neo4j.function.Consumers;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.function.Function2;
import org.neo4j.function.Supplier;
import org.neo4j.function.UnaryOperator;

public final class Functions {
    private static UnaryOperator IDENTITY = new UnaryOperator(){

        @Override
        public Object apply(Object value) {
            return value;
        }
    };
    public static Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object from) {
            if (from != null) {
                return from.toString();
            }
            return "";
        }
    };

    public static <From, To> Function<From, To> map(final Map<From, To> map) {
        return new Function<From, To>(){

            @Override
            public To apply(From from) {
                return map.get(from);
            }
        };
    }

    public static <From, To> Function<From, To> withDefaults(final Function<From, To> defaults, final Function<From, To> f) {
        return new Function<From, To>(){

            @Override
            public To apply(From from) {
                Object to = f.apply(from);
                if (to == null) {
                    return defaults.apply(from);
                }
                return to;
            }
        };
    }

    public static <From, To> Function<From, To> nullFunction() {
        return new Function<From, To>(){

            @Override
            public To apply(From from) {
                return null;
            }
        };
    }

    public static <From, To> Function<From, To> constant(final To value) {
        return new Function<From, To>(){

            @Override
            public To apply(From from) {
                return value;
            }
        };
    }

    public static <T> UnaryOperator<T> identity() {
        return IDENTITY;
    }

    public static <From, From2, To> Function2<? super Function<From, From2>, ? super Function<From2, To>, Function<From, To>> compose() {
        return new Function2<Function<From, From2>, Function<From2, To>, Function<From, To>>(){

            @Override
            public Function<From, To> apply(final Function<From, From2> f1, final Function<From2, To> f2) {
                return new Function<From, To>(){

                    @Override
                    public To apply(From from) {
                        return f2.apply(f1.apply(from));
                    }
                };
            }
        };
    }

    public static <T1, T2> Function2<? super BiFunction<T1, T2, T1>, ? super BiFunction<T1, T2, T1>, Function2<T1, T2, T1>> compose2() {
        return new Function2<BiFunction<T1, T2, T1>, BiFunction<T1, T2, T1>, Function2<T1, T2, T1>>(){

            @Override
            public Function2<T1, T2, T1> apply(final BiFunction<T1, T2, T1> function1, final BiFunction<T1, T2, T1> function2) {
                return new Function2<T1, T2, T1>(){

                    @Override
                    public T1 apply(T1 from1, T2 from2) {
                        return function1.apply(function2.apply(from1, from2), from2);
                    }
                };
            }
        };
    }

    public static <FROM, TO> Function<FROM, TO> cast(final Class<TO> to) {
        return new Function<FROM, TO>(){

            @Override
            public TO apply(FROM from) {
                return to.cast(from);
            }

            public String toString() {
                return "cast(to=" + to.getName() + ")";
            }
        };
    }

    public static <T> Function<T, Void> fromConsumer(final Consumer<T> consumer) {
        return new Function<T, Void>(){

            @Override
            public Void apply(T t) {
                consumer.accept(t);
                return null;
            }
        };
    }

    public static <T> Function<Void, T> fromSupplier(final Supplier<T> supplier) {
        return new Function<Void, T>(){

            @Override
            public T apply(Void t) {
                return supplier.get();
            }
        };
    }

    @Deprecated
    public static <TYPE> Consumer<TYPE> swallow(Class<TYPE> type) {
        return Consumers.noop();
    }

    @Deprecated
    public static <T> Factory<T> constantly(final T item) {
        return new Factory<T>(){

            @Override
            public T newInstance() {
                return item;
            }
        };
    }
}

