/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.function.primitive.LongSupplier;

public class LinkedQueuePool<R>
implements Pool<R> {
    public static final int DEFAULT_CHECK_INTERVAL = 60000;
    private final Queue<R> unused = new ConcurrentLinkedQueue<R>();
    private final Monitor monitor;
    private final int minSize;
    private final Factory<R> factory;
    private final CheckStrategy checkStrategy;
    private final AtomicInteger allocated = new AtomicInteger(0);
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private int currentPeakSize;
    private int targetSize;

    public LinkedQueuePool(int minSize, Factory<R> factory) {
        this(minSize, factory, new CheckStrategy.TimeoutCheckStrategy(60000L), new Monitor.Adapter());
    }

    public LinkedQueuePool(int minSize, Factory<R> factory, CheckStrategy strategy, Monitor monitor) {
        this.minSize = minSize;
        this.factory = factory;
        this.currentPeakSize = 0;
        this.targetSize = minSize;
        this.checkStrategy = strategy;
        this.monitor = monitor;
    }

    protected R create() {
        return this.factory.newInstance();
    }

    protected void dispose(R resource) {
        this.monitor.disposed(resource);
        this.allocated.decrementAndGet();
    }

    @Override
    public final R acquire() {
        R resource = this.unused.poll();
        if (resource == null) {
            resource = this.create();
            this.allocated.incrementAndGet();
            this.monitor.created(resource);
        } else {
            this.queueSize.decrementAndGet();
        }
        this.currentPeakSize = Math.max(this.currentPeakSize, this.allocated.get() - this.queueSize.get());
        if (this.checkStrategy.shouldCheck()) {
            this.targetSize = Math.max(this.minSize, this.currentPeakSize);
            this.monitor.updatedCurrentPeakSize(this.currentPeakSize);
            this.currentPeakSize = 0;
            this.monitor.updatedTargetSize(this.targetSize);
        }
        this.monitor.acquired(resource);
        return resource;
    }

    @Override
    public void release(R toRelease) {
        if (this.queueSize.get() < this.targetSize) {
            this.unused.offer(toRelease);
            this.queueSize.incrementAndGet();
        } else {
            this.dispose(toRelease);
        }
    }

    public void disposeAll() {
        R resource = this.unused.poll();
        while (resource != null) {
            this.dispose(resource);
            resource = this.unused.poll();
        }
    }

    public void close(boolean force) {
        this.disposeAll();
    }

    public static interface CheckStrategy {
        public boolean shouldCheck();

        public static class TimeoutCheckStrategy
        implements CheckStrategy {
            private final long interval;
            private long lastCheckTime;
            private final LongSupplier clock;

            public TimeoutCheckStrategy(long interval) {
                this(interval, new LongSupplier(){

                    @Override
                    public long getAsLong() {
                        return System.currentTimeMillis();
                    }
                });
            }

            public TimeoutCheckStrategy(long interval, LongSupplier clock) {
                this.interval = interval;
                this.lastCheckTime = clock.getAsLong();
                this.clock = clock;
            }

            @Override
            public boolean shouldCheck() {
                long currentTime = this.clock.getAsLong();
                if (currentTime > this.lastCheckTime + this.interval) {
                    this.lastCheckTime = currentTime;
                    return true;
                }
                return false;
            }
        }
    }

    public static interface Monitor<R> {
        public void updatedCurrentPeakSize(int var1);

        public void updatedTargetSize(int var1);

        public void created(R var1);

        public void acquired(R var1);

        public void disposed(R var1);

        public static class Adapter<R>
        implements Monitor<R> {
            @Override
            public void updatedCurrentPeakSize(int currentPeakSize) {
            }

            @Override
            public void updatedTargetSize(int targetSize) {
            }

            @Override
            public void created(R resource) {
            }

            @Override
            public void acquired(R resource) {
            }

            @Override
            public void disposed(R resource) {
            }
        }
    }
}

