/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.NTriplesParserSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class NTriplesParser
extends AbstractRDFParser {
    protected Reader reader;
    protected long lineNo;
    protected Resource subject;
    protected IRI predicate;
    protected Value object;
    private final StringBuilder buffer = new StringBuilder(100);
    private final StringBuilder languageTagBuffer = new StringBuilder(8);
    private final StringBuilder datatypeUriBuffer = new StringBuilder(40);

    public NTriplesParser() {
    }

    public NTriplesParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), Charset.forName("UTF-8")), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
        this.reader = reader;
        this.lineNo = 1L;
        this.reportLocation(this.lineNo, 1L);
        try {
            int c = this.readCodePoint();
            c = this.skipWhitespace(c);
            while (c != -1) {
                c = c == 35 ? this.skipLine(c) : (c == 13 || c == 10 ? this.skipLine(c) : this.parseTriple(c));
                c = this.skipWhitespace(c);
            }
        }
        finally {
            this.clear();
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    protected int skipWhitespace(int c) throws IOException {
        while (c == 32 || c == 9) {
            c = this.readCodePoint();
        }
        return c;
    }

    protected int assertLineTerminates(int c) throws IOException, RDFParseException {
        c = this.readCodePoint();
        if ((c = this.skipWhitespace(c)) != 35 && c != -1 && c != 13 && c != 10) {
            this.reportFatalError("Content after '.' is not allowed");
        }
        return c;
    }

    protected int skipToEndOfLine(int c) throws IOException {
        while (c != -1 && c != 13 && c != 10) {
            c = this.readCodePoint();
        }
        return c;
    }

    protected int skipLine(int c) throws IOException {
        while (c != -1 && c != 13 && c != 10) {
            c = this.readCodePoint();
        }
        if (c == 10) {
            c = this.readCodePoint();
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1L);
        } else if (c == 13) {
            c = this.readCodePoint();
            if (c == 10) {
                c = this.readCodePoint();
            }
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1L);
        }
        return c;
    }

    private int parseTriple(int c) throws IOException, RDFParseException, RDFHandlerException {
        boolean ignoredAnError = false;
        try {
            c = this.parseSubject(c);
            c = this.skipWhitespace(c);
            c = this.parsePredicate(c);
            c = this.skipWhitespace(c);
            c = this.parseObject(c);
            c = this.skipWhitespace(c);
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 46) {
                this.reportError("Expected '.', found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            c = this.assertLineTerminates(c);
        }
        catch (RDFParseException rdfpe) {
            if (this.getParserConfig().isNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES)) {
                this.reportError(rdfpe, NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
                ignoredAnError = true;
            }
            throw rdfpe;
        }
        c = this.skipLine(c);
        if (!ignoredAnError) {
            Statement st = this.createStatement(this.subject, this.predicate, this.object);
            if (this.rdfHandler != null) {
                this.rdfHandler.handleStatement(st);
            }
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
        return c;
    }

    protected int parseSubject(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.subject = this.createURI(sb.toString());
        } else if (c == 95) {
            c = this.parseNodeID(c, sb);
            this.subject = this.createBNode(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<' or '_', found: " + new String(Character.toChars(c)));
        }
        return c;
    }

    protected int parsePredicate(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.predicate = this.createURI(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', found: " + new String(Character.toChars(c)));
        }
        return c;
    }

    protected int parseObject(int c) throws IOException, RDFParseException {
        StringBuilder sb = this.getBuffer();
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.object = this.createURI(sb.toString());
        } else if (c == 95) {
            c = this.parseNodeID(c, sb);
            this.object = this.createBNode(sb.toString());
        } else if (c == 34) {
            StringBuilder lang = this.getLanguageTagBuffer();
            StringBuilder datatype = this.getDatatypeUriBuffer();
            c = this.parseLiteral(c, sb, lang, datatype);
            this.object = this.createLiteral(sb.toString(), lang.toString(), datatype.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', '_' or '\"', found: " + new String(Character.toChars(c)) + "");
        }
        return c;
    }

    protected int parseUriRef(int c, StringBuilder uriRef) throws IOException, RDFParseException {
        if (c != 60) {
            this.reportError("Supplied char should be a '<', is: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        c = this.readCodePoint();
        while (c != 62) {
            if (c == -1) {
                this.throwEOFException();
            }
            if (c == 32) {
                this.reportError("IRI included an unencoded space: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            uriRef.append(Character.toChars(c));
            if (c == 92) {
                c = this.readCodePoint();
                if (c == -1) {
                    this.throwEOFException();
                }
                if (c != 117 && c != 85) {
                    this.reportError("IRI includes string escapes: '\\" + c + "'", NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
                }
                uriRef.append(Character.toChars(c));
            }
            c = this.readCodePoint();
        }
        c = this.readCodePoint();
        return c;
    }

    protected int parseNodeID(int c, StringBuilder name) throws IOException, RDFParseException {
        if (c != 95) {
            this.reportError("Supplied char should be a '_', is: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        if ((c = this.readCodePoint()) == -1) {
            this.throwEOFException();
        } else if (c != 58) {
            this.reportError("Expected ':', found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        c = this.readCodePoint();
        if (c == -1) {
            this.throwEOFException();
        } else if (!NTriplesUtil.isLetterOrNumber(c)) {
            this.reportError("Expected a letter or number, found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        name.append(Character.toChars(c));
        c = this.readCodePoint();
        while (c != -1 && NTriplesUtil.isLetterOrNumber(c)) {
            name.append(Character.toChars(c));
            c = this.readCodePoint();
        }
        return c;
    }

    private int parseLiteral(int c, StringBuilder value, StringBuilder lang, StringBuilder datatype) throws IOException, RDFParseException {
        if (c != 34) {
            this.reportError("Supplied char should be a '\"', is: " + c, NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        c = this.readCodePoint();
        while (c != 34) {
            if (c == -1) {
                this.throwEOFException();
            }
            value.append(Character.toChars(c));
            if (c == 92) {
                c = this.readCodePoint();
                if (c == -1) {
                    this.throwEOFException();
                }
                value.append(Character.toChars(c));
            }
            c = this.readCodePoint();
        }
        c = this.readCodePoint();
        if (c == 64) {
            c = this.readCodePoint();
            if (!NTriplesUtil.isLetter(c)) {
                this.reportError("Expected a letter, found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            while (c != -1 && c != 46 && c != 94 && c != 32 && c != 9) {
                lang.append(Character.toChars(c));
                c = this.readCodePoint();
            }
        } else if (c == 94) {
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 94) {
                this.reportError("Expected '^', found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 60) {
                this.reportError("Expected '<', found: " + new String(Character.toChars(c)), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            c = this.parseUriRef(c, datatype);
        }
        return c;
    }

    @Override
    protected IRI createURI(String uri) throws RDFParseException {
        try {
            uri = NTriplesUtil.unescapeString(uri);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        return super.createURI(uri);
    }

    protected int readCodePoint() throws IOException {
        int next = this.reader.read();
        if (Character.isHighSurrogate((char)next)) {
            next = Character.toCodePoint((char)next, (char)this.reader.read());
        }
        return next;
    }

    protected Literal createLiteral(String label, String lang, String datatype) throws RDFParseException {
        try {
            label = NTriplesUtil.unescapeString(label);
        }
        catch (IllegalArgumentException e) {
            this.reportFatalError(e);
        }
        if (lang.length() == 0) {
            lang = null;
        }
        if (datatype.length() == 0) {
            datatype = null;
        }
        IRI dtURI = null;
        if (datatype != null) {
            dtURI = this.createURI(datatype);
        }
        return super.createLiteral(label, lang, dtURI, this.lineNo, -1L);
    }

    @Override
    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.lineNo, -1L);
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, this.lineNo, -1L, setting);
    }

    @Override
    protected void reportError(Exception e, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(e, this.lineNo, -1L, setting);
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.lineNo, -1L);
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.lineNo, -1L);
    }

    protected void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }

    private StringBuilder getBuffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    private StringBuilder getLanguageTagBuffer() {
        this.languageTagBuffer.setLength(0);
        return this.languageTagBuffer;
    }

    private StringBuilder getDatatypeUriBuffer() {
        this.datatypeUriBuffer.setLength(0);
        return this.datatypeUriBuffer;
    }

    @Override
    protected void clear() {
        super.clear();
        this.buffer.setLength(0);
        this.buffer.trimToSize();
        this.languageTagBuffer.setLength(0);
        this.languageTagBuffer.trimToSize();
        this.datatypeUriBuffer.setLength(0);
        this.datatypeUriBuffer.trimToSize();
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        return result;
    }
}

