/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.DocumentTypeImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.IContainer;
import org.apache.axiom.om.impl.dom.IParentNode;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.dom.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.dom.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.dom.OMContainerHelper;
import org.apache.axiom.om.impl.dom.OMDescendantsIterator;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends NodeImpl
implements NodeList,
IParentNode {
    protected NodeImpl firstChild;
    protected NodeImpl lastChild;

    protected ParentNode(OMFactory factory) {
        super(factory);
    }

    void internalAppendChild(NodeImpl node) {
        this.insertBefore(node, null, false);
    }

    public void addChild(OMNode omNode) {
        this.addChild(omNode, false);
    }

    public void addChild(OMNode omNode, boolean fromBuilder) {
        OMContainerHelper.addChild((IContainer)((Object)this), omNode, fromBuilder);
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getDescendants(boolean includeSelf) {
        return new OMDescendantsIterator((OMContainer)((Object)this), includeSelf);
    }

    public Iterator getChildrenWithName(QName elementQName) throws OMException {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator children = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        while (children.hasNext()) {
            OMNode node = (OMNode)children.next();
            if (!(node instanceof OMElement)) continue;
            return (OMElement)node;
        }
        return null;
    }

    public OMNode getFirstOMChild() {
        return OMContainerHelper.getFirstOMChild(this);
    }

    public OMNode getFirstOMChildIfAvailable() {
        return (OMNode)((Object)this.firstChild);
    }

    public OMNode getLastKnownOMChild() {
        return (OMNode)((Object)this.lastChild);
    }

    public void setFirstChild(OMNode firstChild) {
        if (firstChild != null) {
            ((OMNodeEx)firstChild).setParent((OMContainer)((Object)this));
        }
        this.firstChild = (NodeImpl)((Object)firstChild);
    }

    public void setLastChild(OMNode omNode) {
        this.lastChild = (NodeImpl)((Object)omNode);
    }

    public final NodeList getChildNodes() {
        return this;
    }

    public final int getLength() {
        int count = 0;
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++count;
        }
        return count;
    }

    public final Node item(int index) {
        int count = 0;
        Node child = this.getFirstChild();
        while (child != null) {
            if (count == index) {
                return child;
            }
            child = child.getNextSibling();
            ++count;
        }
        return null;
    }

    public Node getFirstChild() {
        return (Node)((Object)this.getFirstOMChild());
    }

    public Node getLastChild() {
        if (!this.isComplete()) {
            this.build();
        }
        return this.lastChild;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public final Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.insertBefore(newChild, refChild, true);
    }

    private Node insertBefore(Node newChild, Node refChild, boolean useDomSemantics) {
        NodeImpl newDomChild = (NodeImpl)newChild;
        NodeImpl refDomChild = (NodeImpl)refChild;
        if (useDomSemantics) {
            this.checkSameOwnerDocument(newDomChild);
        }
        if (this.isAncestorOrSelf(newChild)) {
            throw DOMUtil.newDOMException((short)3);
        }
        if (newDomChild.parentNode() != null) {
            newDomChild.parentNode().removeChild(newDomChild);
        }
        if (this instanceof Document) {
            if (newDomChild instanceof ElementImpl) {
                if (((DocumentImpl)this).getOMDocumentElement(false) != null) {
                    throw DOMUtil.newDOMException((short)3);
                }
                if (newDomChild.parentNode() == null) {
                    newDomChild.setParent(this, useDomSemantics);
                }
            } else if (!(newDomChild instanceof CommentImpl || newDomChild instanceof ProcessingInstructionImpl || newDomChild instanceof DocumentFragmentImpl || newDomChild instanceof DocumentTypeImpl)) {
                throw DOMUtil.newDOMException((short)3);
            }
        }
        if (refChild == null) {
            if (!this.isComplete()) {
                this.build();
            }
            if (this.lastChild == null && this.firstChild == null) {
                this.lastChild = newDomChild;
                this.firstChild = newDomChild;
                this.firstChild.isFirstChild(true);
                newDomChild.setParent(this, useDomSemantics);
            } else {
                this.lastChild.internalSetNextSibling(newDomChild);
                newDomChild.internalSetPreviousSibling(this.lastChild);
                this.lastChild = newDomChild;
                this.lastChild.internalSetNextSibling(null);
            }
            if (newDomChild.parentNode() == null) {
                newDomChild.setParent(this, useDomSemantics);
            }
        } else {
            Iterator children = this.getChildren();
            boolean found = false;
            while (children.hasNext()) {
                NodeImpl tempNode = (NodeImpl)children.next();
                if (!tempNode.equals(refChild)) continue;
                if (this.firstChild == tempNode) {
                    if (newChild instanceof DocumentFragmentImpl) {
                        DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newChild;
                        for (NodeImpl child = docFrag.firstChild; child != null; child = child.internalGetNextSibling()) {
                            child.setParent(this, useDomSemantics);
                        }
                        this.firstChild = docFrag.firstChild;
                        docFrag.lastChild.internalSetNextSibling(refDomChild);
                        refDomChild.internalSetPreviousSibling(docFrag.lastChild.internalGetNextSibling());
                        docFrag.firstChild = null;
                        docFrag.lastChild = null;
                    } else {
                        this.firstChild = newDomChild;
                        newDomChild.internalSetNextSibling(refDomChild);
                        refDomChild.internalSetPreviousSibling(newDomChild);
                        this.firstChild.isFirstChild(true);
                        refDomChild.isFirstChild(false);
                        newDomChild.internalSetPreviousSibling(null);
                    }
                } else {
                    NodeImpl previousNode = refDomChild.internalGetPreviousSibling();
                    if (newChild instanceof DocumentFragmentImpl) {
                        DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newChild;
                        for (NodeImpl child = docFrag.firstChild; child != null; child = child.internalGetNextSibling()) {
                            child.setParent(this, useDomSemantics);
                        }
                        previousNode.internalSetNextSibling(docFrag.firstChild);
                        docFrag.firstChild.internalSetPreviousSibling(previousNode);
                        docFrag.lastChild.internalSetNextSibling(refDomChild);
                        refDomChild.internalSetPreviousSibling(docFrag.lastChild);
                        docFrag.firstChild = null;
                        docFrag.lastChild = null;
                    } else {
                        previousNode.internalSetNextSibling(newDomChild);
                        newDomChild.internalSetPreviousSibling(previousNode);
                        newDomChild.internalSetNextSibling(refDomChild);
                        refDomChild.internalSetPreviousSibling(newDomChild);
                    }
                }
                found = true;
                break;
            }
            if (!found) {
                throw DOMUtil.newDOMException((short)8);
            }
            if (newDomChild.parentNode() == null) {
                newDomChild.setParent(this, useDomSemantics);
            }
        }
        if (!newDomChild.isComplete() && !(newDomChild instanceof OMSourcedElement)) {
            this.setComplete(false);
        }
        return newChild;
    }

    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        NodeImpl newDomChild = (NodeImpl)newChild;
        NodeImpl oldDomChild = (NodeImpl)oldChild;
        if (newChild == null) {
            throw new IllegalArgumentException("newChild can't be null");
        }
        if (this.isAncestorOrSelf(newChild)) {
            throw DOMUtil.newDOMException((short)3);
        }
        this.checkSameOwnerDocument(newDomChild);
        Iterator children = this.getChildren();
        boolean found = false;
        while (!found && children.hasNext()) {
            NodeImpl tail;
            NodeImpl head;
            NodeImpl tempNode = (NodeImpl)children.next();
            if (tempNode != oldChild) continue;
            if (newChild instanceof DocumentFragmentImpl) {
                DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newDomChild;
                head = (NodeImpl)docFrag.getFirstChild();
                tail = (NodeImpl)docFrag.getLastChild();
                for (NodeImpl child = (NodeImpl)docFrag.getFirstChild(); child != null; child = child.internalGetNextSibling()) {
                    child.setParent(this, true);
                }
                docFrag.setFirstChild(null);
                docFrag.setLastChild(null);
            } else {
                head = newDomChild;
                tail = newDomChild;
                newDomChild.setParent(this, true);
            }
            NodeImpl nextSibling = (NodeImpl)oldDomChild.getNextSibling();
            NodeImpl previousSibling = oldDomChild.internalGetPreviousSibling();
            tail.internalSetNextSibling(nextSibling);
            head.internalSetPreviousSibling(previousSibling);
            if (previousSibling != null) {
                previousSibling.internalSetNextSibling(head);
            } else {
                this.firstChild = head;
            }
            if (nextSibling != null) {
                nextSibling.internalSetPreviousSibling(tail);
            } else {
                this.lastChild = tail;
            }
            found = true;
            oldDomChild.internalSetNextSibling(null);
            oldDomChild.internalSetPreviousSibling(null);
            oldDomChild.setParent(null, true);
        }
        if (!found) {
            throw DOMUtil.newDOMException((short)8);
        }
        return oldChild;
    }

    public final Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getParentNode() == this) {
            ((NodeImpl)oldChild).detach(true);
            return oldChild;
        }
        throw DOMUtil.newDOMException((short)8);
    }

    private boolean isAncestorOrSelf(Node node) {
        Node currentNode = this;
        do {
            if (currentNode != node) continue;
            return true;
        } while ((currentNode = currentNode.getParentNode()) != null);
        return false;
    }

    final NodeImpl clone(OMCloneOptions options, ParentNode targetParent, boolean deep, boolean namespaceRepairing) {
        ParentNode clone = this.shallowClone(options, targetParent, namespaceRepairing);
        if (deep) {
            for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                ((NodeImpl)child).clone(options, clone, true, namespaceRepairing);
            }
        }
        return clone;
    }

    abstract ParentNode shallowClone(OMCloneOptions var1, ParentNode var2, boolean var3);

    public String getTextContent() throws DOMException {
        Node child = this.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return ParentNode.hasTextContent(child) ? ((NodeImpl)child).getTextContent() : "";
            }
            StringBuffer buf = new StringBuffer();
            this.getTextContent(buf);
            return buf.toString();
        }
        return "";
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!ParentNode.hasTextContent(child)) continue;
            ((NodeImpl)child).getTextContent(buf);
        }
    }

    private static boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    public void setTextContent(String textContent) throws DOMException {
        Node child;
        while ((child = this.getFirstChild()) != null) {
            this.removeChild(child);
        }
        if (textContent != null && textContent.length() != 0) {
            this.addChild(this.factory.createOMText(textContent));
        }
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return OMContainerHelper.getXMLStreamReader((IContainer)((Object)this), cache);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return OMContainerHelper.getXMLStreamReader((IContainer)((Object)this), cache, configuration);
    }

    public SAXSource getSAXSource(boolean cache) {
        return new OMSource((OMContainer)((Object)this));
    }

    void notifyChildComplete() {
        if (!this.isComplete() && this.getBuilder() == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (node.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }

    void normalize(DOMConfigurationImpl config) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            ((NodeImpl)((Object)child)).normalize(config);
        }
    }
}

