/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamedNode;
import org.apache.axiom.om.impl.dom.NamedNodeHelper;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.RootNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends RootNode
implements OMAttribute,
Attr,
NamedNode {
    private String localName;
    private String type;
    private OMNamespace namespace;
    private ParentNode owner;
    protected boolean isId;

    private AttrImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(factory);
        this.owner = ownerDocument;
    }

    private AttrImpl(String localName, OMNamespace namespace, String type, OMFactory factory) {
        this(null, factory);
        this.localName = localName;
        this.namespace = namespace;
        this.type = type;
    }

    public AttrImpl(DocumentImpl ownerDocument, String localName, OMNamespace ns, String value, OMFactory factory) {
        this(ownerDocument, factory);
        if (ns != null && ns.getNamespaceURI().length() == 0) {
            if (ns.getPrefix().length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed attribute with an empty namespace name");
            }
            ns = null;
        }
        this.localName = localName;
        this.internalAppendChild(new TextImpl(value, factory));
        this.type = "CDATA";
        this.namespace = ns;
    }

    public AttrImpl(DocumentImpl ownerDocument, String name, String value, OMFactory factory) {
        this(ownerDocument, factory);
        this.localName = name;
        this.internalAppendChild(new TextImpl(value, factory));
        this.type = "CDATA";
    }

    public AttrImpl(DocumentImpl ownerDocument, String name, OMFactory factory) {
        this(ownerDocument, factory);
        this.localName = name;
        if ("xmlns".equals(name)) {
            this.namespace = new NamespaceImpl("http://www.w3.org/2000/xmlns/", "xmlns");
        }
        this.type = "CDATA";
    }

    public AttrImpl(DocumentImpl ownerDocument, String localName, OMNamespace namespace, OMFactory factory) {
        this(ownerDocument, factory);
        this.localName = localName;
        this.namespace = namespace;
        this.type = "CDATA";
    }

    final ParentNode internalGetOwnerNode() {
        return this.owner;
    }

    final void internalSetOwnerNode(ParentNode ownerNode) {
        this.owner = ownerNode;
    }

    public String getNodeName() {
        return this.namespace != null && !"".equals(this.namespace.getPrefix()) && !"xmlns".equals(this.localName) ? this.namespace.getPrefix() + ":" + this.localName : this.localName;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public String getValue() {
        String value = null;
        StringBuffer buffer = null;
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            String textValue = ((Text)child).getData();
            if (textValue == null || textValue.length() == 0) continue;
            if (value == null) {
                value = textValue;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(value);
            }
            buffer.append(textValue);
        }
        if (value == null) {
            return "";
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return value;
    }

    public String getName() {
        if (this.namespace != null) {
            if ("xmlns".equals(this.localName)) {
                return this.localName;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(this.namespace.getNamespaceURI())) {
                return "xmlns:" + this.localName;
            }
            if (this.namespace.getPrefix().equals("")) {
                return this.localName;
            }
            return this.namespace.getPrefix() + ":" + this.localName;
        }
        return this.localName;
    }

    public Element getOwnerElement() {
        return this.owner instanceof ElementImpl ? (Element)((Object)this.owner) : null;
    }

    void setOwnerElement(ElementImpl element, boolean useDomSemantics) {
        if (element == null) {
            if (this.owner instanceof ElementImpl) {
                this.owner = useDomSemantics ? ((ElementImpl)this.owner).ownerDocument() : null;
            }
        } else {
            this.owner = element;
        }
    }

    public boolean getSpecified() {
        return true;
    }

    public OMNamespace getNamespace() {
        return this.namespace;
    }

    public QName getQName() {
        return this.namespace == null ? new QName(this.localName) : new QName(this.namespace.getNamespaceURI(), this.localName, this.namespace.getPrefix());
    }

    public String getAttributeValue() {
        return this.getValue();
    }

    public String getAttributeType() {
        return this.type;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    public void setOMNamespace(OMNamespace omNamespace) {
        this.internalSetNamespace(omNamespace);
    }

    public void setAttributeValue(String value) {
        this.setValue(value);
    }

    public void setAttributeType(String attrType) {
        this.type = attrType;
    }

    final void checkInUse() {
        if (this.owner instanceof ElementImpl) {
            throw DOMUtil.newDOMException((short)10);
        }
    }

    public void setValue(String value) throws DOMException {
        Node child;
        while ((child = this.getFirstChild()) != null) {
            this.removeChild(child);
        }
        this.internalAppendChild((TextImpl)this.getOwnerDocument().createTextNode(value));
    }

    public Node getParentNode() {
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespace != null ? this.namespace.getNamespaceURI() : null;
    }

    public String getPrefix() {
        return this.namespace == null ? null : this.namespace.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        NamedNodeHelper.setPrefix(this, prefix);
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isId() {
        return this.isId;
    }

    public String toString() {
        return this.namespace == null ? this.localName : this.namespace.getPrefix() + ":" + this.localName;
    }

    public OMElement getOwner() {
        return this.owner instanceof ElementImpl ? (OMElement)((Object)this.owner) : null;
    }

    public boolean equals(Object obj) {
        String attrValue = this.getValue();
        if (obj instanceof OMAttribute) {
            OMAttribute other = (OMAttribute)obj;
            return this.namespace == null ? other.getNamespace() == null : this.namespace.equals(other.getNamespace()) && this.localName.equals(other.getLocalName()) && (attrValue == null ? other.getAttributeValue() == null : attrValue.toString().equals(other.getAttributeValue()));
        }
        if (obj instanceof Attr) {
            Attr other = (Attr)obj;
            String otherNs = other.getNamespaceURI();
            if (this.namespace == null) {
                if (otherNs != null) {
                    return false;
                }
                return this.localName.equals(other.getLocalName()) && (attrValue == null ? other.getValue() == null : attrValue.toString().equals(other.getValue()));
            }
            String ns = this.namespace.getNamespaceURI();
            String prefix = this.namespace.getPrefix();
            String otherPrefix = other.getPrefix();
            return ns.equals(otherNs) && (prefix == null ? otherPrefix == null : prefix.equals(otherPrefix)) && this.localName.equals(other.getLocalName()) && (attrValue == null ? other.getValue() == null : attrValue.toString().equals(other.getValue()));
        }
        return false;
    }

    public int hashCode() {
        String attrValue = this.getValue();
        return this.localName.hashCode() ^ (attrValue != null ? attrValue.toString().hashCode() : 0) ^ (this.namespace != null ? this.namespace.hashCode() : 0);
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    ParentNode shallowClone(OMCloneOptions options, ParentNode targetParent, boolean namespaceRepairing) {
        return new AttrImpl(this.localName, this.namespace, this.type, this.factory);
    }

    public final OMXMLParserWrapper getBuilder() {
        return null;
    }

    public final int getState() {
        return 1;
    }

    public final boolean isComplete() {
        return true;
    }

    public final void setComplete(boolean state) {
        if (!state) {
            throw new IllegalStateException();
        }
    }

    public final void build() {
    }

    public final Node getNextSibling() {
        return null;
    }

    public final String lookupNamespaceURI(String specifiedPrefix) {
        Element ownerElement = this.getOwnerElement();
        return ownerElement == null ? null : ownerElement.lookupNamespaceURI(specifiedPrefix);
    }
}

