/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.test;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestUtilities {
    public static final String GRAPH_DB_DIR = "src/test/resources/graph.db";
    public static final String GRAPH_DB_DIR_2 = "src/test/resources/test";
    private static final Random random = new Random();
    private static final String[] symbols = new String[36];

    static {
        int idx = 0;
        while (idx < 10) {
            TestUtilities.symbols[idx] = String.valueOf((char)(48 + idx));
            ++idx;
        }
        idx = 10;
        while (idx < 36) {
            TestUtilities.symbols[idx] = String.valueOf((char)(97 + idx - 10));
            ++idx;
        }
    }

    public static String randomLetter() {
        return symbols[random.nextInt(symbols.length)];
    }

    public static void deleteEverythingInDB(GraphDatabaseService graphDb) {
        Transaction tx;
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            tx = graphDb.beginTx();
            try {
                ResourceIterable<Node> nodes = GlobalGraphOperations.at(graphDb).getAllNodes();
                for (Node n : nodes) {
                    for (Relationship r : n.getRelationships()) {
                        r.delete();
                    }
                    n.delete();
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try {
            tx = graphDb.beginTx();
            try {
                ResourceIterator<Node> nodeIt = GlobalGraphOperations.at(graphDb).getAllNodes().iterator();
                Assert.assertFalse((boolean)nodeIt.hasNext());
                IndexManager indexManager = graphDb.index();
                String[] stringArray = indexManager.nodeIndexNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nodeIndex = stringArray[n2];
                    indexManager.forNodes(nodeIndex).delete();
                    ++n2;
                }
                stringArray = indexManager.relationshipIndexNames();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String relIndex = stringArray[n2];
                    indexManager.forNodes(relIndex).delete();
                    ++n2;
                }
                for (ConstraintDefinition cd : graphDb.schema().getConstraints()) {
                    cd.drop();
                }
                for (IndexDefinition id : graphDb.schema().getIndexes()) {
                    id.drop();
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static <T extends Representation> List<T> getListFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        List content = (List)responseContent.get(listrep);
        return content;
    }

    public static <T extends Representation> Iterable<T> getIterableFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        Iterable content = (Iterable)responseContent.get(listrep);
        return content;
    }

    public static GraphDatabaseService getGraphDB() {
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabase(GRAPH_DB_DIR);
        return database;
    }

    public static void printNodeProperties(Node n) {
        for (String k : n.getPropertyKeys()) {
            System.out.println(String.valueOf(k) + ": " + n.getProperty(k));
        }
    }
}

