/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.evaluators;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public class NodeLabelEvaluator
implements Evaluator {
    private Label label;
    private boolean acceptIfLabelNotPresent;

    public NodeLabelEvaluator(Label label, boolean acceptIfLabelNotPresent) {
        this.label = label;
        this.acceptIfLabelNotPresent = acceptIfLabelNotPresent;
    }

    public NodeLabelEvaluator(Label label) {
        this(label, false);
    }

    @Override
    public Evaluation evaluate(Path path) {
        Node endNode = path.endNode();
        boolean condition = endNode.hasLabel(this.label);
        if (this.acceptIfLabelNotPresent) {
            condition = !condition;
        }
        Evaluation eval = condition ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_CONTINUE;
        return eval;
    }
}

