/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacetTermRelationship;
import de.julielab.neo4j.plugins.datarepresentation.TermCoordinates;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ImportTerm {
    @SerializedName(value="preferredName")
    public String prefName;
    @SerializedName(value="descriptions")
    public List<String> descriptions;
    @SerializedName(value="synonyms")
    public List<String> synonyms;
    @SerializedName(value="writingVariants")
    public List<String> writingVariants;
    @SerializedName(value="sourceIds")
    public String sourceId;
    @SerializedName(value="uniqueSourceId")
    public boolean uniqueSourceId;
    @SerializedName(value="sources")
    public String source;
    @SerializedName(value="originalId")
    public String originalId;
    @SerializedName(value="originalSource")
    public String originalSource;
    @SerializedName(value="parentSrcIds")
    public List<String> parentSrcIds;
    @SerializedName(value="parentSources")
    public List<String> parentSources;
    @SerializedName(value="relationships")
    public List<ImportFacetTermRelationship> relationships;
    @SerializedName(value="generalLabels")
    public List<String> generalLabels;
    @SerializedName(value="displayName")
    public String displayName;
    @SerializedName(value="qualifiers")
    public List<String> qualifiers;
    @SerializedName(value="aggregate")
    public Boolean aggregate;
    @SerializedName(value="elementSrcIds")
    @Deprecated
    public List<String> elementSrcIds;
    @SerializedName(value="elementSources")
    @Deprecated
    public List<String> elementSources;
    @SerializedName(value="elementCoordinates")
    public List<TermCoordinates> elementCoordinates;
    @SerializedName(value="copyProperties")
    public List<String> copyProperties;
    @SerializedName(value="aggregateSources")
    @Deprecated
    public List<String> aggregateSources;
    @SerializedName(value="aggregateIncludeInHierarchy")
    public Boolean aggregateIncludeInHierarchy;

    public ImportTerm(String prefName, String sourceId, String description) {
        this.prefName = prefName;
        this.sourceId = sourceId;
        this.descriptions = Lists.newArrayList(description);
    }

    public ImportTerm(String prefName, String sourceId, List<String> synonyms) {
        this.prefName = prefName;
        this.sourceId = sourceId;
        this.synonyms = synonyms;
    }

    public ImportTerm(String prefName, String sourceId) {
        this.prefName = prefName;
        this.sourceId = sourceId;
    }

    public ImportTerm(String prefName, String sourceId, String description, List<String> synonyms, List<String> parentSrcIds) {
        this.prefName = prefName;
        this.sourceId = sourceId;
        this.synonyms = synonyms;
        this.descriptions = Lists.newArrayList(description);
        this.parentSrcIds = parentSrcIds;
    }

    public ImportTerm(String prefName, String sourceId, List<String> descriptions, List<String> synonyms, List<String> parentSrcIds) {
        this.prefName = prefName;
        this.sourceId = sourceId;
        this.descriptions = descriptions;
        this.synonyms = synonyms;
        this.parentSrcIds = parentSrcIds;
    }

    public ImportTerm(List<TermCoordinates> elementCoords, List<String> copyProperties) {
        this.elementCoordinates = elementCoords;
        this.copyProperties = copyProperties;
        this.aggregate = true;
    }

    public ImportTerm(String sourceId) {
        this.sourceId = sourceId;
    }

    public ImportTerm() {
    }

    public void addRelationship(ImportFacetTermRelationship relationship) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<ImportFacetTermRelationship>();
        }
        this.relationships.add(relationship);
    }

    public String toString() {
        return "ImportTerm [prefName=" + this.prefName + ", sourceId=" + this.sourceId + "]";
    }

    public void addGeneralLabel(String ... labels) {
        if (this.generalLabels == null) {
            this.generalLabels = new ArrayList<String>();
        }
        try {
            int i = 0;
            while (i < labels.length) {
                String label = labels[i];
                this.generalLabels.add(label);
                ++i;
            }
        }
        catch (UnsupportedOperationException e) {
            this.generalLabels = new ArrayList<String>(this.generalLabels);
            this.addGeneralLabel(labels);
        }
    }

    public void addElementSourceId(String sourceId) {
        if (this.elementSrcIds == null) {
            this.elementSrcIds = new ArrayList<String>();
        }
        this.elementSrcIds.add(sourceId);
    }

    public void addCopyProperty(String property) {
        if (this.copyProperties == null) {
            this.copyProperties = new ArrayList<String>();
        }
        this.copyProperties.add(property);
    }

    public void addQualifier(String speciesQualifier) {
        if (this.qualifiers == null) {
            this.qualifiers = new ArrayList<String>();
        }
        this.qualifiers.add(speciesQualifier);
    }

    public void removeGeneralLabel(String ... labels) {
        if (this.generalLabels == null || this.generalLabels.isEmpty()) {
            return;
        }
        HashSet<String> removeLabels = new HashSet<String>(labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            removeLabels.add(label);
            ++i;
        }
        Iterator<String> existingLabels = this.generalLabels.iterator();
        while (existingLabels.hasNext()) {
            String existingLabel = existingLabels.next();
            if (!removeLabels.contains(existingLabel)) continue;
            existingLabels.remove();
        }
    }

    public void addParentSrcId(String parentSrcId) {
        if (this.parentSrcIds == null) {
            this.parentSrcIds = new ArrayList<String>();
        }
        this.parentSrcIds.add(parentSrcId);
    }
}

