/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.neo4j.plugins.TermManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermNameAndSynonymComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.tooling.GlobalGraphOperations;

public class TermAggregateBuilder {
    private static final Logger log = Logger.getLogger(TermAggregateBuilder.class.getName());

    public static void buildAggregatesForEqualNames(GraphDatabaseService graphDb, String termPropertyKey, JSONArray propertyValues) throws JSONException {
        TermNameAndSynonymComparator nameAndSynonymComparator = new TermNameAndSynonymComparator();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Transaction tx = graphDb.beginTx();){
            Index<Node> termIndex = graphDb.index().forNodes("termIndex");
            ResourceIterable<Node> aggregates = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermManager.TermLabel.AGGREGATE_EQUAL_NAMES);
            for (Node aggregate : aggregates) {
                for (Relationship rel : aggregate.getRelationships()) {
                    rel.delete();
                }
                aggregate.delete();
            }
            ResourceIterable<Node> termIterable = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermManager.TermLabel.TERM);
            ArrayList<Node> terms = new ArrayList<Node>();
            for (Node term : termIterable) {
                terms.add(term);
            }
            Collections.sort(terms, nameAndSynonymComparator);
            String[] copyProperties = new String[]{"preferredName", "synonyms", "descriptions"};
            ArrayList<Node> equalNameTerms = new ArrayList<Node>();
            for (Node term : terms) {
                boolean equalTerm;
                boolean bl = equalTerm = equalNameTerms.size() == 0 || nameAndSynonymComparator.compare((Node)equalNameTerms.get(equalNameTerms.size() - 1), term) == 0;
                if (equalTerm) {
                    equalNameTerms.add(term);
                    continue;
                }
                if (equalNameTerms.size() > 1) {
                    TermAggregateBuilder.createAggregate(graphDb, copyProperties, new HashSet<Node>(equalNameTerms), new String[]{TermManager.TermLabel.AGGREGATE_EQUAL_NAMES.toString()}, termIndex, TermManager.TermLabel.AGGREGATE_EQUAL_NAMES);
                    for (Node equalNameTerm : equalNameTerms) {
                        NodeUtilities.mergeArrayProperty(equalNameTerm, termPropertyKey, JSON.json2JavaArray(propertyValues, new Object[0]));
                    }
                    equalNameTerms.clear();
                    equalNameTerms.add(term);
                    continue;
                }
                equalNameTerms.clear();
                equalNameTerms.add(term);
            }
            if (equalNameTerms.size() > 1) {
                TermAggregateBuilder.createAggregate(graphDb, copyProperties, new HashSet<Node>(equalNameTerms), new String[]{TermManager.TermLabel.AGGREGATE_EQUAL_NAMES.toString()}, termIndex, TermManager.TermLabel.AGGREGATE_EQUAL_NAMES);
            }
            for (Node term : equalNameTerms) {
                NodeUtilities.mergeArrayProperty(term, termPropertyKey, JSON.json2JavaArray(propertyValues, new Object[0]));
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void deleteAggregates(GraphDatabaseService graphDb, Label aggregateLabel) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable<Node> aggregates = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(aggregateLabel);
            for (Node aggregate : aggregates) {
                if (!aggregate.hasLabel(TermManager.TermLabel.AGGREGATE)) {
                    aggregate.removeLabel(aggregateLabel);
                    continue;
                }
                for (Relationship rel : aggregate.getRelationships()) {
                    rel.delete();
                    rel.getEndNode().removeLabel(TermManager.TermLabel.AGGREGATE_ELEMENT);
                }
                aggregate.delete();
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void buildAggregatesForMappings(GraphDatabaseService graphDb, Set<String> allowedMappingTypes, Label allowedTermLabel, Label aggregatedTermsLabel) {
        log.info("Building aggregates for mappings " + allowedMappingTypes + " and terms with label " + allowedTermLabel);
        String[] copyProperties = new String[]{"preferredName", "synonyms", "writingVariants", "descriptions", "facets"};
        Throwable throwable = null;
        Object var6_7 = null;
        try (Transaction tx = graphDb.beginTx();){
            Index<Node> termIndex = graphDb.index().forNodes("termIndex");
            TermAggregateBuilder.deleteAggregates(graphDb, aggregatedTermsLabel);
            Label label = allowedTermLabel == null ? TermManager.TermLabel.TERM : allowedTermLabel;
            ResourceIterable<Node> termIterable = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(label);
            for (Node term : termIterable) {
                Set<Node> aggregateNodes = TermAggregateBuilder.getMatchingAggregates(term, allowedMappingTypes, aggregatedTermsLabel);
                if (aggregateNodes.size() > 1) {
                    throw new IllegalStateException("Term with ID " + term.getProperty("id") + " is part of multiple aggregates of the same type, thus duplicates. The aggregate nodes are: " + aggregateNodes);
                }
                if (aggregateNodes.size() == 1) continue;
                HashSet<Node> elements = new HashSet<Node>();
                HashSet<Node> visited = new HashSet<Node>();
                TermAggregateBuilder.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, term, elements, visited);
                if (elements.size() > 1) {
                    TermAggregateBuilder.createAggregate(graphDb, copyProperties, elements, allowedMappingTypes.toArray(new String[allowedMappingTypes.size()]), termIndex, aggregatedTermsLabel);
                    continue;
                }
                term.addLabel(aggregatedTermsLabel);
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void determineMappedSubgraph(Set<String> allowedMappingTypes, Label allowedTermLabel, Node term, Set<Node> elements, Set<Node> visited) {
        if (visited.contains(term)) {
            return;
        }
        visited.add(term);
        Iterable<Relationship> mappings = term.getRelationships(TermManager.EdgeTypes.IS_MAPPED_TO);
        for (Relationship mapping : mappings) {
            if (!mapping.hasProperty("mappingType")) {
                throw new IllegalStateException("The mapping relationship " + mapping + " does not specify its type.");
            }
            String[] mappingTypes = (String[])mapping.getProperty("mappingType");
            int i = 0;
            while (i < mappingTypes.length) {
                String mappingType = mappingTypes[i];
                if (allowedMappingTypes.contains(mappingType)) {
                    Node otherTerm;
                    if (allowedTermLabel == null || term.hasLabel(allowedTermLabel)) {
                        elements.add(term);
                    }
                    if (!elements.contains(otherTerm = mapping.getOtherNode(term))) {
                        if (allowedTermLabel == null || otherTerm.hasLabel(allowedTermLabel)) {
                            elements.add(otherTerm);
                        }
                        TermAggregateBuilder.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, otherTerm, elements, visited);
                    }
                }
                ++i;
            }
        }
    }

    protected static Set<Node> getMatchingAggregates(Node conceptNode, Set<String> allowedMappingTypes, Label aggregateLabel) {
        HashSet<Node> aggregateNodes = new HashSet<Node>();
        Iterable<Relationship> elementRelationships = conceptNode.getRelationships(TermManager.EdgeTypes.HAS_ELEMENT);
        for (Relationship elementRelationship : elementRelationships) {
            Node aggregate = elementRelationship.getOtherNode(conceptNode);
            if (!aggregate.hasLabel(aggregateLabel) || !aggregate.hasLabel(TermManager.TermLabel.AGGREGATE) || !aggregate.hasProperty("mappingType")) continue;
            String[] mappingTypes = (String[])aggregate.getProperty("mappingType");
            List<String> mappingTypesList = Arrays.asList(mappingTypes);
            boolean correctMappingTypes = true;
            for (String mappingType : mappingTypesList) {
                if (allowedMappingTypes.contains(mappingType)) continue;
                correctMappingTypes = false;
            }
            for (String mappingType : allowedMappingTypes) {
                if (mappingTypesList.contains(mappingType)) continue;
                correctMappingTypes = false;
            }
            if (!correctMappingTypes) continue;
            aggregateNodes.add(aggregate);
        }
        return aggregateNodes;
    }

    private static Node createAggregate(GraphDatabaseService graphDb, String[] copyProperties, Set<Node> elementTerms, String[] mappingTypes, Index<Node> termIndex, Label ... labels) {
        if (elementTerms.isEmpty()) {
            return null;
        }
        Node aggregate = graphDb.createNode(labels);
        aggregate.addLabel(TermManager.TermLabel.AGGREGATE);
        aggregate.setProperty("copyProperties", copyProperties);
        aggregate.setProperty("mappingType", mappingTypes);
        int i = 0;
        while (i < labels.length) {
            Label termLabel = labels[i];
            aggregate.addLabel(termLabel);
            ++i;
        }
        for (Node elementTerm : elementTerms) {
            aggregate.createRelationshipTo(elementTerm, TermManager.EdgeTypes.HAS_ELEMENT);
            elementTerm.addLabel(TermManager.TermLabel.AGGREGATE_ELEMENT);
        }
        String aggregateId = "atid" + SequenceManager.getNextSequenceValue(graphDb, "seqAggregateTerm");
        aggregate.setProperty("id", aggregateId);
        termIndex.putIfAbsent(aggregate, "id", aggregateId);
        return aggregate;
    }

    public static void copyAggregateProperties(Node aggregate, String[] copyProperties, CopyAggregatePropertiesStatistics copyStats) {
        int i = 0;
        while (i < copyProperties.length) {
            String copyProperty = copyProperties[i];
            aggregate.removeProperty(copyProperty);
            ++i;
        }
        Iterable<Relationship> elementRels = aggregate.getRelationships(TermManager.EdgeTypes.HAS_ELEMENT);
        HashSet<String> divergentProperties = new HashSet<String>();
        for (Relationship elementRel : elementRels) {
            Node term = elementRel.getEndNode();
            if (copyStats != null) {
                ++copyStats.numElements;
            }
            String[] stringArray = copyProperties;
            int n = copyProperties.length;
            int n2 = 0;
            while (n2 < n) {
                String copyProperty = stringArray[n2];
                if (term.hasProperty(copyProperty)) {
                    Object property;
                    if (copyStats != null) {
                        ++copyStats.numProperties;
                    }
                    if ((property = term.getProperty(copyProperty)).getClass().isArray()) {
                        PropertyUtilities.mergeArrayProperty(aggregate, copyProperty, JulieNeo4jUtilities.convertArray(property));
                    } else {
                        PropertyUtilities.setNonNullNodeProperty(aggregate, copyProperty, property);
                        Object aggregateProperty = PropertyUtilities.getNonNullNodeProperty(aggregate, copyProperty);
                        if (!aggregateProperty.equals(property)) {
                            divergentProperties.add(copyProperty);
                        }
                    }
                }
                ++n2;
            }
        }
        for (String divergentProperty : divergentProperties) {
            HashMultiset<Object> propertyValues = HashMultiset.create();
            elementRels = aggregate.getRelationships(TermManager.EdgeTypes.HAS_ELEMENT);
            for (Relationship elementRel : elementRels) {
                Node node = elementRel.getEndNode();
                Object propertyValue = PropertyUtilities.getNonNullNodeProperty(node, divergentProperty);
                if (propertyValue == null) continue;
                propertyValues.add(propertyValue);
            }
            Object majorityValue = null;
            int maxCount = 0;
            for (Multiset.Entry entry : propertyValues.entrySet()) {
                if (entry.getCount() <= maxCount) continue;
                majorityValue = entry.getElement();
                maxCount = entry.getCount();
            }
            aggregate.setProperty(divergentProperty, majorityValue);
            for (Object e : propertyValues.elementSet()) {
                if (e.equals(majorityValue)) continue;
                Object[] convert = JulieNeo4jUtilities.convertElementsIntoArray(e.getClass(), e);
                PropertyUtilities.mergeArrayProperty(aggregate, String.valueOf(divergentProperty) + "_divergentProperty", convert);
            }
        }
        PropertyUtilities.mergeArrayProperty(aggregate, "synonyms", (Object[])PropertyUtilities.getNonNullNodeProperty(aggregate, "preferredName_divergentProperty"));
        if (aggregate.hasProperty("synonyms")) {
            String[] synonyms = (String[])aggregate.getProperty("synonyms");
            HashSet<String> lowerCaseSynonyms = new HashSet<String>();
            ArrayList<String> acceptedSynonyms = new ArrayList<String>();
            int i2 = 0;
            while (i2 < synonyms.length) {
                String synonym = synonyms[i2];
                String string = synonym.toLowerCase();
                if (!lowerCaseSynonyms.contains(string)) {
                    lowerCaseSynonyms.add(string);
                    acceptedSynonyms.add(synonym);
                }
                ++i2;
            }
            Collections.sort(acceptedSynonyms);
            aggregate.setProperty("synonyms", acceptedSynonyms.toArray(new String[acceptedSynonyms.size()]));
        }
    }

    public static class CopyAggregatePropertiesStatistics {
        public int numProperties = 0;
        public int numElements = 0;

        public String toString() {
            return "CopyAggregatePropertiesStatistics [numProperties=" + this.numProperties + ", numElements=" + this.numElements + "]";
        }
    }
}

