/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class SequenceManager {
    private static final String SEQUENCE_INDEX = "sequenceIndex";

    public static int getNextSequenceValue(GraphDatabaseService graphDb, String seqFacetGroup) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Transaction tx = graphDb.beginTx();){
            Node sequence = SequenceManager.getSequence(graphDb, seqFacetGroup);
            tx.acquireReadLock(sequence);
            tx.acquireWriteLock(sequence);
            int currentSequenceValue = (Integer)sequence.getProperty("value");
            sequence.setProperty("value", currentSequenceValue + 1);
            tx.success();
            return currentSequenceValue;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static Node getSequenceRoot(GraphDatabaseService graphDb) {
        Index<Node> rootIndex = graphDb.index().forNodes("rootNodeIndex");
        Node seqRoot = (Node)rootIndex.get("name", "sequencesRoot").getSingle();
        if (seqRoot == null) {
            seqRoot = graphDb.createNode();
            seqRoot.setProperty("name", "sequencesRoot");
            rootIndex.add(seqRoot, "name", "sequencesRoot");
        }
        return seqRoot;
    }

    private static synchronized Node getSequence(GraphDatabaseService graphDb, String seqFacetGroup) {
        IndexHits indexHits = null;
        try {
            Index<Node> seqIndex = graphDb.index().forNodes(SEQUENCE_INDEX);
            indexHits = seqIndex.get("name", seqFacetGroup);
            Node sequence = (Node)indexHits.getSingle();
            if (sequence == null) {
                Node seqRoot = SequenceManager.getSequenceRoot(graphDb);
                sequence = graphDb.createNode();
                sequence.setProperty("name", seqFacetGroup);
                sequence.setProperty("value", 0);
                seqIndex.putIfAbsent(sequence, "name", seqFacetGroup);
                seqRoot.createRelationshipTo(sequence, EdgeTypes.HAS_SEQUENCE);
            }
            Node node = sequence;
            if (indexHits != null) {
                indexHits.close();
            }
            return node;
        }
        catch (Throwable throwable) {
            try {
                if (indexHits != null) {
                    indexHits.close();
                }
                throw throwable;
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("More than one sequence node for the sequence with name \"" + seqFacetGroup + "\" was returned.", e);
            }
        }
    }

    static enum EdgeTypes implements RelationshipType
    {
        HAS_SEQUENCE;

    }

    static enum Labels implements Label
    {
        SEQUENCE_ROOT;

    }
}

