/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.TermManager;
import de.julielab.neo4j.plugins.evaluators.FacetGroupPathEvaluator;
import de.julielab.neo4j.plugins.evaluators.NodeLabelEvaluator;
import de.julielab.neo4j.plugins.evaluators.PropertyEvaluator;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;

public class PredefinedTraversals {
    public static TraversalDescription getFacetTraversal(GraphDatabaseService graphDb) {
        return PredefinedTraversals.getFacetTraversal(graphDb, null, null);
    }

    public static TraversalDescription getFacetTraversal(GraphDatabaseService graphDb, String propertyKey, Object propertyValue) {
        if (StringUtils.isBlank(propertyKey)) {
            propertyKey = "*";
        }
        if (propertyValue == null || "".equals(propertyValue)) {
            propertyValue = "*";
        }
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships(FacetManager.EdgeTypes.HAS_FACET_GROUP).relationships(FacetManager.EdgeTypes.HAS_FACET).evaluator(Evaluators.atDepth(2));
        if (!"*".equals(propertyKey) || !"*".equals(propertyValue)) {
            td = td.evaluator(new PropertyEvaluator(propertyKey, propertyValue));
        }
        return td;
    }

    public static TraversalDescription getFacetGroupTraversal(GraphDatabaseService graphDb, String facetGroupName) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships(FacetManager.EdgeTypes.HAS_FACET_GROUP).evaluator(new FacetGroupPathEvaluator(facetGroupName));
        return td;
    }

    public static TraversalDescription getAcronymsTraversal(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships(TermManager.EdgeTypes.HAS_ACRONYMS, Direction.OUTGOING).relationships(TermManager.EdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator(new NodeLabelEvaluator(TermManager.MorphoLabel.ACRONYM));
        return td;
    }

    public static TraversalDescription getWritingVariantsTraversal(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships(TermManager.EdgeTypes.HAS_VARIANTS, Direction.OUTGOING).relationships(TermManager.EdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator(new NodeLabelEvaluator(TermManager.MorphoLabel.WRITING_VARIANT));
        return td;
    }

    public static TraversalDescription getNonAggregateAggregateElements(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships(TermManager.EdgeTypes.HAS_ELEMENT).evaluator(new NodeLabelEvaluator(TermManager.TermLabel.AGGREGATE, true));
        return td;
    }
}

