/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class NodeUtilities
extends de.julielab.neo4j.plugins.auxiliaries.NodeUtilities {
    public static String getNodeRelationshipsString(Node n) {
        ArrayList<String> relsStrings = new ArrayList<String>();
        for (Relationship r : n.getRelationships()) {
            Node src = r.getStartNode();
            Node tgt = r.getEndNode();
            String srcLabel = NodeUtilities.getNodeIdentifier(src);
            String tgtLabel = NodeUtilities.getNodeIdentifier(tgt);
            String rType = r.getType().name();
            relsStrings.add(String.valueOf(srcLabel) + "-" + rType + "->" + tgtLabel);
        }
        return StringUtils.join(relsStrings, "\n");
    }

    public static String getNodeIdentifier(Node n) {
        String identifier = String.valueOf(n.getId());
        if (n.hasProperty("id")) {
            identifier = (String)n.getProperty("id");
        }
        if (n.hasProperty("sourceIds")) {
            identifier = ((String[])n.getProperty("sourceIds"))[0];
        }
        if (n.hasProperty("name")) {
            identifier = (String)n.getProperty("name");
        }
        if (n.hasProperty("preferredName")) {
            identifier = (String)n.getProperty("preferredName");
        }
        return "(" + identifier + ":" + StringUtils.join(n.getLabels().iterator(), ",") + ")";
    }

    public static Set<String> getSourcesForSourceId(Node conceptNode, String sourceId) {
        String[] conceptSources;
        HashSet<String> sourcesForSourceId = new HashSet<String>();
        String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
        String[] stringArray = conceptSources = conceptNode.hasProperty("sources") ? (String[])conceptNode.getProperty("sources") : new String[]{};
        if (conceptSources.length > 0 && conceptSrcIds.length != conceptSources.length) {
            throw new IllegalStateException("Concept " + NodeUtilities.getNodePropertiesAsString(conceptNode) + " has a differing number of source IDs and sources.");
        }
        int i = 0;
        while (i < conceptSources.length) {
            String source = conceptSources[i];
            String conceptSrcId = conceptSrcIds[i];
            if (source != null && conceptSrcId != null && conceptSrcId.equals(sourceId)) {
                sourcesForSourceId.add(source);
            }
            ++i;
        }
        return sourcesForSourceId;
    }

    public static boolean isSourceUnique(Node conceptNode, String srcId) {
        String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
        boolean[] conceptUniqueSrcIds = (boolean[])conceptNode.getProperty("uniqueSourceId");
        if (conceptSrcIds.length > 0 && conceptSrcIds.length != conceptUniqueSrcIds.length) {
            throw new IllegalStateException("Concept " + NodeUtilities.getNodePropertiesAsString(conceptNode) + " has a differing number of source IDs and unique source ID markers.");
        }
        int i = 0;
        while (i < conceptSrcIds.length) {
            if (conceptSrcIds[i].equals(srcId) && conceptUniqueSrcIds[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Node mergeConceptNodesWithUniqueSourceId(String srcId, Index<Node> termIndex, List<Node> obsoleteNodes) {
        IndexHits conceptNodes = termIndex.get("sourceIds", srcId);
        Node firstNode = null;
        for (Node conceptNode : conceptNodes) {
            String conceptPrefName;
            if (firstNode == null) {
                firstNode = conceptNode;
                continue;
            }
            String firstNodePrefName = (String)firstNode.getProperty("preferredName");
            boolean addConceptPrefToSynonyms = !firstNodePrefName.equals(conceptPrefName = (String)conceptNode.getProperty("preferredName"));
            PropertyUtilities.mergePropertyContainerIntoPropertyContainer(conceptNode, firstNode, "generalLabels", "sourceIds", "sources", "synonyms", "parentSrcIds", "relationships");
            String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
            String[] conceptSources = (String[])conceptNode.getProperty("sources");
            boolean[] conceptUniqueMarkers = (boolean[])conceptNode.getProperty("uniqueSourceId");
            int i = 0;
            while (i < conceptSrcIds.length) {
                String conceptSrcId = conceptSrcIds[i];
                String conceptSource = conceptSources[i];
                boolean conceptUniqueSrcId = conceptUniqueMarkers[i];
                int idIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sourceIds", conceptSrcId);
                int sourceIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sources", conceptSource);
                if (!StringUtils.isBlank(srcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
                    NodeUtilities.addToArrayProperty(firstNode, "sourceIds", conceptSrcId, true);
                    NodeUtilities.addToArrayProperty(firstNode, "sources", conceptSource, true);
                    NodeUtilities.addToArrayProperty(firstNode, "uniqueSourceId", conceptUniqueSrcId, true);
                }
                ++i;
            }
            String[] conceptSynonyms = (String[])conceptNode.getProperty("synonyms");
            NodeUtilities.mergeArrayProperty(firstNode, "synonyms", conceptSynonyms);
            if (addConceptPrefToSynonyms) {
                NodeUtilities.addToArrayProperty(firstNode, "synonyms", conceptPrefName);
            }
            String[] conceptFacets = (String[])conceptNode.getProperty("facets");
            NodeUtilities.mergeArrayProperty(firstNode, "facets", conceptFacets);
            Iterable<Label> labels = conceptNode.getLabels();
            for (Label label : labels) {
                firstNode.addLabel(label);
            }
            obsoleteNodes.add(conceptNode);
        }
        return firstNode;
    }
}

