/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class JulieNeo4jUtilities {
    public static Object[] convertElementsIntoArray(Class<?> cls, Object ... elements) {
        Object[] ret;
        if (cls.equals(String.class)) {
            ret = new String[elements.length];
        } else if (cls.equals(Byte.class)) {
            ret = new Byte[elements.length];
        } else if (cls.equals(Long.class)) {
            ret = new Long[elements.length];
        } else if (cls.equals(Integer.class)) {
            ret = new Integer[elements.length];
        } else if (cls.equals(Double.class)) {
            ret = new Double[elements.length];
        } else if (cls.equals(Float.class)) {
            ret = new Float[elements.length];
        } else if (cls.equals(Boolean.class)) {
            ret = new Boolean[elements.length];
        } else if (cls.equals(Character.class)) {
            ret = new Character[elements.length];
        } else if (cls.equals(Short.class)) {
            ret = new Short[elements.length];
        } else {
            throw new IllegalArgumentException(String.format("%s[] is not a supported property value type", elements.getClass().getComponentType().getName()));
        }
        System.arraycopy(elements, 0, ret, 0, ret.length);
        return ret;
    }

    public static Object[] convertArray(Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Passed value " + value + " is no array.");
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Byte[]) {
            return (Byte[])value;
        }
        if (value instanceof byte[]) {
            byte[] primitiveArray = (byte[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Long[]) {
            return (Long[])value;
        }
        if (value instanceof long[]) {
            long[] primitiveArray = (long[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Integer[]) {
            return (Integer[])value;
        }
        if (value instanceof int[]) {
            int[] primitiveArray = (int[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Double[]) {
            return (Double[])value;
        }
        if (value instanceof double[]) {
            double[] primitiveArray = (double[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Float[]) {
            return (Float[])value;
        }
        if (value instanceof float[]) {
            float[] primitiveArray = (float[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Boolean[]) {
            return (Boolean[])value;
        }
        if (value instanceof boolean[]) {
            boolean[] primitiveArray = (boolean[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Character[]) {
            return (Character[])value;
        }
        if (value instanceof char[]) {
            char[] primitiveArray = (char[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        if (value instanceof Short[]) {
            return (Short[])value;
        }
        if (value instanceof short[]) {
            short[] primitiveArray = (short[])value;
            return ArrayUtils.toObject(primitiveArray);
        }
        throw new IllegalArgumentException(String.format("%s[] is not a supported property value type", value.getClass().getComponentType().getName()));
    }

    public static <T> T[] convertListToArray(List<T> list, Class<?> cls) {
        Object[] array = (Object[])Array.newInstance(cls, list.size());
        return list.toArray(array);
    }

    public static <T> int findFirstValueInArray(T[] array, T value) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (array[0].equals(value)) {
            return 0;
        }
        if (!array[array.length - 1].equals(value)) {
            return -1;
        }
        int left = 1;
        int right = array.length - 2;
        int pos = (int)Math.ceil((right - left) / 2 + left);
        boolean posFound = false;
        while (!posFound) {
            if (!array[pos].equals(value)) {
                if (pos < array.length - 1 && array[pos + 1].equals(value)) {
                    ++pos;
                    posFound = true;
                    continue;
                }
                if (right == left) {
                    return -1;
                }
                left = pos + 1;
                pos = (int)Math.ceil((right - left) / 2 + left);
                continue;
            }
            if (pos > 0 && !array[pos - 1].equals(value)) {
                posFound = true;
                continue;
            }
            if (right == left) {
                return -1;
            }
            right = pos - 1;
            pos = (int)Math.ceil((right - left) / 2 + left);
        }
        return pos;
    }
}

