/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.RecursiveMappingRepresentation;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermAggregateBuilder;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermVariantComparator;
import de.julielab.neo4j.plugins.constants.semedico.NodeConstants;
import de.julielab.neo4j.plugins.datarepresentation.AddToNonFacetGroupCommand;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="This plugin discloses special operation for efficient access to the FacetTerms for Semedico.")
public class TermManager
extends ServerPlugin {
    private static final String UNKNOWN_TERM_SOURCE = "<unknown>";
    public static final String INSERT_MAPPINGS = "insert_mappings";
    public static final String BUILD_AGGREGATES_BY_NAME_AND_SYNONYMS = "build_aggregates_by_name_and_synonyms";
    public static final String BUILD_AGGREGATES_BY_MAPPINGS = "build_aggregates_by_mappings";
    public static final String DELETE_AGGREGATES = "delete_aggregates";
    public static final String COPY_AGGREGATE_PROPERTIES = "copy_aggregate_properties";
    public static final String CREATE_SCHEMA_INDEXES = "create_schema_indexes";
    public static final String GET_CHILDREN_OF_TERMS = "get_children_of_terms";
    public static final String GET_NUM_TERMS = "get_num_terms";
    public static final String GET_PATHS_FROM_FACETROOTS = "get_paths_to_facetroots";
    public static final String INSERT_TERMS = "insert_terms";
    public static final String GET_FACET_ROOTS = "get_facet_roots";
    public static final String ADD_TERM_VARIANTS = "add_term_variants";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_CREATE_HOLLOW_PARENTS = "createHollowParents";
    public static final String KEY_FACET = "facet";
    public static final String KEY_FACET_ID = "facetId";
    public static final String KEY_FACET_IDS = "facetIds";
    public static final String KEY_FACET_PROP_KEY = "propertyKey";
    public static final String KEY_FACET_PROP_VALUE = "propertyValue";
    public static final String KEY_ID_TYPE = "idType";
    public static final String KEY_IMPORT_OPTIONS = "importOptions";
    public static final String KEY_LABEL = "label";
    public static final String KEY_SORT_RESULT = "sortResult";
    public static final String KEY_TERM_IDS = "termIds";
    public static final String KEY_MAX_ROOTS = "maxRoots";
    public static final String KEY_TERM_PROP_KEY = "termPropertyKey";
    public static final String KEY_TERM_PROP_VALUE = "termPropertyValue";
    public static final String KEY_TERM_PROP_VALUES = "termPropertyValues";
    public static final String KEY_TERM_PUSH_CMD = "termPushCommand";
    public static final String KEY_AGGREGATED_LABEL = "aggregatedLabel";
    public static final String KEY_ALLOWED_MAPPING_TYPES = "allowedMappingTypes";
    public static final String KEY_TERM_VARIANTS = "termVariants";
    public static final String KEY_TERM_ACRONYMS = "termAcronyms";
    public static final String KEY_TERMS = "terms";
    public static final String KEY_TIME = "time";
    public static final String KEY_MAPPINGS = "mappings";
    private static final Logger log = LoggerFactory.getLogger(TermManager.class);
    public static final String POP_TERMS_FROM_SET = "pop_terms_from_set";
    public static final String PUSH_TERMS_TO_SET = "push_terms_to_set";
    public static final String RET_KEY_CHILDREN = "children";
    public static final String RET_KEY_NUM_AGGREGATES = "numAggregates";
    public static final String RET_KEY_NUM_CREATED_RELS = "numCreatedRelationships";
    public static final String RET_KEY_NUM_CREATED_TERMS = "numCreatedTerms";
    public static final String RET_KEY_NUM_ELEMENTS = "numElements";
    public static final String RET_KEY_NUM_PROPERTIES = "numProperties";
    public static final String RET_KEY_PATHS = "paths";
    public static final String RET_KEY_RELTYPES = "reltypes";
    public static final String RET_KEY_TERMS = "terms";
    public static final String TERM_MANAGER_ENDPOINT = "db/data/ext/" + TermManager.class.getSimpleName() + "/graphdb/";
    private static final int TERM_INSERT_BATCH_SIZE = 10000;
    public static final String UPDATE_CHILDREN_INFORMATION = "update_children_information";

    @Name(value="build_aggregates_by_mappings")
    @Description(value="Creates term aggregates with respect to 'IS_MAPPED_TO' relationships.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByMappigs(@Source GraphDatabaseService graphDb, @Description(value="The allowed types for IS_MAPPED_TO relationships to be included in aggregation building.") @Parameter(name="allowedMappingTypes") String allowedMappingTypesArray, @Description(value="Label for terms that have been processed by the aggregation algorithm. Such terms can be aggregate terms (with the label AGGREGATE) or just plain terms (with the label TERM) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedTermsLabelString, @Description(value="Label to restrict the terms to that are considered for aggregation creation.") @Parameter(name="label", optional=true) String allowedTermLabelString) throws JSONException {
        JSONArray allowedMappingTypesJson = new JSONArray(allowedMappingTypesArray);
        HashSet<String> allowedMappingTypes = new HashSet<String>();
        int i = 0;
        while (i < allowedMappingTypesJson.length()) {
            allowedMappingTypes.add(allowedMappingTypesJson.getString(i));
            ++i;
        }
        Label aggregatedTermsLabel = DynamicLabel.label(aggregatedTermsLabelString);
        Label allowedTermLabel = StringUtils.isBlank(allowedTermLabelString) ? null : DynamicLabel.label(allowedTermLabelString);
        log.info("Creating mapping aggregates for terms with label " + allowedTermLabel + " and mapping types " + allowedMappingTypesJson);
        TermAggregateBuilder.buildAggregatesForMappings(graphDb, allowedMappingTypes, allowedTermLabel, aggregatedTermsLabel);
    }

    @Name(value="delete_aggregates")
    @Description(value="Deletes aggregates with respect to a specific aggregate label. Only real aggregates are actually deleted, plain terms that are 'their own' aggregates just lose the label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void deleteAggregatesByMappigs(@Source GraphDatabaseService graphDb, @Description(value="Label for terms that have been processed by the aggregation algorithm. Such terms can be aggregate terms (with the label AGGREGATE) or just plain terms (with the label TERM) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedTermsLabelString) throws JSONException {
        Label aggregatedTermsLabel = DynamicLabel.label(aggregatedTermsLabelString);
        TermAggregateBuilder.deleteAggregates(graphDb, aggregatedTermsLabel);
    }

    @Name(value="build_aggregates_by_name_and_synonyms")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByNameAndSynonyms(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termPropertyKey") String termPropertyKey, @Description(value="TODO") @Parameter(name="termPropertyValues") String propertyValues) throws JSONException {
        JSONArray jsonPropertyValues = new JSONArray(propertyValues);
        TermAggregateBuilder.buildAggregatesForEqualNames(graphDb, termPropertyKey, jsonPropertyValues);
    }

    @Name(value="copy_aggregate_properties")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation copyAggregateProperties(@Source GraphDatabaseService graphDb) {
        int numAggregates = 0;
        TermAggregateBuilder.CopyAggregatePropertiesStatistics copyStats = new TermAggregateBuilder.CopyAggregatePropertiesStatistics();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Transaction tx = graphDb.beginTx();){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (ResourceIterator<Node> aggregateIt = graphDb.findNodes(TermLabel.AGGREGATE);){
                while (aggregateIt.hasNext()) {
                    Node aggregate = (Node)aggregateIt.next();
                    numAggregates += this.copyAggregatePropertiesRecursively(aggregate, copyStats, new HashSet<Node>());
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            tx.success();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        reportMap.put(RET_KEY_NUM_AGGREGATES, numAggregates);
        reportMap.put(RET_KEY_NUM_ELEMENTS, copyStats.numElements);
        reportMap.put(RET_KEY_NUM_PROPERTIES, copyStats.numProperties);
        return new RecursiveMappingRepresentation(Representation.MAP, reportMap);
    }

    private int copyAggregatePropertiesRecursively(Node aggregate, TermAggregateBuilder.CopyAggregatePropertiesStatistics copyStats, Set<Node> alreadySeen) {
        if (alreadySeen.contains(aggregate)) {
            return 0;
        }
        ArrayList<Node> elementAggregates = new ArrayList<Node>();
        Iterable<Relationship> elementRels = aggregate.getRelationships(Direction.OUTGOING, EdgeTypes.HAS_ELEMENT);
        for (Relationship elementRel : elementRels) {
            Node endNode = elementRel.getEndNode();
            if (!endNode.hasLabel(TermLabel.AGGREGATE) || alreadySeen.contains(endNode)) continue;
            elementAggregates.add(endNode);
        }
        for (Node elementAggregate : elementAggregates) {
            this.copyAggregatePropertiesRecursively(elementAggregate, copyStats, alreadySeen);
        }
        if (aggregate.hasProperty("copyProperties")) {
            String[] copyProperties = (String[])aggregate.getProperty("copyProperties");
            TermAggregateBuilder.copyAggregateProperties(aggregate, copyProperties, copyStats);
        }
        alreadySeen.add(aggregate);
        return alreadySeen.size();
    }

    private void createRelationships(GraphDatabaseService graphDb, JSONArray jsonTerms, Node facet, Map<String, Node> nodesBySrcId, ImportOptions importOptions, InsertionReport insertionReport) throws JSONException {
        log.info("Creating relationship between inserted terms.");
        Index<Node> idIndex = graphDb.index().forNodes("termIndex");
        String facetId = null;
        if (facet != null) {
            facetId = (String)facet.getProperty("id");
        }
        DynamicRelationshipType relBroaderThanInFacet = null;
        if (facet != null) {
            relBroaderThanInFacet = DynamicRelationshipType.withName(String.valueOf(EdgeTypes.IS_BROADER_THAN.toString()) + "_" + facetId);
        }
        AddToNonFacetGroupCommand noFacetCmd = importOptions.noFacetCmd;
        Node noFacet = null;
        int quarter = jsonTerms.length() / 4;
        int numQuarter = 1;
        long totalTime = 0L;
        long relCreationTime = 0L;
        int i = 0;
        while (i < jsonTerms.length()) {
            String srcId;
            Node term;
            long time = System.currentTimeMillis();
            JSONObject jsonTerm = jsonTerms.getJSONObject(i);
            if (!(JSON.getBoolean(jsonTerm, "aggregate") && !JSON.getBoolean(jsonTerm, "aggregateIncludeInHierarchy") || (term = nodesBySrcId.get(srcId = jsonTerm.getString("sourceIds"))) == null && insertionReport.omittedTerms.contains(srcId))) {
                int j;
                if (term == null) {
                    throw new IllegalStateException("No node for source ID " + srcId + " was created but the respective concept is included into the data for import and it is unknown why no node instance was created.");
                }
                JSONArray parentSrcIds = JSON.getJSONArray(jsonTerm, "parentSrcIds");
                if (parentSrcIds != null && parentSrcIds.length() > 0) {
                    j = 0;
                    while (j < parentSrcIds.length()) {
                        String parentSrcId = parentSrcIds.getString(j);
                        if (importOptions.cutParents.contains(parentSrcId)) {
                            this.createRelationShipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                        } else {
                            Node parent = nodesBySrcId.get(parentSrcId);
                            if (parent != null) {
                                long creationTime = System.currentTimeMillis();
                                this.createRelationShipIfNotExists(parent, term, EdgeTypes.IS_BROADER_THAN, insertionReport);
                                this.createRelationShipIfNotExists(parent, term, relBroaderThanInFacet, insertionReport);
                                relCreationTime += System.currentTimeMillis() - creationTime;
                            } else {
                                log.info("Term with source ID \"" + srcId + "\" referenced the term with source ID \"" + parentSrcId + "\" as its parent. However, that parent node does not exist.");
                                if (importOptions.createHollowParents) {
                                    log.info("Creating hollow parents is switched on. The parent will be created with the label \"" + TermLabel.HOLLOW + "\" and be connected to the facet root.");
                                    Node hollowParent = graphDb.createNode(TermLabel.TERM, TermLabel.HOLLOW);
                                    PropertyUtilities.addToArrayProperty(hollowParent, "sourceIds", parentSrcId);
                                    String source = JSON.getString(jsonTerm, "sources");
                                    if (source == null) {
                                        source = UNKNOWN_TERM_SOURCE;
                                    }
                                    PropertyUtilities.addToArrayProperty(hollowParent, "sources", source);
                                    idIndex.add(hollowParent, "sourceIds", parentSrcId);
                                    nodesBySrcId.put(parentSrcId, hollowParent);
                                    ++insertionReport.numTerms;
                                    this.createRelationShipIfNotExists(hollowParent, term, EdgeTypes.IS_BROADER_THAN, insertionReport);
                                    this.createRelationShipIfNotExists(hollowParent, term, relBroaderThanInFacet, insertionReport);
                                    this.createRelationShipIfNotExists(facet, hollowParent, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                                } else {
                                    log.info("Creating hollow parents is switched off. Hence the term will be added as root term for its facet (\"" + facet.getProperty("name") + "\").");
                                    this.createRelationShipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                                }
                            }
                            if (parent != null && parent.hasLabel(TermLabel.AGGREGATE) && !parent.hasLabel(TermLabel.TERM)) {
                                throw new IllegalArgumentException("Concept with source ID " + srcId + " specifies source ID " + parentSrcId + " as parent. This node is an aggregate but not a TERM itself and thus is not included in the hierarchy and cannot be the conceptual parent of other concepts. To achieve this, import the aggregate with the property " + "aggregateIncludeInHierarchy" + " set to true or build the aggregates in a way that assignes the TERM label to them.");
                            }
                        }
                        ++j;
                    }
                } else if (noFacetCmd != null && noFacetCmd.getParentCriteria().contains((Object)AddToNonFacetGroupCommand.ParentCriterium.NO_PARENT)) {
                    if (noFacetCmd != null && noFacet == null) {
                        noFacet = FacetManager.getNoFacet(graphDb, (String)facet.getProperty("id"));
                    }
                    this.createRelationShipIfNotExists(noFacet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                } else if (facet != null) {
                    log.debug("Installing term with source ID " + srcId + " (ID: " + term.getProperty("id") + ") as root for facet " + facet.getProperty("name") + "(ID: " + facet.getProperty("id") + ")");
                    this.createRelationShipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                }
                if (jsonTerm.has("relationships")) {
                    JSONArray jsonRelationships = jsonTerm.getJSONArray("relationships");
                    j = 0;
                    while (j < jsonRelationships.length()) {
                        String targetSource;
                        String targetSrcId;
                        String targetOrgSource;
                        JSONObject jsonRelationship = jsonRelationships.getJSONObject(j);
                        String rsTypeStr = jsonRelationship.getString("type");
                        String targetOrgId = JSON.getString(jsonRelationship, "targetOriginalId");
                        Node target = this.lookupTerm(targetOrgId, targetOrgSource = JSON.getString(jsonRelationship, "targetOriginalSource"), targetSrcId = JSON.getString(jsonRelationship, "targetSrcId"), targetSource = JSON.getString(jsonRelationship, "targetSource"), JSON.getBoolean(jsonTerm, "uniqueSourceId", false), idIndex);
                        if (target == null) {
                            target = graphDb.createNode(TermLabel.TERM, TermLabel.HOLLOW);
                            PropertyUtilities.addToArrayProperty(target, "sourceIds", targetSrcId);
                            PropertyUtilities.addToArrayProperty(target, "sources", targetSource);
                            if (targetOrgId != null) {
                                target.setProperty("originalId", targetOrgId);
                            }
                            if (targetOrgSource != null) {
                                target.setProperty("originalSource", targetOrgSource);
                            }
                            if (targetOrgId != null) {
                                idIndex.add(target, "originalId", targetOrgId);
                            }
                            if (targetSrcId != null) {
                                idIndex.add(target, "sourceIds", targetSrcId);
                            }
                        }
                        EdgeTypes type = EdgeTypes.valueOf(rsTypeStr);
                        Object[] properties = null;
                        if (jsonRelationship.has("properties")) {
                            JSONObject relProps = jsonRelationship.getJSONObject("properties");
                            JSONArray propNames = relProps.names();
                            properties = new Object[propNames.length() * 2];
                            int k = 0;
                            while (k < propNames.length()) {
                                String propName = propNames.getString(k);
                                Object propValue = relProps.get(propName);
                                properties[2 * k] = propName;
                                properties[2 * k + 1] = propValue;
                                ++k;
                            }
                        }
                        this.createRelationShipIfNotExists(term, target, type, insertionReport, Direction.OUTGOING, properties);
                        ++insertionReport.numRelationships;
                        ++j;
                    }
                }
                totalTime += System.currentTimeMillis() - time;
                if (i >= numQuarter * quarter) {
                    log.info("Finished " + 25 * numQuarter + "% of terms for relationship creation.");
                    log.info("Relationship creation took " + relCreationTime + "ms.");
                    log.info("Total time consumption for creation of " + insertionReport.numRelationships + " relationships until now: " + totalTime + "ms.");
                    ++numQuarter;
                }
            }
            ++i;
        }
    }

    private void createIndexIfAbsent(GraphDatabaseService graphDb, Label label, String key, boolean unique) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Transaction tx = graphDb.beginTx();){
            Schema schema = graphDb.schema();
            boolean indexExists = false;
            for (IndexDefinition id : schema.getIndexes(label)) {
                for (String propertyKey : id.getPropertyKeys()) {
                    if (!propertyKey.equals(key)) continue;
                    indexExists = true;
                }
            }
            if (!indexExists) {
                log.info("Creating index for label " + label + " on property " + key + " (unique: " + unique + ").");
                schema.constraintFor(label).assertPropertyIsUnique(key).create();
                tx.success();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Relationship createRelationShipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport) {
        return this.createRelationShipIfNotExists(source, target, type, insertionReport, Direction.OUTGOING, new Object[0]);
    }

    private Relationship createRelationShipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport, Direction direction, Object ... properties) {
        if (properties != null && properties.length % 2 != 0) {
            throw new IllegalArgumentException("Property list must contain of key/value pairs but its length was odd.");
        }
        boolean relationShipExists = false;
        Relationship createdRelationship = null;
        if (insertionReport.relationshipAlreadyWasCreated(source, target, type)) {
            relationShipExists = true;
        } else if (insertionReport.existingTerms.contains(source) && insertionReport.existingTerms.contains(target)) {
            Iterable<Relationship> relationships = source.getRelationships(direction, type);
            for (Relationship relationship : relationships) {
                if (!relationship.getEndNode().equals(target)) continue;
                relationShipExists = true;
                if (PropertyUtilities.mergeProperties(relationship, properties)) continue;
                relationShipExists = false;
            }
        }
        if (!relationShipExists) {
            createdRelationship = source.createRelationshipTo(target, type);
            int i = 0;
            while (properties != null && i < properties.length) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                createdRelationship.setProperty(key, value);
                i += 2;
            }
            insertionReport.addCreatedRelationship(source, target, type);
            ++insertionReport.numRelationships;
        }
        return createdRelationship;
    }

    @Name(value="create_schema_indexes")
    @Description(value="Creates uniqueness constraints (and thus, indexes), on the following label / property combinations: TERM / id; TERM / originalId; FACET / id; NO_FACET / id; ROOT / name. This should be done after the main initial import because node insertion with uniqueness switched on costs significant insertion performance.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void createSchemaIndexes(@Source GraphDatabaseService graphDb) {
        this.createIndexIfAbsent(graphDb, TermLabel.TERM, "id", true);
        this.createIndexIfAbsent(graphDb, TermLabel.TERM, "originalId", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.FACET, "id", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.NO_FACET, "id", true);
        this.createIndexIfAbsent(graphDb, NodeConstants.Labels.ROOT, "name", true);
    }

    @Name(value="get_children_of_terms")
    @Description(value="Returns all non-hollow children of terms identified via the termIds parameter. The return format is a map from the children's id to respective child term. This endpoint has been created due to performance reasons. All tried Cypher queries to achieve the same behaviour were less performant (tested for version 2.0.0 M3).")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getChildrenOfTerms(@Source GraphDatabaseService graphDb, @Description(value="JSON array of term IDs for which to return their children.") @Parameter(name="termIds") String termIdArray, @Description(value="The label agsinst which the given term IDs are resolved. Defaults to 'TERM'.") @Parameter(name="label", optional=true) String labelString) throws JSONException {
        Label label = TermLabel.TERM;
        if (!StringUtils.isBlank(labelString)) {
            label = DynamicLabel.label(labelString);
        }
        JSONArray termIds = new JSONArray(termIdArray);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Transaction tx = graphDb.beginTx();){
            HashMap<String, Object> childrenByTermId = new HashMap<String, Object>();
            int i = 0;
            while (i < termIds.length()) {
                HashMap<String, ArrayList<String>> reltypesByNodeId = new HashMap<String, ArrayList<String>>();
                HashSet<Node> childList = new HashSet<Node>();
                String termId = termIds.getString(i);
                Node term = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, label, "id", termId);
                if (term != null) {
                    for (Relationship rel : term.getRelationships(Direction.OUTGOING)) {
                        String reltype = rel.getType().name();
                        Node child = rel.getEndNode();
                        boolean isHollow = false;
                        for (Label l : child.getLabels()) {
                            if (!l.equals(TermLabel.HOLLOW)) continue;
                            isHollow = true;
                        }
                        if (isHollow) continue;
                        String childId = (String)child.getProperty("id");
                        ArrayList<String> reltypeList = (ArrayList<String>)reltypesByNodeId.get(childId);
                        if (reltypeList == null) {
                            reltypeList = new ArrayList<String>();
                            reltypesByNodeId.put(childId, reltypeList);
                        }
                        reltypeList.add(reltype);
                        childList.add(child);
                    }
                    HashMap<String, Cloneable> childrenAndReltypes = new HashMap<String, Cloneable>();
                    childrenAndReltypes.put(RET_KEY_CHILDREN, childList);
                    childrenAndReltypes.put(RET_KEY_RELTYPES, reltypesByNodeId);
                    childrenByTermId.put(termId, childrenAndReltypes);
                }
                ++i;
            }
            return new RecursiveMappingRepresentation(Representation.MAP, childrenByTermId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Name(value="get_num_terms")
    @Description(value="Returns the number of terms in the database, i.e. the number of nodes with the \"TERM\" label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public long getNumTerms(@Source GraphDatabaseService graphDb) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable<Node> terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermLabel.TERM);
            long count = 0L;
            for (Node term : terms) {
                ++count;
            }
            return count;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Name(value="get_paths_to_facetroots")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation getPathsFromFacetroots(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termIds") String termIdsJsonString, @Description(value="TODO") @Parameter(name="idType") String idType, @Description(value="TODO") @Parameter(name="sortResult") boolean sort, final @Description(value="TODO") @Parameter(name="facetId") String facetId) throws JSONException {
        JSONArray termIds = new JSONArray(termIdsJsonString);
        Evaluator rootTermEvaluator = new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                Node endNode = path.endNode();
                Iterator<Relationship> iterator = endNode.getRelationships(EdgeTypes.HAS_ROOT_TERM).iterator();
                if (iterator.hasNext()) {
                    String[] facetIds;
                    if (StringUtils.isBlank(facetId)) {
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                    String[] stringArray = facetIds = (String[])endNode.getProperty("facets");
                    int n = facetIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String facetIdOfRootNode = stringArray[n2];
                        if (facetIdOfRootNode.equals(facetId)) {
                            return Evaluation.INCLUDE_AND_CONTINUE;
                        }
                        ++n2;
                    }
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
        EdgeTypes relType = StringUtils.isBlank(facetId) ? EdgeTypes.IS_BROADER_THAN : DynamicRelationshipType.withName(String.valueOf(EdgeTypes.IS_BROADER_THAN.name()) + "_" + facetId);
        TraversalDescription td = graphDb.traversalDescription().uniqueness(Uniqueness.NODE_PATH).depthFirst().relationships(relType, Direction.INCOMING).evaluator(rootTermEvaluator);
        Throwable throwable = null;
        Object var11_12 = null;
        try (Transaction tx = graphDb.beginTx();){
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < termIds.length()) {
                String termId = termIds.getString(i);
                termId = QueryParser.escape((String)termId);
                sb.append(idType).append(":").append(termId);
                if (i < termIds.length() - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            String termQuery = sb.toString();
            Index<Node> termIndex = graphDb.index().forNodes("termIndex");
            IndexHits indexHits = termIndex.query(termQuery);
            ResourceIterator startNodeIterator = indexHits.iterator();
            Node[] startNodes = new Node[indexHits.size()];
            int i2 = 0;
            while (i2 < indexHits.size()) {
                if (!startNodeIterator.hasNext()) {
                    throw new IllegalStateException(String.valueOf(indexHits.size()) + " index hits for start nodes expected but iterator expired unexpectedly.");
                }
                startNodes[i2] = (Node)startNodeIterator.next();
                ++i2;
            }
            Traverser traverse = td.traverse(startNodes);
            ArrayList<String[]> pathsTermIds = new ArrayList<String[]>();
            int c = 0;
            for (Path p : traverse) {
                log.info("Path nr. " + c++ + ":" + p.toString());
                String[] pathTermIds = new String[p.length() + 1];
                Iterator<Node> nodesIt = p.nodes().iterator();
                boolean error = false;
                int i3 = p.length();
                while (i3 >= 0) {
                    if (!nodesIt.hasNext()) {
                        throw new IllegalStateException("Length of path wrong, more nodes expected.");
                    }
                    Node n = nodesIt.next();
                    if (!n.hasProperty("id")) {
                        log.warn("Came across the term " + n + " (" + NodeUtilities.getNodePropertiesAsString(n) + ") when computing root paths. But this term does not have an ID.");
                        error = true;
                        break;
                    }
                    pathTermIds[i3] = (String)n.getProperty("id");
                    --i3;
                }
                if (error) continue;
                pathsTermIds.add(pathTermIds);
            }
            if (sort) {
                Collections.sort(pathsTermIds, new Comparator<String[]>(){

                    @Override
                    public int compare(String[] o1, String[] o2) {
                        return o1.length - o2.length;
                    }
                });
            }
            HashMap<String, Object> pathsWrappedInMap = new HashMap<String, Object>();
            pathsWrappedInMap.put(RET_KEY_PATHS, pathsTermIds);
            return new RecursiveMappingRepresentation(Representation.MAP, pathsWrappedInMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void insertAggregateTerm(GraphDatabaseService graphDb, Index<Node> termIndex, JSONObject jsonTerm, Map<String, Node> nodesBySrcId, InsertionReport insertionReport, ImportOptions importOptions) throws JSONException {
        JSONArray copyProperties;
        boolean includeAggreationInHierarchy;
        String aggOrgId = JSON.getString(jsonTerm, "originalId");
        String aggOrgSource = JSON.getString(jsonTerm, "originalSource");
        String aggSrcId = JSON.getString(jsonTerm, "sourceIds");
        String aggSource = JSON.getString(jsonTerm, "sources");
        boolean aggUniqueAggSrcId = JSON.getBoolean(jsonTerm, "uniqueSourceId", false);
        if (aggSource == null) {
            aggSource = UNKNOWN_TERM_SOURCE;
        }
        log.debug("Looking up aggregate (" + aggOrgId + "," + aggOrgSource + ") / (" + aggSrcId + "," + aggSource + "), original/source coordinates.");
        Node aggregate = this.lookupTerm(aggOrgId, aggOrgSource, aggSrcId, aggSource, aggUniqueAggSrcId, termIndex);
        if (aggregate != null) {
            String isHollowMessage = "";
            if (aggregate.hasLabel(TermLabel.HOLLOW)) {
                isHollowMessage = ", however it is hollow and its properties will be set now.";
            }
            log.debug("    aggregate does already exist" + isHollowMessage);
            if (!aggregate.hasLabel(TermLabel.HOLLOW)) {
                return;
            }
            aggregate.removeLabel(TermLabel.HOLLOW);
            aggregate.addLabel(TermLabel.AGGREGATE);
        }
        if (aggregate == null) {
            log.debug("    aggregate is being created");
            aggregate = graphDb.createNode(TermLabel.AGGREGATE);
        }
        boolean bl = includeAggreationInHierarchy = jsonTerm.has("aggregateIncludeInHierarchy") && jsonTerm.getBoolean("aggregateIncludeInHierarchy");
        if (includeAggreationInHierarchy) {
            aggregate.addLabel(TermLabel.TERM);
        }
        JSONArray elementCoords = jsonTerm.getJSONArray("elementCoordinates");
        int numElementsFound = 0;
        log.debug("    looking up aggregate elements");
        int i = 0;
        while (i < elementCoords.length()) {
            Node element;
            JSONObject elementCoord = elementCoords.getJSONObject(i);
            String elementSrcId = elementCoord.getString("id");
            String elementSource = elementCoord.getString("source");
            if (elementSource == null) {
                elementSource = UNKNOWN_TERM_SOURCE;
            }
            if ((element = nodesBySrcId.get(elementSrcId)) != null) {
                String[] srcIds = (String[])element.getProperty("sourceIds");
                String[] sources = element.hasProperty("sources") ? (String[])element.getProperty("sources") : new String[]{};
                int j = 0;
                while (j < srcIds.length) {
                    String source;
                    String srcId = srcIds[j];
                    String string = source = sources.length > j ? sources[j] : null;
                    if (!srcId.equals(elementSrcId) || elementSource == null && source == null || elementSource.equals(source)) break;
                    element = null;
                    ++j;
                }
                if (element != null) {
                    log.debug("\tFound element with source ID and source" + elementSrcId + ", " + elementSource + " in in-memory map.");
                }
            }
            if (element == null) {
                element = this.lookupTermBySourceId(elementSrcId, elementSource, false, termIndex);
            }
            if (element == null && importOptions.createHollowAggregateElements) {
                element = graphDb.createNode(TermLabel.TERM, TermLabel.HOLLOW);
                log.debug("    Creating HOLLOW element with source coordinates (" + elementSrcId + "," + elementSource + ")");
                PropertyUtilities.addToArrayProperty(element, "sourceIds", elementSrcId);
                PropertyUtilities.addToArrayProperty(element, "sources", elementSource);
                termIndex.add(element, "sourceIds", elementSrcId);
            }
            if (element != null) {
                aggregate.createRelationshipTo(element, EdgeTypes.HAS_ELEMENT);
                ++numElementsFound;
            }
            ++i;
        }
        if (jsonTerm.has("sourceIds")) {
            String aggSourceId = (String)jsonTerm.get("sourceIds");
            int idIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sourceIds", aggSourceId);
            int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sources", aggSource);
            if (!StringUtils.isBlank(aggSourceId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
                PropertyUtilities.addToArrayProperty(aggregate, "sourceIds", aggSourceId, true);
                PropertyUtilities.addToArrayProperty(aggregate, "sources", aggSource, true);
            }
            nodesBySrcId.put(aggSourceId, aggregate);
            termIndex.add(aggregate, "sourceIds", aggSourceId);
        }
        if (aggOrgId != null) {
            aggregate.setProperty("originalId", aggOrgId);
        }
        if (aggOrgSource != null) {
            aggregate.setProperty("originalSource", aggOrgSource);
        }
        if ((copyProperties = JSON.getJSONArray(jsonTerm, "copyProperties")) != null && copyProperties.length() > 0) {
            aggregate.setProperty("copyProperties", JSON.json2JavaArray(copyProperties, new Object[0]));
        }
        JSONArray generalLabels = JSON.getJSONArray(jsonTerm, "generalLabels");
        int i2 = 0;
        while (generalLabels != null && i2 < generalLabels.length()) {
            aggregate.addLabel(DynamicLabel.label(generalLabels.getString(i2)));
            ++i2;
        }
        String aggregateId = "atid" + SequenceManager.getNextSequenceValue(graphDb, "seqAggregateTerm");
        aggregate.setProperty("id", aggregateId);
        termIndex.add(aggregate, "id", aggregateId);
        ++insertionReport.numTerms;
    }

    private void insertFacetTerm(GraphDatabaseService graphDb, String facetId, Index<Node> termIndex, JSONObject jsonTerm, Map<String, Node> nodesBySrcId, InsertionReport insertionReport, ImportOptions importOptions) throws JSONException {
        String prefName = JSON.getString(jsonTerm, "preferredName");
        String srcId = importOptions.merge ? JSON.getString(jsonTerm, "sourceIds") : jsonTerm.getString("sourceIds");
        boolean uniqueSourceId = JSON.getBoolean(jsonTerm, "uniqueSourceId", false);
        String orgId = JSON.getString(jsonTerm, "originalId");
        JSONArray synonyms = JSON.getJSONArray(jsonTerm, "synonyms");
        JSONArray generalLabels = JSON.getJSONArray(jsonTerm, "generalLabels");
        String source = JSON.getString(jsonTerm, "sources");
        String orgSource = JSON.getString(jsonTerm, "originalSource");
        boolean hasBeenNewlyCreated = false;
        boolean srcIduniqueMarkerChanged = false;
        if (StringUtils.isBlank(srcId) && !StringUtils.isBlank(orgId) && (StringUtils.isBlank(source) && !StringUtils.isBlank(orgSource) || source.equals(orgSource))) {
            srcId = orgId;
            source = orgSource;
        }
        if (StringUtils.isBlank(source)) {
            source = UNKNOWN_TERM_SOURCE;
        }
        if (StringUtils.isBlank(orgId) ^ StringUtils.isBlank(orgSource)) {
            throw new IllegalArgumentException("Term to be inserted defines only its original ID or its original source but not both. This is not allowed. The term data was: " + jsonTerm);
        }
        if (importOptions.merge && jsonTerm.has("parentSrcIds")) {
            throw new IllegalArgumentException("Term " + jsonTerm + " is supposed to be merged with an existing database term but defines parents. This is currently not supported in merging mode.");
        }
        Node term = null;
        term = this.lookupTerm(orgId, orgSource, srcId, source, uniqueSourceId, termIndex);
        if (term == null && importOptions.merge) {
            return;
        }
        String termId = null;
        if (term != null && !term.hasLabel(TermLabel.HOLLOW)) {
            termId = (String)term.getProperty("id");
        }
        if (term == null || term.hasLabel(TermLabel.HOLLOW)) {
            if (term == null) {
                term = graphDb.createNode(TermLabel.TERM);
                log.debug("Created new TERM node for original / source coordinates (" + orgId + "," + orgSource + ") / (" + srcId + "," + source + ")");
                hasBeenNewlyCreated = true;
                ++insertionReport.numTerms;
            } else {
                term.removeLabel(TermLabel.HOLLOW);
                term.removeProperty("sourceIds");
                term.removeProperty("sources");
                insertionReport.addExistingTerm(term);
                Iterable<Relationship> relationships = term.getRelationships(EdgeTypes.HAS_ROOT_TERM);
                for (Relationship rel : relationships) {
                    Node startNode = rel.getStartNode();
                    if (!startNode.hasLabel(FacetManager.FacetLabel.FACET)) continue;
                    rel.delete();
                }
            }
            termId = "tid" + SequenceManager.getNextSequenceValue(graphDb, "seqTerm");
            term.setProperty("id", termId);
            termIndex.putIfAbsent(term, "id", termId);
        } else if (term != null) {
            insertionReport.addExistingTerm(term);
        }
        PropertyUtilities.mergeJSONObjectIntoPropertyContainer(jsonTerm, (PropertyContainer)term, "generalLabels", "sourceIds", "sources", "uniqueSourceId", "synonyms", "parentSrcIds", "relationships");
        int idIndex = PropertyUtilities.findFirstValueInArrayProperty(term, "sourceIds", srcId);
        int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(term, "sources", source);
        if (!StringUtils.isBlank(srcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
            if (term.hasProperty("sourceIds")) {
                srcIduniqueMarkerChanged = this.checkUniqueIdMarkerClash(term, srcId, uniqueSourceId);
            }
            PropertyUtilities.addToArrayProperty(term, "sourceIds", srcId, true);
            PropertyUtilities.addToArrayProperty(term, "sources", source, true);
            PropertyUtilities.addToArrayProperty(term, "uniqueSourceId", uniqueSourceId, true);
        }
        PropertyUtilities.mergeArrayProperty(term, "synonyms", JSON.json2JavaArray(synonyms, prefName));
        PropertyUtilities.addToArrayProperty(term, "facets", facetId);
        int i = 0;
        while (generalLabels != null && i < generalLabels.length()) {
            term.addLabel(DynamicLabel.label(generalLabels.getString(i)));
            ++i;
        }
        if (!importOptions.merge) {
            if (hasBeenNewlyCreated) {
                termIndex.add(term, "sourceIds", srcId);
            }
            if (orgId != null) {
                termIndex.putIfAbsent(term, "originalId", orgId);
            }
            termIndex.putIfAbsent(term, "id", termId);
            nodesBySrcId.put(srcId, term);
        }
        if (srcIduniqueMarkerChanged) {
            log.warn("Merging concept nodes with unique source ID " + srcId + " because on term with this source ID and source " + source + " the ID was declared non-unique in the past but unique now. Properties from all nodes are merged together and relationships are moved from obsolete nodes to the single remaining node. This is experimental and might lead to errors.");
            ArrayList<Node> obsoleteNodes = new ArrayList<Node>();
            Node mergedNode = NodeUtilities.mergeConceptNodesWithUniqueSourceId(srcId, termIndex, obsoleteNodes);
            for (Node obsoleteNode : obsoleteNodes) {
                Iterable<Relationship> relationships = obsoleteNode.getRelationships();
                for (Relationship rel : relationships) {
                    Node startNode = rel.getStartNode();
                    Node endNode = rel.getEndNode();
                    if (startNode.getId() == obsoleteNode.getId()) {
                        startNode = mergedNode;
                    }
                    if (endNode.getId() == obsoleteNode.getId()) {
                        endNode = mergedNode;
                    }
                    this.createRelationShipIfNotExists(startNode, endNode, rel.getType(), insertionReport, Direction.OUTGOING, rel.getAllProperties());
                    rel.delete();
                    obsoleteNode.delete();
                }
            }
        }
        JSONArray parentSrcIds = JSON.getJSONArray(jsonTerm, "parentSrcIds");
        int i2 = 0;
        while (parentSrcIds != null && i2 < parentSrcIds.length()) {
            String parentSrcId = parentSrcIds.getString(i2);
            Node parent = nodesBySrcId.get(parentSrcId);
            if (parent == null) {
                try {
                    parent = this.lookupTerm(null, null, parentSrcId, source, false, termIndex);
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("Error while looking up the parents of term source ID \"" + srcId + "\".\n Parent source ID is: " + parentSrcId, e);
                }
                if (parent != null) {
                    nodesBySrcId.put(parentSrcId, parent);
                    insertionReport.addExistingTerm(parent);
                }
            }
            ++i2;
        }
        if (StringUtils.isBlank(prefName) && !insertionReport.existingTerms.contains(term)) {
            throw new IllegalArgumentException("Term has no property \"preferredName\": " + jsonTerm);
        }
    }

    private boolean checkUniqueIdMarkerClash(Node conceptNode, String srcId, boolean uniqueSourceId) {
        boolean uniqueOnConcept = NodeUtilities.isSourceUnique(conceptNode, srcId);
        return !uniqueOnConcept && uniqueOnConcept != uniqueSourceId;
    }

    private InsertionReport insertFacetTerms(GraphDatabaseService graphDb, JSONArray jsonTerms, String facetId, Map<String, Node> nodesBySrcId, ImportOptions importOptions) throws JSONException {
        long time = System.currentTimeMillis();
        InsertionReport insertionReport = new InsertionReport();
        Index<Node> termIndex = null;
        IndexManager indexManager = graphDb.index();
        termIndex = indexManager.forNodes("termIndex");
        log.info("Starting to insert " + jsonTerms.length() + " terms.");
        int i = 0;
        while (i < jsonTerms.length()) {
            JSONObject jsonTerm = jsonTerms.getJSONObject(i);
            boolean isAggregate = JSON.getBoolean(jsonTerm, "aggregate");
            if (isAggregate) {
                this.insertAggregateTerm(graphDb, termIndex, jsonTerm, nodesBySrcId, insertionReport, importOptions);
            } else {
                this.insertFacetTerm(graphDb, facetId, termIndex, jsonTerm, nodesBySrcId, insertionReport, importOptions);
            }
            ++i;
        }
        log.debug(String.valueOf(jsonTerms.length()) + " terms inserted.");
        time = System.currentTimeMillis() - time;
        log.info(String.valueOf(insertionReport.numTerms) + " new terms - but not yet relationships - have been inserted. This took " + time + " ms (" + time / 1000L + " s)");
        return insertionReport;
    }

    public Representation insertFacetTerms(GraphDatabaseService graphDb, String termsAndFacetJson) throws JSONException {
        JSONObject input = new JSONObject(termsAndFacetJson);
        JSONObject jsonFacet = JSON.getJSONObject(input, KEY_FACET);
        JSONArray jsonTerms = input.getJSONArray("terms");
        JSONObject importOptionsJson = JSON.getJSONObject(input, KEY_IMPORT_OPTIONS);
        return this.insertFacetTerms(graphDb, jsonFacet != null ? jsonFacet.toString() : null, jsonTerms.toString(), importOptionsJson != null ? importOptionsJson.toString() : null);
    }

    @Name(value="insert_terms")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation insertFacetTerms(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="facet", optional=true) String facetJson, @Description(value="TODO") @Parameter(name="terms", optional=true) String termsJson, @Description(value="TODO") @Parameter(name="importOptions", optional=true) String importOptionsJsonString) throws JSONException {
        ImportOptions importOptions;
        log.info("insert_terms was called");
        long time = System.currentTimeMillis();
        Gson gson = new Gson();
        log.debug("Parsing input.");
        JSONObject jsonFacet = null;
        JSONArray jsonTerms = null;
        JSONObject importOptionsJson = null;
        JSONObject jSONObject = jsonFacet = !StringUtils.isEmpty(facetJson) ? new JSONObject(facetJson) : null;
        if (termsJson != null) {
            jsonTerms = new JSONArray(termsJson);
        }
        if (importOptionsJsonString != null) {
            importOptionsJson = new JSONObject(importOptionsJsonString);
            importOptions = gson.fromJson(importOptionsJson.toString(), ImportOptions.class);
        } else {
            importOptions = new ImportOptions();
        }
        HashMap<String, Object> report = new HashMap<String, Object>();
        InsertionReport insertionReport = new InsertionReport();
        log.debug("Beginning processing of term insertion.");
        Throwable throwable = null;
        Object var15_15 = null;
        try (Transaction tx = graphDb.beginTx();){
            PropertyContainer facet = null;
            String facetId = null;
            log.debug("Handling import of facet.");
            if (jsonFacet != null && jsonFacet.has("id")) {
                facetId = jsonFacet.getString("id");
                log.info("Facet ID " + facetId + " has been given to add the terms to.");
                boolean isNoFacet = JSON.getBoolean(jsonFacet, "noFacet");
                facet = isNoFacet ? FacetManager.getNoFacet(graphDb, facetId) : FacetManager.getFacetNode(graphDb, facetId);
                if (facet == null) {
                    throw new IllegalArgumentException("The facet with ID \"" + facetId + "\" was not found. You must pass the ID of an existing facet or deliver all information required to create the facet from scratch. Then, the facetId must not be included in the request, it will be created dynamically.");
                }
            } else if (jsonFacet != null && jsonFacet.has("name")) {
                ResourceIterator<Node> facetIterator = graphDb.findNodes(FacetManager.FacetLabel.FACET);
                while (facetIterator.hasNext()) {
                    facet = (Node)facetIterator.next();
                    if (facet.getProperty("name").equals(jsonFacet.getString("name"))) break;
                    facet = null;
                }
            }
            if (jsonFacet != null && facet == null) {
                facet = FacetManager.createFacet(graphDb, jsonFacet);
            }
            if (facet != null) {
                facetId = (String)facet.getProperty("id");
            }
            log.debug("Facet was successfully created or determined by ID.");
            if (jsonTerms != null) {
                log.debug("Beginning to create term nodes and relationships.");
                HashMap<String, Node> nodesBySrcId = new HashMap<String, Node>(jsonTerms.length());
                insertionReport = this.insertFacetTerms(graphDb, jsonTerms, facetId, nodesBySrcId, importOptions);
                if (!nodesBySrcId.isEmpty()) {
                    this.createRelationships(graphDb, jsonTerms, (Node)facet, nodesBySrcId, importOptions, insertionReport);
                }
                time = System.currentTimeMillis() - time;
                report.put(RET_KEY_NUM_CREATED_TERMS, insertionReport.numTerms);
                report.put(RET_KEY_NUM_CREATED_RELS, insertionReport.numRelationships);
                report.put(KEY_FACET_ID, facetId);
                report.put(KEY_TIME, time);
                log.debug("Done creating terms and relationships.");
            } else {
                log.info("No terms were included in the request.");
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        log.info("Term insertion complete.");
        log.info("insert_terms is finished processing after " + time + " ms. " + insertionReport.numTerms + " terms and " + insertionReport.numRelationships + " relationships have been created.");
        return new RecursiveMappingRepresentation(Representation.MAP, report);
    }

    private Node lookupTerm(String orgId, String orgSource, String srcId, String source, boolean uniqueSourceId, Index<Node> termIndex) {
        Node term;
        log.debug("Looking up term via original ID and source ({}, {}) and source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        if (!(orgId != null && orgSource != null || srcId != null && source != null)) {
            log.debug("Neither original ID and original source nor source ID and source were given, returning null.");
            return null;
        }
        Node node = term = orgId != null ? (Node)termIndex.get("originalId", orgId).getSingle() : null;
        if (term != null) {
            log.debug("Found term by original ID " + orgId);
        }
        if (term != null) {
            if (!PropertyUtilities.hasSamePropertyValue(term, "originalSource", orgSource)) {
                log.debug("Original source doesn't match; requested: " + orgSource + ", found term has: " + term.getProperty("originalSource"));
                term = null;
            } else {
                log.debug("Found existing term for original ID " + orgId + " and original source " + orgSource);
            }
        }
        if (term == null && srcId != null && (term = this.lookupTermBySourceId(srcId, source, uniqueSourceId, termIndex)) != null) {
            Object existingOrgId = NodeUtilities.getNonNullNodeProperty(term, "originalId");
            Object existingOrgSrc = NodeUtilities.getNonNullNodeProperty(term, "originalSource");
            if (!(existingOrgId == null || existingOrgSrc == null || orgId == null || orgSource == null || existingOrgId.equals(orgId) && existingOrgSrc.equals(orgSource))) {
                throw new IllegalStateException(String.format("Inconsistent data: A newly imported term has original ID, original source (%s, %s) and source ID, source (%s, %s); the latter matches the found term with ID %s but a this term has an original ID and source (%s, %s)", orgId, orgSource, srcId, source, NodeUtilities.getNonNullNodeProperty(term, "id"), existingOrgId, existingOrgSrc));
            }
        }
        if (term == null) {
            log.debug("    Did not find an existing term with original ID and source ({}, {}) or source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        }
        return term;
    }

    private Node lookupTermBySourceId(String srcId, String source, boolean uniqueSourceId, Index<Node> termIndex) {
        log.debug("Trying to look up existing term by source ID and source ({}, {})", (Object)srcId, (Object)source);
        IndexHits indexHits = termIndex.get("sourceIds", srcId);
        if (!indexHits.hasNext()) {
            log.debug("    Did not find any term with source ID " + srcId);
        }
        Node soughtConcept = null;
        boolean uniqueSourceIdNodeFound = false;
        while (indexHits.hasNext()) {
            Set<String> sources;
            boolean uniqueOnConceptNode;
            Node conceptNode = (Node)indexHits.next();
            if (conceptNode == null) continue;
            if (uniqueSourceId && (uniqueOnConceptNode = NodeUtilities.isSourceUnique(conceptNode, srcId))) {
                if (soughtConcept == null) {
                    soughtConcept = conceptNode;
                } else if (uniqueSourceIdNodeFound) {
                    throw new IllegalStateException("There are multiple concept nodes with unique source ID " + srcId + ". This means that some sources define the ID as unique and others not. This can lead to an inconsistent database as happened in this case.");
                }
                log.debug("    Found existing term with unique source ID " + srcId + " which matches given unique source ID");
                uniqueSourceIdNodeFound = true;
            }
            if (!(sources = NodeUtilities.getSourcesForSourceId(conceptNode, srcId)).contains(source)) {
                log.debug("    Did not find a match for source ID " + srcId + " and source " + source);
                conceptNode = null;
            } else {
                log.debug("    Found existing term for source ID " + srcId + " and source " + source);
            }
            if (soughtConcept == null) {
                soughtConcept = conceptNode;
                continue;
            }
            if (uniqueSourceIdNodeFound) continue;
            throw new IllegalStateException("There are multiple concept nodes with source ID " + srcId + " and source " + source);
        }
        return soughtConcept;
    }

    @Name(value="pop_terms_from_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation popTermsFromSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="label") String labelString, @Description(value="TODO") @Parameter(name="amount") int amount) {
        Transaction tx;
        Label label = DynamicLabel.label(labelString);
        ArrayList<Node> poppedTerms = new ArrayList<Node>(amount);
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            tx = graphDb.beginTx();
            try {
                ResourceIterable<Node> nodesWithLabel = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(label);
                Node term = null;
                int popCount = 0;
                ResourceIterator<Node> it = nodesWithLabel.iterator();
                while (it.hasNext() && popCount < amount) {
                    term = (Node)it.next();
                    poppedTerms.add(term);
                    ++popCount;
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_9 = null;
        try {
            tx = graphDb.beginTx();
            try {
                for (Node term : poppedTerms) {
                    term.removeLabel(label);
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("terms", poppedTerms);
        return new RecursiveMappingRepresentation(Representation.MAP, retMap);
    }

    /*
     * Exception decompiling
     */
    @Name(value="push_terms_to_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public long pushTermsToSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termPushCommand") String termPushCommandString, @Description(value="The amount of terms to push into the set. If equal or less than zero or omitted, all terms will be pushed.") @Parameter(name="amount", optional=true) Integer amount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Name(value="update_children_information")
    @Description(value="Updates - or creates - the information which term has children in which facets. This information is used in Semedico to either render an 'opening' arrow next to a term to display its children, or no 'drill-down' option depending on whether the term in question has children in the facet it is shown in or not.")
    @PluginTarget(value=GraphDatabaseService.class)
    public String updateChildrenInformation(@Source GraphDatabaseService graphDb) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Transaction tx = graphDb.beginTx();){
            for (Node term : GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermLabel.TERM)) {
                Iterator<Relationship> relIt = term.getRelationships(Direction.OUTGOING).iterator();
                HashSet<String> facetsContainingChildren = new HashSet<String>();
                while (relIt.hasNext()) {
                    String[] typeNameParts;
                    String lastPart;
                    Relationship rel = relIt.next();
                    String type = rel.getType().name();
                    if (!type.startsWith(EdgeTypes.IS_BROADER_THAN.toString()) || !(lastPart = (typeNameParts = type.split("_"))[typeNameParts.length - 1]).startsWith("fid")) continue;
                    facetsContainingChildren.add(lastPart);
                }
                if (facetsContainingChildren.size() == 0 && term.hasProperty("childrenInFacets")) {
                    term.removeProperty("childrenInFacets");
                    continue;
                }
                if (facetsContainingChildren.size() <= 0) continue;
                term.setProperty("childrenInFacets", facetsContainingChildren.toArray(new String[facetsContainingChildren.size()]));
            }
            tx.success();
            return "success";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Name(value="include_terms")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void includeTerms(@Source GraphDatabaseService graphDb) throws JSONException {
        Transaction tx;
        Label includeLabel = DynamicLabel.label("INCLUDE");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (Transaction tx2 = graphDb.beginTx();){
            ResourceIterable<Node> terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(includeLabel);
            for (Node term : terms) {
                term.removeLabel(includeLabel);
            }
            tx2.success();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        HashSet<String> facetIds = new HashSet<String>();
        throwable2 = null;
        Object var5_9 = null;
        try {
            tx = graphDb.beginTx();
            try {
                Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
                TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
                Traverser traverse = facetTraversal.traverse(facetGroupsNode);
                for (Path path : traverse) {
                    Node facetNode = path.endNode();
                    facetIds.add((String)facetNode.getProperty("id"));
                }
                log.info("Including terms from facets " + facetIds);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        throwable2 = null;
        var5_9 = null;
        try {
            tx = graphDb.beginTx();
            try {
                ResourceIterable<Node> terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermLabel.TERM);
                block17: for (Node term : terms) {
                    if (!term.hasProperty("facets")) {
                        log.info("Doesnt have facets: " + PropertyUtilities.getNodePropertiesAsString(term));
                        continue;
                    }
                    String[] facets = (String[])term.getProperty("facets");
                    int i = 0;
                    while (i < facets.length) {
                        String string = facets[i];
                        if (facetIds.contains(string)) {
                            term.addLabel(includeLabel);
                            continue block17;
                        }
                        ++i;
                    }
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable2 == null) {
                throwable2 = throwable5;
            } else if (throwable2 != throwable5) {
                throwable2.addSuppressed(throwable5);
            }
            throw throwable2;
        }
    }

    @Name(value="exclude_terms")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void excludeTerms(@Source GraphDatabaseService graphDb) throws JSONException {
        ResourceIterable<Node> terms;
        Transaction tx;
        Label includeLabel = DynamicLabel.label("INCLUDE");
        Label excludeLabel = DynamicLabel.label("EXCLUDE");
        Label mappingAggregateLabel = DynamicLabel.label("MAPPING_AGGREGATE");
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            tx = graphDb.beginTx();
            try {
                terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermLabel.TERM);
                for (Node term : terms) {
                    if (!term.hasLabel(includeLabel)) {
                        term.addLabel(excludeLabel);
                        term.removeLabel(mappingAggregateLabel);
                        term.removeLabel(TermLabel.AGGREGATE);
                        term.removeLabel(TermLabel.TERM);
                        continue;
                    }
                    term.addLabel(mappingAggregateLabel);
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_8 = null;
        try {
            tx = graphDb.beginTx();
            try {
                terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(TermLabel.AGGREGATE);
                for (Node a : terms) {
                    a.removeLabel(TermLabel.AGGREGATE);
                    a.removeLabel(mappingAggregateLabel);
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Name(value="insert_mappings")
    @Description(value="Adds a set of term mappings to the database. Here, a 'mapping' between two terms means that those terms are 'similar' to one another. The actual similarity - e.g. 'equal' or 'related' - is defined by the type of the mapping. Here, all mappings are interpreted as being symmetric. That does not mean that two relationships are created but that reading commands don't care about the relationship direction.")
    @PluginTarget(value=GraphDatabaseService.class)
    public int insertMappings(@Source GraphDatabaseService graphDb, @Description(value="An array of mappings in JSON format. Each mapping is an object with the keys for \"id1\", \"id2\" and \"mappingType\", respectively.") @Parameter(name="mappings") String mappingsJson) throws JSONException {
        mappings = new JSONArray(mappingsJson);
        var4_4 = null;
        var5_6 = null;
        try {
            tx = graphDb.beginTx();
            try {
                termIndex = graphDb.index().forNodes("termIndex");
                nodesBySrcId = new HashMap<String, Node>(mappings.length());
                insertionReport = new InsertionReport();
                i = 0;
                while (i < mappings.length()) {
                    block22: {
                        block23: {
                            block24: {
                                block20: {
                                    block21: {
                                        mapping = mappings.getJSONObject(i);
                                        id1 = mapping.getString("id1");
                                        id2 = mapping.getString("id2");
                                        mappingType = mapping.getString("mappingType");
                                        if (StringUtils.isBlank(id1)) {
                                            throw new IllegalArgumentException("id1 in mapping \"" + mapping + "\" is missing.");
                                        }
                                        if (StringUtils.isBlank(id2)) {
                                            throw new IllegalArgumentException("id2 in mapping \"" + mapping + "\" is missing.");
                                        }
                                        if (StringUtils.isBlank(mappingType)) {
                                            throw new IllegalArgumentException("mappingType in mapping \"" + mapping + "\" is missing.");
                                        }
                                        n1 = (Node)nodesBySrcId.get(id1);
                                        if (n1 != null) break block20;
                                        indexHits = termIndex.get("sourceIds", id1);
                                        if (indexHits.size() > 1) {
                                            TermManager.log.error("More than one node for source ID {}", (Object)id1);
                                            for (Node n : indexHits) {
                                                TermManager.log.error(NodeUtilities.getNodePropertiesAsString(n));
                                            }
                                            throw new IllegalStateException("More than one node for source ID " + id1);
                                        }
                                        n1 = (Node)indexHits.getSingle();
                                        if (n1 != null) break block21;
                                        TermManager.log.warn("There is no term with source ID \"" + id1 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                                        break block22;
                                    }
                                    nodesBySrcId.put(id1, n1);
                                }
                                if ((n2 = (Node)nodesBySrcId.get(id2)) != null) break block23;
                                n2 = (Node)termIndex.get("sourceIds", id2).getSingle();
                                if (n2 != null) break block24;
                                TermManager.log.warn("There is no term with source ID \"" + id2 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                                break block22;
                            }
                            nodesBySrcId.put(id2, n2);
                        }
                        if (!mappingType.equalsIgnoreCase("LOOM")) ** GOTO lbl-1000
                        n1Facets = (String[])n1.getProperty("facets");
                        n2Facets = (String[])n2.getProperty("facets");
                        n1FacetSet = new HashSet<String>();
                        n2FacetSet = new HashSet<String>();
                        j = 0;
                        while (j < n1Facets.length) {
                            facet = n1Facets[j];
                            n1FacetSet.add(facet);
                            ++j;
                        }
                        j = 0;
                        while (j < n2Facets.length) {
                            facet = n2Facets[j];
                            n2FacetSet.add(facet);
                            ++j;
                        }
                        if (!Sets.intersection(n1FacetSet, n2FacetSet).isEmpty()) {
                            TermManager.log.debug("Omitting LOOM mapping between " + id1 + " and " + id2 + " because both concepts appear in the same terminology. We assume that the terminology does not have two equal terms and that LOOM is wrong here.");
                        } else lbl-1000:
                        // 2 sources

                        {
                            insertionReport.addExistingTerm(n1);
                            insertionReport.addExistingTerm(n2);
                            this.createRelationShipIfNotExists(n1, n2, EdgeTypes.IS_MAPPED_TO, insertionReport, Direction.BOTH, new Object[]{"mappingType", new String[]{mappingType}});
                        }
                    }
                    ++i;
                }
                tx.success();
                TermManager.log.info(String.valueOf(insertionReport.numRelationships) + " of " + mappings.length() + " new mappings successfully added.");
                return insertionReport.numRelationships;
            }
            catch (Throwable var4_5) {
                throw var4_5;
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable var5_7) {
            if (var4_4 == null) {
                var4_4 = var5_7;
            } else if (var4_4 != var5_7) {
                var4_4.addSuppressed(var5_7);
            }
            throw var4_4;
        }
    }

    @Name(value="get_facet_roots")
    @Description(value="Returns root terms for the facets with specified IDs. Can also be restricted to particular roots which is useful for facets that have a lot of roots.")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getFacetRoots(@Source GraphDatabaseService graphDb, @Description(value="An array of facet IDs in JSON format.") @Parameter(name="facetIds") String facetIdsJson, @Description(value="An array of term IDs to restrict the retrieval to.") @Parameter(name="termIds", optional=true) String termIdsJson, @Description(value="Restricts the facets to those that have at most the specified number of roots.") @Parameter(name="maxRoots", optional=true) long maxRoots) throws JSONException {
        HashMap<String, Object> facetRoots = new HashMap<String, Object>();
        JSONArray facetIdsArray = new JSONArray(facetIdsJson);
        HashSet<String> requestedFacetIds = new HashSet<String>();
        int i = 0;
        while (i < facetIdsArray.length()) {
            requestedFacetIds.add(facetIdsArray.getString(i));
            ++i;
        }
        HashMap requestedTermIds = null;
        if (!StringUtils.isBlank(termIdsJson) && !termIdsJson.equals("null")) {
            JSONObject termIdsObject = new JSONObject(termIdsJson);
            requestedTermIds = new HashMap();
            JSONArray facetIds = termIdsObject.names();
            int i2 = 0;
            while (facetIds != null && i2 < facetIds.length()) {
                String facetId = facetIds.getString(i2);
                JSONArray requestedRootIdsForFacet = termIdsObject.getJSONArray(facetId);
                HashSet<String> idSet = new HashSet<String>();
                int j = 0;
                while (j < requestedRootIdsForFacet.length()) {
                    idSet.add(requestedRootIdsForFacet.getString(j));
                    ++j;
                }
                requestedTermIds.put(facetId, idSet);
                ++i2;
            }
        }
        Throwable throwable = null;
        Object var11_12 = null;
        try (Transaction tx = graphDb.beginTx();){
            log.info("Returning roots for facets " + requestedFacetIds);
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                String facetId = (String)facetNode.getProperty("id");
                if (maxRoots > 0L && facetNode.hasProperty("numRoots") && (Long)facetNode.getProperty("numRoots") > maxRoots) {
                    log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root terms (" + facetNode.getProperty("numRoots") + ").");
                }
                Set requestedIdSet = null;
                if (requestedTermIds != null) {
                    requestedIdSet = (Set)requestedTermIds.get(facetId);
                }
                if (!requestedFacetIds.contains(facetId)) continue;
                ArrayList<Node> roots = new ArrayList<Node>();
                Iterable<Relationship> relationships = facetNode.getRelationships(Direction.OUTGOING, EdgeTypes.HAS_ROOT_TERM);
                for (Relationship rel : relationships) {
                    String rootId;
                    Node rootTerm = rel.getEndNode();
                    boolean include = true;
                    if (requestedIdSet != null && !requestedIdSet.contains(rootId = (String)rootTerm.getProperty("id"))) {
                        include = false;
                    }
                    if (!include) continue;
                    roots.add(rootTerm);
                }
                if (!(roots.isEmpty() || maxRoots > 0L && (long)roots.size() > maxRoots)) {
                    facetRoots.put(facetId, roots);
                    continue;
                }
                log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root terms (" + roots.size() + ").");
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new RecursiveMappingRepresentation(Representation.MAP, facetRoots);
    }

    @Name(value="add_term_variants")
    @Description(value="Returns root terms for the facets with specified IDs. Can also be restricted to particular roots which is useful for facets that have a lot of roots.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void addWritingVariants(@Source GraphDatabaseService graphDb, @Description(value="A JSON object mapping term IDs to an array of writing variants to add to the existing writing variants.") @Parameter(name="termVariants", optional=true) String termVariants, @Description(value="A JSON object mapping term IDs to an array of acronyms to add to the existing term acronyms.") @Parameter(name="termAcronyms", optional=true) String termAcronyms) throws JSONException {
        if (termVariants != null) {
            this.addConceptVariant(graphDb, termVariants, "writingVariants");
        }
        if (termAcronyms != null) {
            this.addConceptVariant(graphDb, termAcronyms, "acronyms");
        }
    }

    private void addConceptVariant(GraphDatabaseService graphDb, String termVariants, String type) {
        EdgeTypes variantRelationshipType;
        MorphoLabel variantNodeLabel;
        MorphoLabel variantsAggregationLabel;
        System.out.println(termVariants);
        String nullElement = "<null>";
        if (type.equals("writingVariants")) {
            variantsAggregationLabel = MorphoLabel.WRITING_VARIANTS;
            variantNodeLabel = MorphoLabel.WRITING_VARIANT;
            variantRelationshipType = EdgeTypes.HAS_VARIANTS;
        } else if (type.equals("acronyms")) {
            variantsAggregationLabel = MorphoLabel.ACRONYMS;
            variantNodeLabel = MorphoLabel.ACRONYM;
            variantRelationshipType = EdgeTypes.HAS_ACRONYMS;
        } else {
            throw new IllegalArgumentException("Unknown lexico-morphological type \"" + type + "\".");
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (StringReader stringReader = new StringReader(termVariants);){
            JsonReader jsonReader = new JsonReader(stringReader);
            try {
                Throwable throwable2 = null;
                Object var13_17 = null;
                try (Transaction tx = graphDb.beginTx();){
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        Node variantsNode;
                        String termId = jsonReader.nextName();
                        HashMap variantCountsInDocs = new HashMap();
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            String docId = jsonReader.nextName();
                            jsonReader.beginObject();
                            TreeMap<String, Integer> variantCounts = new TreeMap<String, Integer>(new TermVariantComparator());
                            while (jsonReader.hasNext()) {
                                String variant = jsonReader.nextName();
                                int count = jsonReader.nextInt();
                                if (variantCounts.containsKey(variant)) {
                                    Integer currentCount = (Integer)variantCounts.get(variant);
                                    variantCounts.put(variant, currentCount + count);
                                    continue;
                                }
                                variantCounts.put(variant, count);
                            }
                            jsonReader.endObject();
                            variantCountsInDocs.put(docId, variantCounts);
                        }
                        jsonReader.endObject();
                        if (variantCountsInDocs.isEmpty()) {
                            log.debug("Term with ID " + termId + " has no writing variants / acronyms attached.");
                            continue;
                        }
                        Node term = graphDb.findNode(TermLabel.TERM, "id", termId);
                        if (term == null) {
                            log.warn("Term with ID " + termId + " was not found, cannot add writing variants / acronyms.");
                            continue;
                        }
                        Relationship hasVariantsRel = term.getSingleRelationship(variantRelationshipType, Direction.OUTGOING);
                        if (hasVariantsRel == null) {
                            variantsNode = graphDb.createNode(variantsAggregationLabel);
                            hasVariantsRel = term.createRelationshipTo(variantsNode, variantRelationshipType);
                        }
                        variantsNode = hasVariantsRel.getEndNode();
                        for (String docId : variantCountsInDocs.keySet()) {
                            Map variantCounts = (Map)variantCountsInDocs.get(docId);
                            for (String variant : variantCounts.keySet()) {
                                String normalizedVariant = TermVariantComparator.normalizeVariant(variant);
                                Node variantNode = graphDb.findNode(variantNodeLabel, "id", normalizedVariant);
                                if (variantNode == null) {
                                    variantNode = graphDb.createNode(variantNodeLabel);
                                    variantNode.setProperty("id", normalizedVariant);
                                    variantNode.setProperty("name", variant);
                                }
                                PropertyContainer specificElementRel = null;
                                for (Relationship elementRel : variantNode.getRelationships(Direction.INCOMING, EdgeTypes.HAS_ELEMENT)) {
                                    if (!elementRel.getStartNode().equals(variantsNode) || !elementRel.getEndNode().equals(variantNode)) continue;
                                    specificElementRel = elementRel;
                                    break;
                                }
                                if (specificElementRel == null) {
                                    specificElementRel = variantsNode.createRelationshipTo(variantNode, EdgeTypes.HAS_ELEMENT);
                                    specificElementRel.setProperty("documents", new String[0]);
                                    specificElementRel.setProperty("counts", new int[0]);
                                }
                                Object[] documents = (String[])specificElementRel.getProperty("documents");
                                int[] counts = (int[])specificElementRel.getProperty("counts");
                                int docIndex = Arrays.binarySearch(documents, docId);
                                Integer count = (Integer)variantCounts.get(variant);
                                if (docIndex >= 0) {
                                    counts[docIndex] = count;
                                    continue;
                                }
                                int insertionPoint = -1 * (docIndex + 1);
                                String[] newDocuments = new String[documents.length + 1];
                                int[] newCounts = new int[newDocuments.length];
                                if (insertionPoint > 0) {
                                    System.arraycopy(documents, 0, newDocuments, 0, insertionPoint);
                                    System.arraycopy(counts, 0, newCounts, 0, insertionPoint);
                                }
                                newDocuments[insertionPoint] = docId;
                                newCounts[insertionPoint] = count;
                                if (insertionPoint < documents.length) {
                                    System.arraycopy(documents, insertionPoint, newDocuments, insertionPoint + 1, documents.length - insertionPoint);
                                    System.arraycopy(counts, insertionPoint, newCounts, insertionPoint + 1, counts.length - insertionPoint);
                                }
                                specificElementRel.setProperty("documents", newDocuments);
                                specificElementRel.setProperty("counts", newCounts);
                            }
                        }
                    }
                    jsonReader.endObject();
                    jsonReader.close();
                    tx.success();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static String[] getPropertyValueOfElements(Node aggregate, String property) {
        if (!aggregate.hasLabel(TermLabel.AGGREGATE)) {
            throw new IllegalArgumentException("Node " + NodeUtilities.getNodePropertiesAsString(aggregate) + " is not an aggregate.");
        }
        Iterable<Relationship> elementRels = aggregate.getRelationships(Direction.OUTGOING, EdgeTypes.HAS_ELEMENT);
        ArrayList<String> elementValues = new ArrayList<String>();
        for (Relationship elementRel : elementRels) {
            String[] value = NodeUtilities.getNodePropertyAsStringArrayValue(elementRel.getEndNode(), property);
            int i = 0;
            while (value != null && i < value.length) {
                elementValues.add(value[i]);
                ++i;
            }
        }
        return elementValues.isEmpty() ? null : elementValues.toArray(new String[elementValues.size()]);
    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_ELEMENT,
        HAS_ROOT_TERM,
        HAS_SAME_NAMES,
        IS_BROADER_THAN,
        IS_MAPPED_TO,
        HAS_VARIANTS,
        HAS_ACRONYMS;

    }

    private class InsertionReport {
        public Set<String> createdRelationshipsCache = new HashSet<String>();
        public Set<Node> existingTerms = new HashSet<Node>();
        public Set<String> omittedTerms = new HashSet<String>();
        public int numRelationships = 0;
        public int numTerms = 0;

        private InsertionReport() {
        }

        public void addCreatedRelationship(Node source, Node target, RelationshipType type) {
            this.createdRelationshipsCache.add(this.getRelationshipIdentifier(source, target, type));
        }

        public void addExistingTerm(Node term) {
            this.existingTerms.add(term);
        }

        private String getRelationshipIdentifier(Node source, Node target, RelationshipType type) {
            return String.valueOf(source.getId()) + type.name() + target.getId();
        }

        public boolean relationshipAlreadyWasCreated(Node source, Node target, RelationshipType type) {
            return this.createdRelationshipsCache.contains(this.getRelationshipIdentifier(source, target, type));
        }
    }

    public static enum MorphoLabel implements Label
    {
        WRITING_VARIANTS,
        ACRONYMS,
        WRITING_VARIANT,
        ACRONYM;

    }

    public static enum TermLabel implements Label
    {
        AGGREGATE,
        AGGREGATE_EQUAL_NAMES,
        HOLLOW,
        TERM,
        EVENT_TERM,
        AGGREGATE_ELEMENT;

    }
}

