/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.TermManager;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import de.julielab.neo4j.plugins.auxiliaries.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.RecursiveMappingRepresentation;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.tooling.GlobalGraphOperations;

public class Export
extends ServerPlugin {
    private static final Logger log = Logger.getLogger(Export.class.getName());
    public static final String EXPORT_ENDPOINT = "/db/data/ext/" + Export.class.getSimpleName() + "/graphdb/";
    public static final String HYPERNYMS = "hypernyms";
    public static final String LINGPIPE_DICT = "lingpipe_dictionary";
    public static final String TERM_TO_FACET = "term_facet_map";
    public static final String TERM_ID_MAPPING = "term_id_mapping";
    public static final String ELEMENT_TO_AGGREGATE_ID_MAPPING = "element_aggregate_id_mapping";
    public static final String PARAM_ID_PROPERTY = "id_property";
    public static final String PARAM_LABELS = "labels";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_EXCLUSION_LABEL = "exclusion_label";
    @Deprecated
    public static final String PARAM_FURTHER_PROPERTIES = "further_properties";
    public static final int OUTPUTSTREAM_INIT_SIZE = 200000000;
    public static final int HYPERNYMS_CACHE_SIZE = 100000;

    @Name(value="term_id_mapping")
    @Description(value="Creates the ID mapping file data required for LuCas' replace filter. The returned data is a JSON array of bytes. Those bytes represent the GZIPed string data of id mapping data. That is, to read the actual file content, the JSON array is to be converted to a byte[] which then serves as input for a ByteArrayInputStream which in turn goes through a GZIPInputStream for decoding. The result is a stream from which the mapping data can be read.")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation exportIdMapping(@Source GraphDatabaseService graphDb, @Parameter(name="id_property") @Description(value="TODO") String idProperty, @Parameter(name="labels") @Description(value="TODO") String labelStrings) throws Exception {
        log.info("Exporting ID mapping data.");
        JSONArray labelsArray = labelStrings != null ? new JSONArray(labelStrings) : null;
        log.info("Creating mapping file content for property \"" + idProperty + "\" and facets " + labelsArray);
        ByteArrayOutputStream gzipBytes = this.createIdMapping(graphDb, idProperty, labelsArray);
        byte[] bytes = gzipBytes.toByteArray();
        log.info("Sending all " + bytes.length + " bytes of GZIPed ID mapping file data.");
        log.info("Done exporting ID mapping data.");
        return RecursiveMappingRepresentation.getObjectRepresentation(bytes);
    }

    private ByteArrayOutputStream createIdMapping(GraphDatabaseService graphDb, String idProperty, JSONArray labelsArray) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        Throwable throwable = null;
        Object var6_7 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (Transaction tx = graphDb.beginTx();){
                int numWritten = 0;
                int i = 0;
                while (i < labelsArray.length()) {
                    String labelString = labelsArray.getString(i);
                    Label label = DynamicLabel.label(labelString);
                    ResourceIterator<Node> terms = graphDb.findNodes(label);
                    while (terms.hasNext()) {
                        Node term = (Node)terms.next();
                        String termId = (String)term.getProperty("id");
                        Object idObject = PropertyUtilities.getNonNullNodeProperty(term, idProperty);
                        if (idObject == null) continue;
                        if (idObject.getClass().isArray()) {
                            Object[] idArray = JulieNeo4jUtilities.convertArray(idObject);
                            int j = 0;
                            while (j < idArray.length) {
                                Object id = idArray[j];
                                IOUtils.write(id + "\t" + termId + "\n", (OutputStream)os, "UTF-8");
                                ++numWritten;
                                ++j;
                            }
                            continue;
                        }
                        IOUtils.write(idObject + "\t" + termId + "\n", (OutputStream)os, "UTF-8");
                        ++numWritten;
                    }
                    ++i;
                }
                log.info("Num written: " + numWritten);
                tx.success();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return baos;
    }

    @Name(value="hypernyms")
    @Description(value="Creates the hypernym file data required for LuCas' hypernym filter. The returned data is a JSON array of bytes. Those bytes represent the GZIPed string data of hypernym data. That is, to read the actual file content, the JSON array is to be converted to a byte[] which then serves as input for a ByteArrayInputStream which in turn goes through a GZIPInputStream for decoding. The result is a stream from which the hypernym data can be read.")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation exportHypernyms(@Source GraphDatabaseService graphDb, @Description(value="The facet labels indicating for which facets to create the hypernyms file") @Parameter(name="labels", optional=true) String facetLabelStrings, @Description(value="A label restricting hypernym generation to terms with this label.") @Parameter(name="label", optional=true) String termLabel) throws Exception {
        JSONArray labelsArray;
        JSONArray jSONArray = labelsArray = facetLabelStrings != null ? new JSONArray(facetLabelStrings) : null;
        if (labelsArray == null) {
            log.info("Exporting hypernyms dictionary data for all facets.");
        } else {
            log.info("Exporting hypernyms dictionary data for the facets with labels " + labelsArray.toString() + ".");
        }
        ByteArrayOutputStream hypernymsGzipBytes = this.writeHypernymList(graphDb, labelsArray, termLabel, 100000);
        byte[] bytes = hypernymsGzipBytes.toByteArray();
        log.info("Sending all " + bytes.length + " bytes of GZIPed hypernym file data.");
        log.info("Done exporting hypernym data.");
        return RecursiveMappingRepresentation.getObjectRepresentation(bytes);
    }

    private ByteArrayOutputStream writeHypernymList(GraphDatabaseService graphDb, JSONArray labelsArray, String termLabelString, int cacheSize) throws IOException, JSONException {
        JSONArray labels = labelsArray;
        if (labels == null) {
            labels = new JSONArray();
            labels.put(FacetManager.FacetLabel.FACET.name());
        }
        Label termLabel = null;
        if (!StringUtils.isBlank(termLabelString)) {
            termLabel = DynamicLabel.label(termLabelString);
        }
        HashMap<Node, Set<String>> cache = new HashMap<Node, Set<String>>(cacheSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        Throwable throwable = null;
        Object var10_11 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (Transaction tx = graphDb.beginTx();){
                ResourceIterable<Node> facets;
                Label label;
                String labelString;
                int i;
                ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
                if (labels.length() > 1 || !labels.getString(0).equals(FacetManager.FacetLabel.FACET.name())) {
                    i = 0;
                    while (i < labels.length()) {
                        labelString = labels.getString(i);
                        label = DynamicLabel.label(labelString);
                        facets = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(label);
                        for (Node facet : facets) {
                            if (!facet.hasLabel(FacetManager.FacetLabel.FACET)) {
                                throw new IllegalArgumentException("Label node " + facet + " with the label " + label + " is no facet since it does not have the " + FacetManager.FacetLabel.FACET + " label.");
                            }
                            String facetId = (String)facet.getProperty("id");
                            DynamicRelationshipType reltype = DynamicRelationshipType.withName(TermManager.EdgeTypes.IS_BROADER_THAN + "_" + facetId);
                            relationshipTypeList.add(reltype);
                        }
                        ++i;
                    }
                } else {
                    relationshipTypeList.add(TermManager.EdgeTypes.IS_BROADER_THAN);
                }
                i = 0;
                while (i < labels.length()) {
                    labelString = labels.getString(i);
                    label = DynamicLabel.label(labelString);
                    log.info("Now creating hypernyms for facets with label " + label);
                    facets = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(label);
                    HashSet<Node> visitedNodes = new HashSet<Node>();
                    for (Node facet : facets) {
                        Iterable<Relationship> rels = facet.getRelationships(Direction.OUTGOING, TermManager.EdgeTypes.HAS_ROOT_TERM);
                        for (Relationship rel : rels) {
                            Node rootTerm = rel.getEndNode();
                            if (termLabel != null && !rootTerm.hasLabel(termLabel)) continue;
                            this.writeHypernyms(rootTerm, visitedNodes, cache, os, relationshipTypeList.toArray(new RelationshipType[relationshipTypeList.size()]));
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return baos;
    }

    public Set<String> load(Node n, Map<Node, Set<String>> cache, RelationshipType[] relationshipTypes) {
        Set<String> hypernyms = cache.get(n);
        if (hypernyms != null) {
            return hypernyms;
        }
        hypernyms = new HashSet<String>();
        cache.put(n, hypernyms);
        HashSet<Node> visitedNodes = new HashSet<Node>();
        visitedNodes.add(n);
        for (Relationship rel : n.getRelationships(Direction.INCOMING, relationshipTypes)) {
            Node directHypernym = rel.getStartNode();
            boolean isHollow = false;
            for (Label l : directHypernym.getLabels()) {
                if (!l.equals(TermManager.TermLabel.HOLLOW)) continue;
                isHollow = true;
            }
            if (isHollow || visitedNodes.contains(directHypernym)) continue;
            String directHypernymId = ((String)directHypernym.getProperty("id")).intern();
            hypernyms.add(directHypernymId);
            hypernyms.addAll(this.load(directHypernym, cache, relationshipTypes));
        }
        visitedNodes.remove(n);
        return hypernyms;
    }

    private void writeHypernyms(Node n, Set<Node> visitedNodes, Map<Node, Set<String>> cache, GZIPOutputStream os, RelationshipType[] relationshipTypes) throws IOException {
        if (visitedNodes.contains(n)) {
            return;
        }
        this.load(n, cache, relationshipTypes);
        visitedNodes.add(n);
        boolean isHollow = false;
        for (Label l : n.getLabels()) {
            if (!l.equals(TermManager.TermLabel.HOLLOW)) continue;
            isHollow = true;
        }
        if (isHollow) {
            return;
        }
        Set<String> hypernyms = cache.get(n);
        if (hypernyms.size() > 0) {
            IOUtils.write(n.getProperty("id") + "\t" + StringUtils.join(hypernyms, "|") + "\n", (OutputStream)os, "UTF-8");
        }
        for (Relationship rel : n.getRelationships(Direction.OUTGOING, TermManager.EdgeTypes.IS_BROADER_THAN)) {
            this.writeHypernyms(rel.getEndNode(), visitedNodes, cache, os, relationshipTypes);
        }
        if (visitedNodes.size() % 100000 == 0) {
            log.info("Finished " + visitedNodes.size() + ".");
        }
    }

    @Name(value="lingpipe_dictionary")
    @Description(value="Creates a dictionary of all synonyms and writing variants for terms with label label and without label exclusion_label in the database. The dictionary has two columns, the synonym/writing variant and the term's ID. This dictionary is used with the Lingpipe chunker to recognize database terms in user queries. The returned data is a Base64 encoded string. This string represents the GZIPed string data of the dictionary. That is, to read the actual file content, the Base64 encoded string so to be decoded into a byte[] which then serves as input for a ByteArrayInputStream which in turn goes through a GZIPInputStream for decoding. The result is a stream from which the dictionary data can be read.")
    @PluginTarget(value=GraphDatabaseService.class)
    public String exportLingpipeDictionary(@Source GraphDatabaseService graphDb, @Description(value="The label to select the terms for which to create the dictionary.") @Parameter(name="label", optional=true) String labelString, @Description(value="A JSON list of labels that exclude terms from used for the dictionary.") @Parameter(name="exclusion_label", optional=true) String exclusionLabelString, @Description(value="The node properties providing the lingpipe chunker category. May refer to array-valued property. In case multiple properties are given, their values will be concatenated by two pipes (||). NOTE that it is expected that array-valued properties are or of the same size. The concatenation will be done for the same index in all value-arrays, i.e. not all combinations are built. For aggregates that not have a requested properties, their elements will be used instead.") @Parameter(name="id_property", optional=true) String[] nodeCategories) throws IOException {
        String string22;
        Label label = StringUtils.isBlank(labelString) ? TermManager.TermLabel.TERM : DynamicLabel.label(labelString);
        ArrayList<String> propertiesToWrite = new ArrayList<String>();
        if (nodeCategories == null || nodeCategories.length == 0) {
            propertiesToWrite.add("id");
        } else {
            int i = 0;
            while (i < nodeCategories.length) {
                String property = nodeCategories[i];
                propertiesToWrite.add(property);
                ++i;
            }
        }
        Label[] exclusionLabels = null;
        if (!StringUtils.isBlank(exclusionLabelString)) {
            try {
                JSONArray exclusionLabelsJson = new JSONArray(exclusionLabelString);
                exclusionLabels = new Label[exclusionLabelsJson.length()];
                int i = 0;
                while (i < exclusionLabelsJson.length()) {
                    string22 = exclusionLabelsJson.getString(i);
                    exclusionLabels[i] = DynamicLabel.label(string22);
                    ++i;
                }
            }
            catch (JSONException e) {
                Label exclusionLabel = DynamicLabel.label(exclusionLabelString);
                exclusionLabels = new Label[]{exclusionLabel};
            }
        }
        log.info("Exporting lingpipe dictionary data for nodes with label \"" + label.name() + "\", mapping their names to their properties " + propertiesToWrite + ".");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        Throwable exclusionLabel = null;
        string22 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            Throwable throwable = null;
            Object var13_20 = null;
            try (Transaction tx = graphDb.beginTx();){
                ResourceIterator<Node> terms = graphDb.findNodes(label);
                int count = 0;
                while (terms.hasNext()) {
                    Node term = (Node)terms.next();
                    ++count;
                    boolean termHasExclusionLabel = false;
                    int i = 0;
                    while (exclusionLabels != null && i < exclusionLabels.length) {
                        Label exclusionLabel2 = exclusionLabels[i];
                        if (term.hasLabel(exclusionLabel2)) {
                            termHasExclusionLabel = true;
                            break;
                        }
                        ++i;
                    }
                    if (!termHasExclusionLabel && term.hasProperty("id") && term.hasProperty("preferredName")) {
                        String idProperty = (String)propertiesToWrite.get(0);
                        String[] value = NodeUtilities.getNodePropertyAsStringArrayValue(term, idProperty);
                        if (value == null && term.hasLabel(TermManager.TermLabel.AGGREGATE)) {
                            value = TermManager.getPropertyValueOfElements(term, idProperty);
                        }
                        if (value == null) {
                            terms.close();
                            throw new IllegalArgumentException("Term " + NodeUtilities.getNodePropertiesAsString(term) + " does not have a value for the property " + idProperty);
                        }
                        int arraySize = value.length;
                        ArrayList<String> categoryStrings = new ArrayList<String>();
                        int i2 = 0;
                        while (i2 < arraySize) {
                            StringBuilder sb = new StringBuilder();
                            int j = 0;
                            while (j < propertiesToWrite.size()) {
                                String property = (String)propertiesToWrite.get(j);
                                value = NodeUtilities.getNodePropertyAsStringArrayValue(term, property);
                                if (value == null && term.hasLabel(TermManager.TermLabel.AGGREGATE)) {
                                    value = TermManager.getPropertyValueOfElements(term, idProperty);
                                }
                                if (value == null || value.length == 0) {
                                    terms.close();
                                    throw new IllegalArgumentException("The property \"" + property + "\" does not contain a value for node " + term + " (properties: " + PropertyUtilities.getNodePropertiesAsString(term) + ")");
                                }
                                if (value.length != arraySize) {
                                    terms.close();
                                    throw new IllegalArgumentException("The properties \"" + propertiesToWrite + "\" on term " + PropertyUtilities.getNodePropertiesAsString(term) + " do not have all the same number of value elements which is required for dictionary creation by this method.");
                                }
                                sb.append(value[i2]);
                                if (j < propertiesToWrite.size() - 1) {
                                    sb.append("||");
                                }
                                ++j;
                            }
                            categoryStrings.add(sb.toString());
                            ++i2;
                        }
                        for (String categoryString : categoryStrings) {
                            String preferredName = (String)term.getProperty("preferredName");
                            String[] synonyms = new String[]{};
                            if (term.hasProperty("synonyms")) {
                                synonyms = (String[])term.getProperty("synonyms");
                            }
                            this.writeNormalizedDictionaryEntry(preferredName, categoryString, os);
                            String[] stringArray = synonyms;
                            int n = synonyms.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String synonString = stringArray[n2];
                                this.writeNormalizedDictionaryEntry(synonString, categoryString, os);
                                ++n2;
                            }
                            TraversalDescription acronymsTraversal = PredefinedTraversals.getAcronymsTraversal(graphDb);
                            Traverser traverse = acronymsTraversal.traverse(term);
                            for (Node acronymNode : traverse.nodes()) {
                                String acronym = (String)acronymNode.getProperty("name");
                                this.writeNormalizedDictionaryEntry(acronym, categoryString, os);
                            }
                        }
                    }
                    if (count % 100000 != 0) continue;
                    log.info(String.valueOf(count) + " terms processed.");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable string22) {
            if (exclusionLabel == null) {
                exclusionLabel = string22;
            } else if (exclusionLabel != string22) {
                exclusionLabel.addSuppressed(string22);
            }
            throw exclusionLabel;
        }
        log.info("Done exporting Lingpipe term dictionary.");
        byte[] bytes = baos.toByteArray();
        String encoded = DatatypeConverter.printBase64Binary((byte[])bytes);
        return encoded;
    }

    private void writeNormalizedDictionaryEntry(String name, String termId, OutputStream os) throws IOException {
        String normalizedName = StringUtils.normalizeSpace(name);
        if (normalizedName.length() > 2) {
            IOUtils.write(String.valueOf(normalizedName) + "\t" + termId + "\n", os, "UTF-8");
        }
    }

    @Name(value="term_facet_map")
    @Description(value="Creates a map <term id>=<facet id> for all terms in the database. For terms that belong to multiple facets, several lines are created. The returned data is a JSON array of bytes. Those bytes represent the GZIPed string data of the dictionary. That is, to read the actual file content, the JSON array is to be converted to a byte[] which then serves as input for a ByteArrayInputStream which in turn goes through a GZIPInputStream for decoding. The result is a stream from which the dictionary data can be read.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static Representation exportTermFacetMapping(@Source GraphDatabaseService graphDb, @Description(value="The term label to create the ID map for. Defaults to TERM.") @Parameter(name="label", optional=true) String labelString) throws IOException {
        log.info("Exporting lingpipe dictionary data.");
        Label label = !StringUtils.isBlank(labelString) ? DynamicLabel.label(labelString) : TermManager.TermLabel.TERM;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (Transaction tx = graphDb.beginTx();){
                ResourceIterable<Node> terms = GlobalGraphOperations.at(graphDb).getAllNodesWithLabel(label);
                int count = 0;
                for (Node term : terms) {
                    ++count;
                    if (term.hasProperty("id") && term.hasProperty("facets")) {
                        String termId = (String)term.getProperty("id");
                        Object[] facetIds = (String[])term.getProperty("facets");
                        IOUtils.write(String.valueOf(termId) + "\t" + StringUtils.join(facetIds, "|") + "\n", (OutputStream)os, "UTF-8");
                    }
                    if (count % 100000 != 0) continue;
                    log.info(String.valueOf(count) + " terms processed.");
                }
                log.info("Done exporting mapping from term ID to corresponding facet IDs.");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return RecursiveMappingRepresentation.getObjectRepresentation(baos.toByteArray());
    }

    @Name(value="element_aggregate_id_mapping")
    @Description(value="Creates a mapping file from aggregate element IDs to their respective aggregate ID. Currently, only non-aggregate elements are eligible.")
    @PluginTarget(value=GraphDatabaseService.class)
    public String exportElementToAggregateIdMapping(@Source GraphDatabaseService graphDb, @Parameter(name="label") @Description(value="The aggregate labels for which to create the mapping") String aggLabelStrings) throws Exception {
        log.info("Exporting element-aggregate ID mapping data.");
        JSONArray labelsArray = new JSONArray(aggLabelStrings);
        log.info("Creating element-aggregate ID mapping file content for aggregate labels \"" + labelsArray + "\"");
        ByteArrayOutputStream gzipBytes = this.createElementAggregateIdMapping(graphDb, labelsArray);
        byte[] bytes = gzipBytes.toByteArray();
        log.info("Sending all " + bytes.length + " bytes of GZIPed ID element-aggregate ID mapping file data.");
        String encoded = DatatypeConverter.printBase64Binary((byte[])bytes);
        log.info("Done exporting element-aggregate ID mapping data.");
        return encoded;
    }

    private ByteArrayOutputStream createElementAggregateIdMapping(GraphDatabaseService graphDb, JSONArray aggLabelsArray) throws IOException, JSONException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (Transaction tx = graphDb.beginTx();){
                HashMap<String, String> ele2Agg = new HashMap<String, String>();
                HashSet<String> visitedAggregates = new HashSet<String>();
                int i = 0;
                while (i < aggLabelsArray.length()) {
                    Label label = DynamicLabel.label(aggLabelsArray.getString(i));
                    ResourceIterator<Node> aggregates = graphDb.findNodes(label);
                    TraversalDescription td = PredefinedTraversals.getNonAggregateAggregateElements(graphDb);
                    while (aggregates.hasNext()) {
                        Node aggregate = (Node)aggregates.next();
                        String aggregateId = (String)aggregate.getProperty("id");
                        if (!visitedAggregates.add(aggregateId)) continue;
                        Traverser traverse = td.traverse(aggregate);
                        for (Path elementPath : traverse) {
                            for (Node n : elementPath.nodes()) {
                                if (!n.hasLabel(TermManager.TermLabel.AGGREGATE)) continue;
                                visitedAggregates.add((String)n.getProperty("id"));
                            }
                            Node element = elementPath.endNode();
                            if (!element.hasProperty("id")) {
                                log.warning("Node " + element.getId() + " does not have the ID property " + "id" + " and is discarded for the creation of the element aggregate ID mapping.");
                                continue;
                            }
                            String elementId = (String)element.getProperty("id");
                            ele2Agg.put(elementId, aggregateId);
                        }
                    }
                    ++i;
                }
                int numWritten = 0;
                for (String elementId : ele2Agg.keySet()) {
                    String aggregateId = (String)ele2Agg.get(elementId);
                    IOUtils.write(String.valueOf(elementId) + "\t" + aggregateId + "\n", (OutputStream)os, "UTF-8");
                    ++numWritten;
                }
                log.info("Num written: " + numWritten);
                tx.success();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return baos;
    }
}

