/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.ontologies;

import com.google.gson.Gson;
import de.julielab.bioportal.ontologies.data.Submission;
import de.julielab.bioportal.util.BioPortalToolUtils;
import de.julielab.java.utilities.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationPropertySet {
    private static final Logger log = LoggerFactory.getLogger(AnnotationPropertySet.class);
    private List<OWLAnnotationProperty> prefNameProps = new ArrayList<OWLAnnotationProperty>();
    private List<OWLAnnotationProperty> synonymProps = new ArrayList<OWLAnnotationProperty>();
    private List<OWLAnnotationProperty> definitionProps = new ArrayList<OWLAnnotationProperty>();
    private List<OWLAnnotationProperty> obsoleteProps = new ArrayList<OWLAnnotationProperty>();

    public AnnotationPropertySet(OWLOntologyManager ontologyManager, Submission submission) {
        this.setupAnnotationProperties(ontologyManager, submission);
    }

    public AnnotationPropertySet(OWLOntologyManager ontologyManager, File submissionFile) throws FileNotFoundException, IOException {
        Gson gson = BioPortalToolUtils.getGson();
        Submission submission = null;
        if (submissionFile.exists()) {
            String submissionString = IOUtils.toString((InputStream)FileUtilities.getInputStreamFromFile(submissionFile), Charset.forName("UTF-8"));
            submission = gson.fromJson(submissionString, Submission.class);
        } else {
            log.debug("No submission file {} was found, using default annotation properties.", (Object)submissionFile);
        }
        this.setupAnnotationProperties(ontologyManager, submission);
    }

    private void setupAnnotationProperties(OWLOntologyManager ontologyManager, Submission submission) {
        OWLDataFactory df = ontologyManager.getOWLDataFactory();
        log.trace("Submission {} specifies the following properties:", (Object)(submission != null ? submission.id : null));
        if (submission == null) {
            log.trace("None.");
        }
        if (submission != null) {
            if (submission.prefLabelProperty != null) {
                this.prefNameProps.add(df.getOWLAnnotationProperty(IRI.create(submission.prefLabelProperty)));
                log.trace("Preferred label: {}", (Object)submission.prefLabelProperty);
            }
            if (submission.synonymProperty != null) {
                this.synonymProps.add(df.getOWLAnnotationProperty(IRI.create(submission.synonymProperty)));
                log.trace("Synonyms: {}", (Object)submission.synonymProperty);
            }
            if (submission.definitionProperty != null) {
                this.definitionProps.add(df.getOWLAnnotationProperty(IRI.create(submission.definitionProperty)));
                log.trace("Definition: {}", (Object)submission.definitionProperty);
            }
            if (submission.obsoleteProperty != null) {
                this.obsoleteProps.add(df.getOWLAnnotationProperty(IRI.create(submission.obsoleteProperty)));
                log.trace("Obsolete classes: {}", (Object)submission.obsoleteProperty);
            }
        }
        this.addDefaultAnnotationProperties(ontologyManager);
    }

    public List<OWLAnnotationProperty> getPrefNameProps() {
        return this.prefNameProps;
    }

    public List<OWLAnnotationProperty> getSynonymProps() {
        return this.synonymProps;
    }

    public List<OWLAnnotationProperty> getDefinitionProps() {
        return this.definitionProps;
    }

    public List<OWLAnnotationProperty> getObsoleteProps() {
        return this.obsoleteProps;
    }

    private void addDefaultAnnotationProperties(OWLOntologyManager ontologyManager) {
        OWLDataFactory df = ontologyManager.getOWLDataFactory();
        this.prefNameProps.add(df.getRDFSLabel());
        this.prefNameProps.add(df.getOWLAnnotationProperty(IRI.create("http://www.w3.org/2004/02/skos/core#prefLabel")));
        this.prefNameProps.add(df.getOWLAnnotationProperty(IRI.create("http://purl.obolibrary.org/obo/IAO_0000111")));
        this.synonymProps.add(df.getOWLAnnotationProperty(IRI.create("http://www.w3.org/2004/02/skos/core#altLabel")));
        this.synonymProps.add(df.getOWLAnnotationProperty(IRI.create("http://www.geneontology.org/formats/oboInOwl#hasExactSynonym")));
        this.synonymProps.add(df.getOWLAnnotationProperty(IRI.create("http://purl.obolibrary.org/obo/IAO_0000118")));
        this.definitionProps.add(df.getOWLAnnotationProperty(IRI.create("http://www.w3.org/2004/02/skos/core#definition")));
        this.definitionProps.add(df.getOWLAnnotationProperty(IRI.create("http://www.geneontology.org/formats/oboInOwl#hasDefinition")));
        this.definitionProps.add(df.getOWLAnnotationProperty(IRI.create("http://purl.obolibrary.org/obo/IAO_0000115")));
        this.obsoleteProps.add(df.getOWLDeprecated());
    }
}

