/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

public class ProgressBar {
    private final long total;
    private final long startTime = System.nanoTime();
    private long done;
    private int linewidth = 80;
    private boolean showTime = false;
    private long elapsedTime = 0L;

    public ProgressBar(long total, long done, int linewidth, boolean showTime) {
        this.total = total;
        this.done = done;
        this.linewidth = linewidth;
        this.showTime = showTime;
    }

    public ProgressBar(long total, int linewidth, boolean showTime) {
        this.total = total;
        this.linewidth = linewidth;
        this.showTime = showTime;
    }

    public ProgressBar(long total, int linewidth) {
        this.total = total;
        this.linewidth = linewidth;
    }

    public ProgressBar() {
        this.total = -1L;
    }

    public ProgressBar(int linewidth) {
        this.total = 0L;
        this.linewidth = linewidth;
    }

    public ProgressBar(long total) {
        this.total = total;
    }

    public long getTotal() {
        return this.total;
    }

    public long getDone() {
        return this.done;
    }

    public int getLinewidth() {
        return this.linewidth;
    }

    public void incrementDone() {
        this.elapsedTime = System.nanoTime() - this.startTime;
        ++this.done;
    }

    public void incrementDone(long delta) {
        this.elapsedTime = System.nanoTime() - this.startTime;
        this.done += delta;
    }

    public void incrementDone(boolean printProgressBar) {
        this.incrementDone();
        if (printProgressBar) {
            this.printProgressBar();
        }
    }

    public void incrementDone(long delta, boolean printProgressBar) {
        this.incrementDone(delta);
        if (printProgressBar) {
            this.printProgressBar();
        }
    }

    public void printProgressBar() {
        StringBuilder sb = new StringBuilder();
        if (this.total > 0L) {
            double percentage = (double)this.done / (double)this.total;
            int progress = (int)((double)this.linewidth * percentage);
            sb.append("[");
            for (int j = 0; j < this.linewidth; ++j) {
                if (j < progress) {
                    sb.append("=");
                    continue;
                }
                sb.append(" ");
            }
            sb.append("] ").append(this.done).append("/").append(this.total);
        } else {
            sb.append(this.done).append("/").append(this.total);
        }
        if (this.showTime) {
            double elapsedSeconds = (double)this.elapsedTime / Math.pow(10.0, 9.0);
            double avgTime = elapsedSeconds / (double)this.done;
            sb.append(" (").append((long)elapsedSeconds).append("s elapsed,").append(" ").append(String.format("%.3f", avgTime)).append("s per item");
            if (this.total > 0L) {
                sb.append(", ETA ").append((long)(avgTime * (double)this.total - elapsedSeconds)).append("s");
            }
            sb.append(")");
        }
        sb.append("\r");
        System.out.print(sb);
    }
}

