/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtilities {
    private static final Logger log = LoggerFactory.getLogger(CompressionUtilities.class);

    public static File extract(File from, File to, boolean deleteArchive) throws IOException {
        ArchiveEntry entry;
        Archiver archiver = ArchiverFactory.createArchiver(from);
        log.debug("Extracting archive {} to {}", (Object)from, (Object)to);
        archiver.extract(from, to);
        ArchiveStream archiveStream = archiver.stream(from);
        String firstEntryName = null;
        while ((entry = archiveStream.getNextEntry()) != null && firstEntryName == null) {
            if (!entry.isDirectory()) continue;
            firstEntryName = entry.getName();
        }
        File firstEntryFile = new File(to.getAbsolutePath() + File.separator + firstEntryName);
        if (deleteArchive) {
            log.debug("Deleting archive file {}", (Object)from);
            if (!from.delete()) {
                throw new IOException("Could not delete the archive at " + from.getAbsolutePath());
            }
        }
        return firstEntryFile;
    }

    public static Iterator<Pair<ArchiveEntry, InputStream>> getArchiveEntryInputStreams(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver(archive);
        final ArchiveStream stream = archiver.stream(archive);
        return new Iterator<Pair<ArchiveEntry, InputStream>>(){
            boolean exhausted = false;
            private ArchiveEntry currentEntry;

            @Override
            public boolean hasNext() {
                if (this.currentEntry == null && !this.exhausted) {
                    try {
                        this.currentEntry = stream.getNextEntry();
                        while (this.currentEntry != null && this.currentEntry.isDirectory()) {
                            this.currentEntry = stream.getNextEntry();
                        }
                        if (this.currentEntry == null) {
                            this.exhausted = true;
                        }
                    }
                    catch (IOException e) {
                        log.error("Could not get next archive entry", e);
                    }
                }
                return !this.exhausted;
            }

            @Override
            public Pair<ArchiveEntry, InputStream> next() {
                if (this.hasNext()) {
                    ImmutablePair<ArchiveEntry, InputStream> ret = new ImmutablePair<ArchiveEntry, InputStream>(this.currentEntry, new LimitedInputStream(this.currentEntry.getSize(), stream));
                    this.currentEntry = null;
                    return ret;
                }
                return null;
            }
        };
    }

    private static class LimitedInputStream
    extends InputStream {
        private final InputStream is;
        private long limit;

        public LimitedInputStream(long limit, InputStream is) {
            this.limit = limit;
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            int data = -1;
            if (this.limit > 0L) {
                data = this.is.read();
            }
            if (data >= 0) {
                --this.limit;
            }
            return data;
        }
    }
}

