/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import de.julielab.xml.JulieXMLTools;
import de.julielab.xml.JulieXMLToolsCLI;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class JulieXMLToolsCLIRecords {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: " + JulieXMLToolsCLI.class.getName() + " <XML file> <record XPath expression> <field XPath expression> <field XPath expression>*");
            System.out.println("This tool is meant to extract particular fields of XML files representing a list of records. The result is a table where each field XPath expression is evaluated for one field.");
            System.out.println("The record XPath expression must point to the list of records, i.e. typically a repeating path. The field XPath must be relative to the record XPath!");
            System.out.println("If a field XPath may be evaluated multiple times, i.e. the element pointed to exists more than once (lists), all values will be concatenated with a comma by default. Set the system property de.julielab.xmltools.delim to another delimiter if required. The special value 'explode' on this property will cause the output of all combinations of all arrays elements with all other column values.");
            System.exit(1);
        }
        String fileName = args[0];
        String forEach = args[1];
        String[] fieldPaths = new String[args.length - 2];
        System.arraycopy(args, 2, fieldPaths, 0, fieldPaths.length);
        String delimiter = System.getProperty("de.julielab.xmltools.delim");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        for (int i = 0; i < fieldPaths.length; ++i) {
            String path = fieldPaths[i];
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", "fieldvalue" + i);
            field.put("xpath", path);
            if (delimiter != null && !delimiter.equals("explode")) {
                field.put("concatString", delimiter);
            } else if (delimiter != null) {
                field.put("returnValuesAsArray", "true");
            }
            fields.add(field);
        }
        Iterator<Map<String, Object>> rowIterator = JulieXMLTools.constructRowIterator(fileName, 4096, forEach, fields, false);
        PrintStream out = null;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ArrayList outputRowList = new ArrayList();
        while (rowIterator.hasNext()) {
            Map<String, Object> row = rowIterator.next();
            for (int i = 0; i < fieldPaths.length; ++i) {
                Object object = row.get("fieldvalue" + i);
                if (object instanceof String) {
                    if (i == 0) {
                        outputRowList.add(Stream.of((String)object).collect(Collectors.toList()));
                        continue;
                    }
                    for (List list : outputRowList) {
                        list.add((String)object);
                    }
                    continue;
                }
                if (!(object instanceof String[])) continue;
                ArrayList<List<Object>> extendedOutputRowList = new ArrayList<List<Object>>();
                String[] stringArray = (String[])object;
                if (i == 0) {
                    extendedOutputRowList.add(Arrays.stream(stringArray).collect(Collectors.toList()));
                } else {
                    for (String columnValue : stringArray) {
                        for (List list : outputRowList) {
                            ArrayList<String> extendedOutputRow = new ArrayList<String>(list);
                            extendedOutputRow.add(columnValue);
                            extendedOutputRowList.add(extendedOutputRow);
                        }
                    }
                }
                outputRowList = extendedOutputRowList;
            }
            for (List list : outputRowList) {
                out.println(StringUtils.join(list, "\t"));
            }
            outputRowList.clear();
        }
    }
}

