/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.VTDNav_L5;

public class TextIter {
    private int prevLocation;
    protected int depth;
    protected int index;
    protected VTDNav vn = null;
    private int lcIndex;
    private int lcLower;
    private int lcUpper;
    private int sel_type = 0;
    private String piName = null;

    public void selectText() {
        this.sel_type = 0;
    }

    public void selectComment() {
        this.sel_type = 1;
    }

    public void selectPI0() {
        this.sel_type = 2;
    }

    public void selectPI1(String string) {
        this.sel_type = 3;
        this.piName = string;
    }

    public void selectNode() {
        this.sel_type = 4;
    }

    public int getNext() {
        if (this.vn == null) {
            throw new IllegalArgumentException(" VTDNav instance can't be null");
        }
        if (this.vn.shallowDepth) {
            switch (this.depth) {
                case -1: {
                    return this.handleDocumentNode();
                }
                case 0: {
                    return this.handleLevel0();
                }
                case 1: {
                    return this.handleLevel1();
                }
                case 2: {
                    return this.handleLevel2();
                }
            }
            return this.handleDefault();
        }
        switch (this.depth) {
            case -1: {
                return this.handleDocumentNode();
            }
            case 0: {
                return this.handleLevel0();
            }
            case 1: {
                return this.handleLevel1();
            }
            case 2: {
                return this._handleLevel2();
            }
            case 3: {
                return this.handleLevel3();
            }
            case 4: {
                return this.handleLevel4();
            }
        }
        return this.handleDefault();
    }

    private final boolean isText(int n) {
        int n2 = this.vn.getTokenType(n);
        switch (this.sel_type) {
            case 0: {
                return n2 == 5 || n2 == 11;
            }
            case 1: {
                return n2 == 6;
            }
            case 2: {
                return n2 == 7;
            }
            case 3: {
                try {
                    return this.vn.matchRawTokenString(n, this.piName);
                }
                catch (NavException navException) {
                    return false;
                }
            }
            case 4: {
                return n2 != 8;
            }
        }
        return false;
    }

    public void touch(VTDNav vTDNav) {
        if (vTDNav == null) {
            throw new IllegalArgumentException(" VTDNav instance can't be null");
        }
        this.depth = vTDNav.context[0];
        this.index = this.depth == -1 ? 0 : (this.depth != 0 ? vTDNav.context[this.depth] : vTDNav.rootIndex);
        this.vn = vTDNav;
        this.prevLocation = -1;
        this.lcIndex = -1;
        this.lcUpper = -1;
        this.lcLower = -1;
    }

    private int increment(int n) {
        int n2;
        int n3 = this.vn.getTokenType(n);
        int n4 = this.vn.vtdBuffer.size;
        for (n2 = n + 1; n2 < n4 && this.depth == this.vn.getTokenDepth(n2) && n3 == this.vn.getTokenType(n2) && this.vn.getTokenOffset(n2 - 1) + (int)((this.vn.vtdBuffer.longAt(n2 - 1) & 0xFFFFF00000000L) >> 32) == this.vn.getTokenOffset(n2); ++n2) {
        }
        return n2;
    }

    private int handleLevel0() {
        int n;
        int n2 = n = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (this.vn.l1Buffer.size != 0) {
            int n3 = this.vn.l1Buffer.upper32At(0);
            int n4 = this.vn.l1Buffer.upper32At(this.vn.l1Buffer.size - 1);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : 0;
            while (n < this.vn.vtdSize) {
                if (n >= n3 && n < n4) {
                    int n6 = this.vn.l1Buffer.upper32At(this.lcIndex);
                    if (n == n6) {
                        ++this.lcIndex;
                        n = this.vn.l1Buffer.upper32At(this.lcIndex) - 1;
                        boolean bl = false;
                        while (this.vn.getTokenDepth(n) == 0) {
                            bl = true;
                            --n;
                        }
                        if (bl) {
                            ++n;
                        }
                    }
                    if (this.isText(n) && this.vn.getTokenDepth(n) == 0) {
                        this.prevLocation = n;
                        return n;
                    }
                    ++n;
                    continue;
                }
                if (n < n3) {
                    if (this.isText(n) && this.vn.getTokenDepth(n) == 0) {
                        this.prevLocation = n;
                        return n;
                    }
                    ++n;
                    continue;
                }
                if (n == n4) {
                    n = this.vn.vtdBuffer.size - 1;
                    while (this.vn.getTokenDepth(n) <= 0) {
                        --n;
                    }
                    ++n;
                }
                if (n >= this.vn.vtdSize) {
                    return -1;
                }
                if (this.isText(n) && this.vn.getTokenDepth(n) == 0) {
                    this.prevLocation = n;
                    return n;
                }
                if (this.vn.getTokenDepth(n) > 1) break;
                ++n;
            }
            return -1;
        }
        while (n < this.vn.vtdSize) {
            if (this.isText(n) && this.vn.getTokenDepth(n) == 0) {
                this.prevLocation = n;
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int handleLevel1() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.prevLocation != -1) {
            n4 = this.increment(this.prevLocation);
        } else {
            this.lcLower = this.vn.l1Buffer.lower32At(this.vn.l1index);
            if (this.lcLower != -1) {
                this.lcUpper = this.vn.l2Buffer.size - 1;
                n3 = this.vn.l1Buffer.size;
                for (n2 = this.vn.l1index + 1; n2 < n3; ++n2) {
                    n = this.vn.l1Buffer.lower32At(n2);
                    if (n == -1) continue;
                    this.lcUpper = n - 1;
                    break;
                }
            }
            n4 = this.index + 1;
        }
        if (this.lcLower != -1) {
            n3 = this.vn.l2Buffer.upper32At(this.lcLower);
            n2 = this.vn.l2Buffer.upper32At(this.lcUpper);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (n4 < this.vn.vtdSize) {
                n = this.vn.l2Buffer.upper32At(this.lcIndex);
                if (n4 >= n3 && n4 < n2) {
                    if (n4 == n) {
                        ++this.lcIndex;
                        n4 = this.vn.l2Buffer.upper32At(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(n4) == 1) {
                            --n4;
                        }
                        ++n4;
                    }
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 1) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (n4 < n3) {
                    if (this.isText(n4)) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (this.isText(n4) && this.vn.getTokenDepth(n4) == 1) {
                    this.prevLocation = n4;
                    return n4;
                }
                if (this.vn.getTokenType(n4) == 0 && this.vn.getTokenDepth(n4) < 2 || this.vn.getTokenDepth(n4) < 1) break;
                ++n4;
            }
            return -1;
        }
        if (n4 >= this.vn.vtdSize) {
            return -1;
        }
        n3 = this.vn.getTokenDepth(n4);
        n2 = this.vn.getTokenType(n4);
        while (n4 < this.vn.vtdSize && n3 >= 1 && (n3 != 1 || n2 != 0)) {
            if (this.isText(n4)) {
                this.prevLocation = n4;
                return n4;
            }
            n3 = this.vn.getTokenDepth(++n4);
            n2 = this.vn.getTokenType(n4);
        }
        return -1;
    }

    private int handleLevel2() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.prevLocation != -1) {
            n4 = this.increment(this.prevLocation);
        } else {
            this.lcLower = this.vn.l2Buffer.lower32At(this.vn.l2index);
            if (this.lcLower != -1) {
                this.lcUpper = this.vn.l3Buffer.size - 1;
                n3 = this.vn.l2Buffer.size;
                for (n2 = this.vn.l2index + 1; n2 < n3; ++n2) {
                    n = this.vn.l2Buffer.lower32At(n2);
                    if (n == -1) continue;
                    this.lcUpper = n - 1;
                    break;
                }
            }
            n4 = this.index + 1;
        }
        if (this.lcLower != -1) {
            n3 = this.vn.l3Buffer.intAt(this.lcLower);
            n2 = this.vn.l3Buffer.intAt(this.lcUpper);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (n4 < this.vn.vtdSize) {
                n = this.vn.l3Buffer.intAt(this.lcIndex);
                if (n4 >= n3 && n4 < n2) {
                    if (n4 == n) {
                        ++this.lcIndex;
                        n4 = this.vn.l3Buffer.intAt(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(n4) == 2) {
                            --n4;
                        }
                        ++n4;
                    }
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 2) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (n4 < n3) {
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 2) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (this.isText(n4) && this.vn.getTokenDepth(n4) == 2) {
                    this.prevLocation = n4;
                    return n4;
                }
                if (this.vn.getTokenType(n4) == 0 && this.vn.getTokenDepth(n4) < 3 || this.vn.getTokenDepth(n4) < 2) break;
                ++n4;
            }
            return -1;
        }
        if (n4 >= this.vn.vtdSize) {
            return -1;
        }
        n3 = this.vn.getTokenDepth(n4);
        n2 = this.vn.getTokenType(n4);
        while (n4 < this.vn.vtdSize && n3 >= 2 && (n3 != 2 || n2 != 0)) {
            if (this.isText(n4) && this.vn.getTokenDepth(n4) == 2) {
                this.prevLocation = n4;
                return n4;
            }
            n3 = this.vn.getTokenDepth(++n4);
            n2 = this.vn.getTokenType(n4);
        }
        return -1;
    }

    private int handleLevel3() {
        int n;
        int n2;
        int n3;
        int n4;
        VTDNav_L5 vTDNav_L5 = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            n4 = this.increment(this.prevLocation);
        } else {
            this.lcLower = vTDNav_L5.l3Buffer.lower32At(vTDNav_L5.l3index);
            if (this.lcLower != -1) {
                this.lcUpper = vTDNav_L5.l4Buffer.size - 1;
                n3 = vTDNav_L5.l3Buffer.size;
                for (n2 = vTDNav_L5.l3index + 1; n2 < n3; ++n2) {
                    n = vTDNav_L5.l3Buffer.lower32At(n2);
                    if (n == -1) continue;
                    this.lcUpper = n - 1;
                    break;
                }
            }
            n4 = this.index + 1;
        }
        if (this.lcLower != -1) {
            n3 = vTDNav_L5.l4Buffer.upper32At(this.lcLower);
            n2 = vTDNav_L5.l4Buffer.upper32At(this.lcUpper);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (n4 < this.vn.vtdSize) {
                n = vTDNav_L5.l4Buffer.upper32At(this.lcIndex);
                if (n4 >= n3 && n4 < n2) {
                    if (n4 == n) {
                        ++this.lcIndex;
                        n4 = vTDNav_L5.l4Buffer.upper32At(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(n4) == 2) {
                            --n4;
                        }
                        ++n4;
                    }
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 3) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (n4 < n3) {
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 3) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (this.isText(n4) && this.vn.getTokenDepth(n4) == 3) {
                    this.prevLocation = n4;
                    return n4;
                }
                if (this.vn.getTokenType(n4) == 0 && this.vn.getTokenDepth(n4) < 4 || this.vn.getTokenDepth(n4) < 3) break;
                ++n4;
            }
            return -1;
        }
        if (n4 >= this.vn.vtdSize) {
            return -1;
        }
        n3 = this.vn.getTokenDepth(n4);
        n2 = this.vn.getTokenType(n4);
        while (n4 < this.vn.vtdSize && n3 >= 3 && (n3 != 3 || n2 != 0)) {
            if (this.isText(n4) && this.vn.getTokenDepth(n4) == 3) {
                this.prevLocation = n4;
                return n4;
            }
            n3 = this.vn.getTokenDepth(++n4);
            n2 = this.vn.getTokenType(n4);
        }
        return -1;
    }

    private int handleLevel4() {
        int n;
        int n2;
        int n3;
        int n4;
        VTDNav_L5 vTDNav_L5 = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            n4 = this.increment(this.prevLocation);
        } else {
            this.lcLower = vTDNav_L5.l4Buffer.lower32At(vTDNav_L5.l4index);
            if (this.lcLower != -1) {
                this.lcUpper = vTDNav_L5.l5Buffer.size - 1;
                n3 = vTDNav_L5.l4Buffer.size;
                for (n2 = vTDNav_L5.l4index + 1; n2 < n3; ++n2) {
                    n = vTDNav_L5.l4Buffer.lower32At(n2);
                    if (n == -1) continue;
                    this.lcUpper = n - 1;
                    break;
                }
            }
            n4 = this.index + 1;
        }
        if (this.lcLower != -1) {
            n3 = vTDNav_L5.l5Buffer.intAt(this.lcLower);
            n2 = vTDNav_L5.l5Buffer.intAt(this.lcUpper);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (n4 < this.vn.vtdSize) {
                n = vTDNav_L5.l5Buffer.intAt(this.lcIndex);
                if (n4 >= n3 && n4 < n2) {
                    if (n4 == n) {
                        ++this.lcIndex;
                        n4 = vTDNav_L5.l5Buffer.intAt(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(n4) == 4) {
                            --n4;
                        }
                        ++n4;
                    }
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 4) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (n4 < n3) {
                    if (this.isText(n4) && this.vn.getTokenDepth(n4) == 4) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (this.isText(n4) && this.vn.getTokenDepth(n4) == 4) {
                    this.prevLocation = n4;
                    return n4;
                }
                if (this.vn.getTokenType(n4) == 0 && this.vn.getTokenDepth(n4) < 5 || this.vn.getTokenDepth(n4) < 4) break;
                ++n4;
            }
            return -1;
        }
        if (n4 >= this.vn.vtdSize) {
            return -1;
        }
        n3 = this.vn.getTokenDepth(n4);
        n2 = this.vn.getTokenType(n4);
        while (n4 < this.vn.vtdSize && n3 >= 4 && (n3 != 4 || n2 != 0)) {
            if (this.isText(n4) && this.vn.getTokenDepth(n4) == 4) {
                this.prevLocation = n4;
                return n4;
            }
            n3 = this.vn.getTokenDepth(++n4);
            n2 = this.vn.getTokenType(n4);
        }
        return -1;
    }

    private int _handleLevel2() {
        int n;
        int n2;
        int n3;
        int n4;
        VTDNav_L5 vTDNav_L5 = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            n4 = this.increment(this.prevLocation);
        } else {
            this.lcLower = vTDNav_L5.l2Buffer.lower32At(vTDNav_L5.l2index);
            if (this.lcLower != -1) {
                this.lcUpper = vTDNav_L5.l3Buffer.size - 1;
                n3 = vTDNav_L5.l2Buffer.size;
                for (n2 = vTDNav_L5.l2index + 1; n2 < n3; ++n2) {
                    n = vTDNav_L5.l2Buffer.lower32At(n2);
                    if (n == -1) continue;
                    this.lcUpper = n - 1;
                    break;
                }
            }
            n4 = this.index + 1;
        }
        if (this.lcLower != -1) {
            n3 = vTDNav_L5.l3Buffer.upper32At(this.lcLower);
            n2 = vTDNav_L5.l3Buffer.upper32At(this.lcUpper);
            int n5 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (n4 < vTDNav_L5.vtdSize) {
                n = vTDNav_L5.l3Buffer.upper32At(this.lcIndex);
                if (n4 >= n3 && n4 < n2) {
                    if (n4 == n) {
                        ++this.lcIndex;
                        n4 = vTDNav_L5.l3Buffer.upper32At(this.lcIndex) - 1;
                        while (vTDNav_L5.getTokenDepth(n4) == 2) {
                            --n4;
                        }
                        ++n4;
                    }
                    if (this.isText(n4) && vTDNav_L5.getTokenDepth(n4) == 2) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (n4 < n3) {
                    if (this.isText(n4) && vTDNav_L5.getTokenDepth(n4) == 2) {
                        this.prevLocation = n4;
                        return n4;
                    }
                    ++n4;
                    continue;
                }
                if (this.isText(n4) && vTDNav_L5.getTokenDepth(n4) == 2) {
                    this.prevLocation = n4;
                    return n4;
                }
                if (vTDNav_L5.getTokenType(n4) == 0 && vTDNav_L5.getTokenDepth(n4) < 3 || vTDNav_L5.getTokenDepth(n4) < 2) break;
                ++n4;
            }
            return -1;
        }
        if (n4 >= this.vn.vtdSize) {
            return -1;
        }
        n3 = this.vn.getTokenDepth(n4);
        n2 = this.vn.getTokenType(n4);
        while (n4 < this.vn.vtdSize && n3 >= 2 && (n3 != 2 || n2 != 0)) {
            if (this.isText(n4) && this.vn.getTokenDepth(n4) == 2) {
                this.prevLocation = n4;
                return n4;
            }
            n3 = this.vn.getTokenDepth(++n4);
            n2 = this.vn.getTokenType(n4);
        }
        return -1;
    }

    private int handleDefault() {
        int n;
        int n2 = n = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (n >= this.vn.vtdSize) {
            return -1;
        }
        int n3 = this.vn.getTokenDepth(n);
        int n4 = this.vn.getTokenType(n);
        while (n3 >= this.depth && (n3 != this.depth || n4 != 0)) {
            if (this.isText(n) && n3 == this.depth) {
                this.prevLocation = n;
                return n;
            }
            if (++n >= this.vn.vtdSize) {
                return -1;
            }
            n3 = this.vn.getTokenDepth(n);
            n4 = this.vn.getTokenType(n);
        }
        return -1;
    }

    private int handleDocumentNode() {
        int n;
        if (this.sel_type == 0) {
            return -1;
        }
        int n2 = n = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (n >= this.vn.vtdSize) {
            return -1;
        }
        while (true) {
            if (n < this.vn.rootIndex) {
                if (this.isText(n)) {
                    this.prevLocation = n;
                    return n;
                }
                ++n;
                continue;
            }
            if (n == this.vn.rootIndex) {
                n = this.vn.vtdSize - 1;
                while (this.vn.getTokenDepth(n) == -1) {
                    --n;
                }
                ++n;
            }
            if (n >= this.vn.vtdSize) {
                return -1;
            }
            if (this.isText(n)) {
                this.prevLocation = n;
                return n;
            }
            ++n;
        }
    }
}

