/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import com.ximpleware.extended.AutoPilotHuge;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.ParseExceptionHuge;
import com.ximpleware.extended.VTDExceptionHuge;
import com.ximpleware.extended.VTDGenHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import de.julielab.xml.FieldValueSource;
import de.julielab.xml.FileNameValueSource;
import de.julielab.xml.FileTooBigException;
import de.julielab.xml.JulieXMLBuffer;
import de.julielab.xml.JulieXMLConstants;
import de.julielab.xml.Options;
import de.julielab.xml.TimestampValueSource;
import de.julielab.xml.XPathNavigator;
import de.julielab.xml.XPathNavigatorHuge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulieXMLTools {
    static final Logger LOG = LoggerFactory.getLogger(JulieXMLTools.class);
    public static final int ELEMENT_FRAGMENT = 0;
    public static final int CONTENT_FRAGMENT = 1;

    public static Iterator<Map<String, Object>> constructRowIterator(String fileName, int bufferSize, String forEachXpath, List<Map<String, String>> fields, boolean largeFileSize) {
        try {
            if (largeFileSize) {
                return JulieXMLTools.constructRowIteratorHuge(fileName, forEachXpath, fields);
            }
            InputStream is = null;
            if (fileName.endsWith(".gz") || fileName.endsWith(".gzip")) {
                is = new GZIPInputStream(new FileInputStream(fileName));
            } else if (fileName.endsWith(".zip")) {
                is = new ZipInputStream(new FileInputStream(fileName));
                ((ZipInputStream)is).getNextEntry();
            } else {
                is = new FileInputStream(fileName);
            }
            VTDNav vn = JulieXMLTools.getVTDNav(is, bufferSize);
            return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, fileName);
        }
        catch (FileNotFoundException e) {
            LOG.error(String.format("File %s could not be found.", fileName));
            e.printStackTrace();
        }
        catch (FileTooBigException e) {
            try {
                LOG.info("Falling back on VTD XML 'Huge' parser for large XML files...");
                return JulieXMLTools.constructRowIteratorHuge(fileName, forEachXpath, fields);
            }
            catch (ParseExceptionHuge e1) {
                LOG.error("Error while parsing file " + fileName + ": ", (Object)e1.getMessage());
                e1.printStackTrace();
                System.exit(1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            LOG.error("Error while parsing file " + fileName + ": ", (Object)e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        catch (ParseExceptionHuge e) {
            LOG.error("Error while parsing file " + fileName + ": ", (Object)e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    private static Iterator<Map<String, Object>> constructRowIteratorHuge(String fileName, String forEachXpath, List<Map<String, String>> fields) throws IOException, ParseExceptionHuge {
        JulieXMLBuffer buffer = new JulieXMLBuffer();
        buffer.readFile(fileName);
        VTDGenHuge vg = new VTDGenHuge();
        vg.setDoc(buffer);
        vg.parse(true);
        VTDNavHuge vn = vg.getNav();
        return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, fileName);
    }

    public static Iterator<Map<String, Object>> constructRowIterator(byte[] data, int bufferSize, String forEachXpath, List<Map<String, String>> fields, String identifier) {
        try {
            VTDGen vg = new VTDGen();
            vg.setDoc(data);
            vg.parse(true);
            VTDNav vn = vg.getNav();
            return JulieXMLTools.constructRowIterator(vn, forEachXpath, fields, identifier);
        }
        catch (ParseException e) {
            LOG.error("Error while parsing document " + identifier);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static Iterator<Map<String, Object>> constructRowIterator(VTDNavHuge vn, String forEachXpath, List<Map<String, String>> fields, String identifier) {
        final AutoPilotHuge ap = new AutoPilotHuge(vn);
        try {
            ap.selectXPath(forEachXpath);
            final int startIndex = ap.evalXPath();
            if (startIndex == -1) {
                LOG.warn("Couldn't find XPath: " + forEachXpath + " in document " + identifier);
            }
            final HashMap<String, FieldValueSource> navigators = new HashMap<String, FieldValueSource>();
            for (Map<String, String> field : fields) {
                String xPath = field.get("xpath");
                Options options = new Options();
                String fieldName = field.get("name");
                if (xPath != null) {
                    AutoPilotHuge pilot = new AutoPilotHuge(vn);
                    AutoPilotHuge pilotForEach = new AutoPilotHuge(vn);
                    String fieldForEach = field.get("forEach");
                    pilotForEach.selectXPath(xPath);
                    pilot.selectXPath(xPath);
                    if (fieldForEach != null) {
                        pilotForEach = new AutoPilotHuge(vn);
                        pilotForEach.selectXPath(fieldForEach);
                    } else {
                        pilot.selectXPath(".");
                    }
                    options.returnXMLFragment = Boolean.parseBoolean(field.get("returnXMLFragment"));
                    options.returnArray = Boolean.parseBoolean(field.get("returnValuesAsArray"));
                    options.concatString = field.get("concatString");
                    if (options.concatString == null) {
                        options.concatString = ",";
                    }
                    options.performGzip = Boolean.parseBoolean(field.get(JulieXMLConstants.GZIP));
                    navigators.put(fieldName, new XPathNavigatorHuge(vn, pilotForEach, pilot, options));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("extractFromFileName"))) {
                    String[] path = identifier.split("/");
                    navigators.put(fieldName, new FileNameValueSource(path[path.length - 1], field));
                    continue;
                }
                LOG.warn("Field with name \"" + fieldName + "\" does not define a source to get a value from (e.g. XML XPath or file name) and will not have imported any values.");
            }
            return new Iterator<Map<String, Object>>(){
                int index;
                {
                    this.index = startIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public Map<String, Object> next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        for (String fieldName : navigators.keySet()) {
                            FieldValueSource navi = (FieldValueSource)navigators.get(fieldName);
                            Object fieldValue = navi.getFieldValue();
                            row.put(fieldName, fieldValue);
                        }
                        this.index = ap.evalXPath();
                        return row;
                    }
                    catch (XPathEvalException e) {
                        e.printStackTrace();
                    }
                    catch (NavException e) {
                        e.printStackTrace();
                    }
                    catch (XPathEvalExceptionHuge e) {
                        e.printStackTrace();
                    }
                    catch (NavExceptionHuge e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (XPathEvalException e) {
            e.printStackTrace();
        }
        catch (NavException e) {
            e.printStackTrace();
        }
        catch (VTDExceptionHuge e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Iterator<Map<String, Object>> constructRowIterator(VTDNav vn, String forEachXpath, List<Map<String, String>> fields, String identifier) {
        final AutoPilot ap = new AutoPilot(vn);
        try {
            Map<String, String> namespaceMap = JulieXMLTools.buildNamespaceMap(vn.duplicateNav());
            JulieXMLTools.declareNamespaces(ap, namespaceMap);
            ap.selectXPath(forEachXpath);
            final int startIndex = ap.evalXPath();
            if (startIndex == -1) {
                LOG.info("Couldn't find XPath: " + forEachXpath + " in document " + identifier);
            }
            final HashMap<String, FieldValueSource> navigators = new HashMap<String, FieldValueSource>();
            for (Map<String, String> field : fields) {
                String xPath = field.get("xpath");
                Options options = new Options();
                String fieldName = field.get("name");
                if (xPath != null) {
                    AutoPilot pilot = new AutoPilot(vn);
                    AutoPilot pilotForEach = new AutoPilot(vn);
                    String fieldForEach = field.get("forEach");
                    JulieXMLTools.declareNamespaces(pilot, namespaceMap);
                    JulieXMLTools.declareNamespaces(pilotForEach, namespaceMap);
                    pilotForEach.selectXPath(xPath);
                    pilot.selectXPath(xPath);
                    if (fieldForEach != null) {
                        pilotForEach = new AutoPilot(vn);
                        pilotForEach.selectXPath(fieldForEach);
                    } else {
                        pilot.selectXPath(".");
                    }
                    options.returnXMLFragment = Boolean.parseBoolean(field.get("returnXMLFragment"));
                    options.returnArray = Boolean.parseBoolean(field.get("returnValuesAsArray"));
                    options.resolveEntities = Boolean.parseBoolean(field.get("resolveEntities"));
                    options.concatString = field.get("concatString");
                    if (options.concatString == null) {
                        options.concatString = ",";
                    }
                    options.performGzip = Boolean.parseBoolean(field.get(JulieXMLConstants.GZIP));
                    navigators.put(fieldName, new XPathNavigator(vn, pilotForEach, pilot, options));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("extractFromFileName"))) {
                    String[] path = identifier.split("/");
                    navigators.put(fieldName, new FileNameValueSource(path[path.length - 1], field));
                    continue;
                }
                if (Boolean.parseBoolean(field.get("timestamp"))) {
                    navigators.put(fieldName, new TimestampValueSource());
                    continue;
                }
                LOG.warn("Field with name \"" + fieldName + "\" does not define a source to get a value from (e.g. XML XPath or file name) and will not have imported any values.");
            }
            return new Iterator<Map<String, Object>>(){
                int index;
                {
                    this.index = startIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public Map<String, Object> next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        for (String fieldName : navigators.keySet()) {
                            FieldValueSource navi = (FieldValueSource)navigators.get(fieldName);
                            Object fieldValue = navi.getFieldValue();
                            row.put(fieldName, fieldValue);
                        }
                        this.index = ap.evalXPath();
                        return row;
                    }
                    catch (XPathEvalException e) {
                        e.printStackTrace();
                    }
                    catch (NavException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (XPathEvalException e) {
            e.printStackTrace();
        }
        catch (NavException e) {
            e.printStackTrace();
        }
        catch (XPathParseException e) {
            e.printStackTrace();
        }
        catch (VTDException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void declareNamespaces(AutoPilot ap, Map<String, String> namespaceMap) {
        for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
            ap.declareXPathNameSpace(entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, String> buildNamespaceMap(VTDNav vn) throws VTDException {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath("//namespace::*");
        String nsDeclaration = null;
        try {
            int i = -1;
            while ((i = ap.evalXPath()) != -1) {
                nsDeclaration = vn.toString(i);
                if (!nsDeclaration.contains(":")) continue;
                String nsPrefix = nsDeclaration.split(":")[1];
                String nsUrl = vn.toString(i + 1);
                namespaceMap.put(nsPrefix, nsUrl);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("This algorithm expects XML namespace declarations to be of the form \"xmlns:<ns-name>\". The declaration actually was: \"" + nsDeclaration + "\"", e);
        }
        return namespaceMap;
    }

    public static VTDNav getVTDNav(InputStream is, int bufferSize) throws ParseException, FileTooBigException {
        VTDGen vg;
        block7: {
            vg = null;
            try {
                byte[] data = JulieXMLTools.readStream(is, bufferSize);
                vg = new VTDGen();
                vg.setDoc(data);
                vg.parse(true);
            }
            catch (EncodingException e) {
                e.printStackTrace();
            }
            catch (EOFException e) {
                e.printStackTrace();
            }
            catch (EntityException e) {
                e.printStackTrace();
            }
            catch (FileTooBigException e) {
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                String message = e.getMessage();
                if (!message.contains("file size too big")) break block7;
                throw new FileTooBigException(message);
            }
        }
        return vg.getNav();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream is, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        ArrayList<Integer> readBytesList = new ArrayList<Integer>();
        int bytesRead = 0;
        int allBytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            bufferList.add(buffer);
            readBytesList.add(bytesRead);
            buffer = new byte[bufferSize];
            if (allBytesRead + bytesRead < allBytesRead) {
                LOG.info("Array size overflow while reading file. The file you are attempting to read is propably greater than 2GB in size. Such files cannot be read using the default VTD XML parser. Consider splitting the file into subfiles of size less than 2GB for using the default parser.");
                throw new FileTooBigException("Input file could not be read because it is too big (>2GB)");
            }
            allBytesRead += bytesRead;
        }
        byte[] streamContent = new byte[allBytesRead];
        int pos = 0;
        try {
            for (int i = 0; i < bufferList.size(); ++i) {
                System.arraycopy(bufferList.get(i), 0, streamContent, pos, (Integer)readBytesList.get(i));
                pos += ((Integer)readBytesList.get(i)).intValue();
            }
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            LOG.error("Array index out of bounds - please check whether the file you try to read is less then 2GB in size.", oob);
        }
        finally {
            is.close();
        }
        return streamContent;
    }

    public static byte[] gzipData(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream os = new GZIPOutputStream(baos);
            os.write(data);
            os.close();
            return baos.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] unGzipData(byte[] gzipData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(gzipData);
        GZIPInputStream gzipInputStream = new GZIPInputStream(bais);
        byte[] data = JulieXMLTools.readStream(gzipInputStream, 1024);
        return data;
    }

    public static URL getSolrServerURL(String urlStr, boolean calledByCLI, Logger LOG) {
        try {
            URL serverURL = new URL(urlStr);
            return serverURL;
        }
        catch (MalformedURLException e) {
            String msg = "Solr server URL '" + urlStr + "' is malformed: ";
            if (calledByCLI) {
                LOG.error(msg + e.getMessage());
            } else {
                LOG.error(msg, e);
            }
            return null;
        }
    }

    public static String getElementText(VTDNav vn) throws NavException {
        StringBuilder sb = new StringBuilder();
        int depth = vn.getCurrentDepth();
        int i = vn.getCurrentIndex();
        while (vn.getTokenType(i) == 0) {
            ++i;
        }
        while (vn.getTokenDepth(i) >= depth && (vn.getTokenType(i) != 0 || vn.getTokenDepth(i) != depth) && i < vn.getTokenCount()) {
            if (vn.getTokenType(i) == 5 || vn.getTokenType(i) == 11) {
                sb.append(vn.toString(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getFragment(VTDNav vn, int fragmentType, boolean returnRawString) throws NavException {
        long fragment = fragmentType == 0 ? vn.getElementFragment() : vn.getContentFragment();
        int offset = (int)fragment;
        int length = (int)(fragment >> 32);
        return returnRawString ? vn.toRawString(offset, length) : vn.toString(offset, length);
    }

    public static int setElementText(VTDNav vn, AutoPilot ap, XMLModifier xm, String xpath, String text) throws VTDException, UnsupportedEncodingException {
        ap.selectXPath(xpath);
        int elementIndex = ap.evalXPath();
        int textIndex = -1;
        if (elementIndex != -1) {
            textIndex = vn.getText();
            if (textIndex != -1) {
                xm.updateToken(textIndex, text);
            } else {
                xm.insertAfterHead(text);
            }
        }
        return textIndex;
    }

    public static <T> String[] expandArrayEntries(T[] array, String fmtStr) {
        String[] expandedEntries = new String[array.length];
        for (int i = 0; i < expandedEntries.length; ++i) {
            expandedEntries[i] = String.format(fmtStr, array[i]);
        }
        return expandedEntries;
    }

    public static <T> String[] expandArrayEntries(List<T> list, String fmtStr) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return JulieXMLTools.expandArrayEntries(array, fmtStr);
    }

    public static <T> String[] expandArrayEntries(T[] array, String[] fmtStrs) {
        if (array.length != fmtStrs.length) {
            throw new IllegalArgumentException("The size of the array with elements to be expanded must match the size of the array holding the extention format strings.");
        }
        String[] expandedEntries = new String[array.length];
        for (int i = 0; i < expandedEntries.length; ++i) {
            expandedEntries[i] = String.format(fmtStrs[i], array[i]);
        }
        return expandedEntries;
    }
}

