/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import de.julielab.xml.JulieXMLTools;
import de.julielab.xml.JulieXMLToolsCLI;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JulieXMLToolsCLIRecords {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: " + JulieXMLToolsCLI.class.getName() + " <XML file> <record XPath expression> <field XPath expression> <field XPath expression>*");
            System.out.println("This tool is meant to extract particular fields of XML files representing a list of records. The result is a table where each field XPath expression is evaluated for one field.");
            System.out.println("The record XPath expression must point to the list of records, i.e. typically a repeating path. The field XPath must be relative to the record XPath!");
            System.exit(1);
        }
        String fileName = args[0];
        String forEach = args[1];
        String[] fieldPaths = new String[args.length - 2];
        System.arraycopy(args, 2, fieldPaths, 0, fieldPaths.length);
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < fieldPaths.length) {
            String path = fieldPaths[i];
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("name", "fieldvalue" + i);
            field.put("xpath", path);
            fields.add(field);
            ++i;
        }
        Iterator<Map<String, Object>> rowIterator = JulieXMLTools.constructRowIterator(fileName, 1024, forEach, fields, false);
        PrintStream out = null;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        while (rowIterator.hasNext()) {
            Map<String, Object> row = rowIterator.next();
            ArrayList<String> rowValues = new ArrayList<String>();
            int i2 = 0;
            while (i2 < fieldPaths.length) {
                String value = (String)row.get("fieldvalue" + i2);
                rowValues.add(value);
                ++i2;
            }
            out.println(StringUtils.join(rowValues, (String)"\t"));
        }
    }
}

