/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.segmentationEvaluator;

import de.julielab.segmentationEvaluator.Converter;
import de.julielab.segmentationEvaluator.EvaluationResult;
import de.julielab.segmentationEvaluator.Evaluator;
import de.julielab.segmentationEvaluator.IOToken;
import de.julielab.segmentationEvaluator.UnknownFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class SimpleEvaluationApplication {
    public static void main(String[] args) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.setMinimumFractionDigits(5);
        if (args.length != 3) {
            System.out.println("Usage: SimpleEvaluationApplication <goldFile> <predFile> <IOB|IO>");
            System.exit(0);
        }
        IOToken[] gold = null;
        IOToken[] pred = null;
        EvaluationResult[] result = null;
        Converter conv = null;
        int mode = 0;
        if (args[2].equals("io") || args[2].equals("IO")) {
            mode = 1;
        } else if (args[2].equals("iob") || args[2].equals("IOB")) {
            mode = 2;
        }
        try {
            conv = new Converter(mode);
        }
        catch (UnknownFormatException e) {
            System.err.println(e);
        }
        try {
            gold = conv.textToIOTokens(new File(args[0]));
            pred = conv.textToIOTokens(new File(args[1]));
        }
        catch (FileNotFoundException e) {
            System.err.println("Gold file or pred file does not exist.");
            System.exit(0);
        }
        result = Evaluator.evaluate(gold, pred);
        if (result.length > 0) {
            System.out.println(df.format(result[0].getRecall()) + "\t" + df.format(result[0].getPrecision()) + "\t" + df.format(result[0].getFscore()));
        } else {
            System.out.println("no results!");
        }
    }
}

