/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.segmentationEvaluator;

import de.julielab.segmentationEvaluator.IOToken;

public class IntelligentIOBToken
extends IOToken {
    private static final String CONCATENATOR = "-";
    private static final String BEGIN_STRING = "B-";
    private static final String INTERN_STRING = "I-";

    public IntelligentIOBToken(String text, String label) {
        this.text = text;
        if (label.equals("O") || label.equals("0")) {
            this.iobMark = "O";
            this.label = "";
        } else if (label.startsWith(BEGIN_STRING) || label.startsWith(INTERN_STRING)) {
            this.iobMark = label.substring(0, 1);
            this.label = label.substring(2);
        } else {
            this.label = label;
            this.iobMark = "I";
        }
    }

    public IntelligentIOBToken(String text, String label, String pos) {
        this(text, label);
        this.pos = pos;
    }

    @Override
    public String toString() {
        String ret = this.text + "\t\t\t" + this.iobMark + CONCATENATOR + this.label;
        return ret;
    }
}

