/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.segmentationEvaluator;

import de.julielab.segmentationEvaluator.EvaluationResult;
import de.julielab.segmentationEvaluator.IOToken;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluator.class);

    public static EvaluationResult[] evaluate(IOToken[] gold, IOToken[] prediction) {
        if (gold.length != prediction.length) {
            String info = "Different number of tokens for gold and prediction: " + gold.length + " <-> " + prediction.length;
            IllegalStateException ex = new IllegalStateException(info);
            LOGGER.error(info, (Throwable)ex);
            throw ex;
        }
        for (int i = 0; i < prediction.length; ++i) {
            String goldToken;
            String predToken = prediction[i].getText();
            if (predToken.equals(goldToken = gold[i].getText())) continue;
            String info = "Tokens in gold file differnt from tokens in prediction: " + predToken + " <-> " + goldToken;
            IllegalStateException ex = new IllegalStateException(info);
            LOGGER.error(info, (Throwable)ex);
            throw ex;
        }
        LOGGER.info("Beginning evaluation");
        LOGGER.info("Computing spans of annotation: gold");
        HashMap<String, HashMap<String, String>> goldSpans = Evaluator.getAnnotationSpans(gold);
        LOGGER.info("Computing spans of annotation: prediction");
        HashMap<String, HashMap<String, String>> predSpans = Evaluator.getAnnotationSpans(prediction);
        EvaluationResult[] results = new EvaluationResult[goldSpans.keySet().size() + 1];
        int i = 1;
        Iterator<String> iter = goldSpans.keySet().iterator();
        while (iter.hasNext()) {
            EvaluationResult evalRes = null;
            String label = iter.next();
            if (predSpans.get(label) == null) {
                evalRes = new EvaluationResult(0, goldSpans.get(label).size(), 0, label);
            } else {
                LOGGER.debug("Single evaluation of label \"" + label + "\"");
                int[] evalValues = Evaluator.evaluateSingle(goldSpans.get(label), predSpans.get(label));
                evalRes = new EvaluationResult(evalValues[0], evalValues[1], evalValues[2], label);
            }
            results[i] = evalRes;
            ++i;
        }
        int tpOver = 0;
        int fpOver = 0;
        int fnOver = 0;
        for (i = 1; i < results.length; ++i) {
            tpOver += results[i].getTp();
            fpOver += results[i].getFp();
            fnOver += results[i].getFn();
        }
        results[0] = new EvaluationResult(tpOver, fnOver, fpOver);
        return results;
    }

    public static EvaluationResult evaluate(IOToken[] gold, IOToken[] prediction, String label) {
        EvaluationResult result = null;
        EvaluationResult[] allResults = null;
        allResults = Evaluator.evaluate(gold, prediction);
        for (int i = 0; i < allResults.length; ++i) {
            if (!allResults[i].getEvalLabel().equals(label)) continue;
            result = allResults[i];
            break;
        }
        return result;
    }

    public static EvaluationResult[] evaluate(IOToken[] gold, IOToken[] prediction, String[] labels) {
        EvaluationResult[] results = new EvaluationResult[labels.length];
        EvaluationResult[] allResults = null;
        allResults = Evaluator.evaluate(gold, prediction);
        for (int j = 0; j < labels.length; ++j) {
            for (int i = 0; i < allResults.length; ++i) {
                if (!allResults[i].getEvalLabel().equals(labels[j])) continue;
                results[j] = allResults[i];
            }
        }
        return results;
    }

    private static int[] evaluateSingle(HashMap<String, String> goldSpan, HashMap<String, String> predSpan) {
        int tp = 0;
        int allFound = predSpan.size();
        int allExist = goldSpan.size();
        for (String offset : predSpan.keySet()) {
            String labelsGold;
            String labelsEval;
            if (!goldSpan.containsKey(offset) || !(labelsEval = predSpan.get(offset)).equals(labelsGold = goldSpan.get(offset))) continue;
            ++tp;
        }
        int[] ret = new int[]{tp, allExist - tp, allFound - tp};
        return ret;
    }

    public static HashMap<String, HashMap<String, String>> getAnnotationSpans(IOToken[] taglist) {
        int begin = -1;
        int end = -1;
        boolean inside = false;
        HashMap<String, HashMap<String, String>> spans = new HashMap<String, HashMap<String, String>>();
        String oldLabel = null;
        for (int i = 0; i < taglist.length; ++i) {
            IOToken ioToken = taglist[i];
            String currLabel = ioToken.getLabel();
            String currIobmark = ioToken.getIobMark();
            if (!inside) {
                if (!currIobmark.equals("O")) {
                    inside = true;
                    begin = i;
                    end = -1;
                }
            } else if (currIobmark.equals("B") || currIobmark.equals("O") || ioToken instanceof IOToken && oldLabel != null && !oldLabel.equals(currLabel)) {
                HashMap span = null;
                end = i - 1;
                Object labelSeq = "";
                for (int j = begin; j < end + 1; ++j) {
                    if (((String)labelSeq).length() > 0) {
                        labelSeq = (String)labelSeq + "#";
                    }
                    labelSeq = (String)labelSeq + taglist[j].getLabel();
                }
                if (spans.get(oldLabel) == null) {
                    span = new HashMap();
                    spans.put(oldLabel, span);
                }
                spans.get(oldLabel).put(begin + "," + end, (String)labelSeq);
                begin = i;
                end = -1;
                if (currIobmark.equals("O")) {
                    inside = false;
                }
            }
            oldLabel = currLabel;
        }
        return spans;
    }
}

