/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.segmentationEvaluator;

public class EvaluationResult {
    private int tp;
    private int fn;
    private int fp;
    private String evalLabel;

    public EvaluationResult(int tp, int fn, int fp, String evalLabel) {
        this.tp = tp;
        this.fn = fn;
        this.fp = fp;
        this.evalLabel = evalLabel;
    }

    public EvaluationResult(int tp, int fn, int fp) {
        this(tp, fn, fp, "Overall");
    }

    public double getPrecision() {
        double ret = this.tp + this.fp > 0 ? (double)this.tp / (double)(this.tp + this.fp) : 0.0;
        return ret;
    }

    public double getRecall() {
        double ret = this.tp + this.fn > 0 ? (double)this.tp / (double)(this.tp + this.fn) : 0.0;
        return ret;
    }

    public double getFscore() {
        double recall;
        double precision = this.getPrecision();
        double ret = precision + (recall = this.getRecall()) > 0.0 ? 2.0 * precision * recall / (precision + recall) : 0.0;
        return ret;
    }

    public int getFn() {
        return this.fn;
    }

    public int getFp() {
        return this.fp;
    }

    public int getTp() {
        return this.tp;
    }

    public String getEvalLabel() {
        return this.evalLabel;
    }

    public String toString() {
        return this.evalLabel + ": Recall: " + this.getRecall() + ", Precision: " + this.getPrecision() + ", F-Score: " + this.getFscore() + " (tp: " + this.tp + ", fn: " + this.fn + ",fp :" + this.fp + ")";
    }
}

