/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.segmentationEvaluator;

import de.julielab.segmentationEvaluator.IOBToken;
import de.julielab.segmentationEvaluator.IOToken;
import de.julielab.segmentationEvaluator.UnknownFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Converter.class);
    public static final int TYPE_IO = 1;
    public static final int TYPE_IOB = 2;
    private int mode;

    public Converter(int mode) throws UnknownFormatException {
        if (mode != 1 && mode != 2) {
            throw new UnknownFormatException();
        }
        this.mode = mode;
    }

    private IOToken lineToIOToken(String line) {
        String[] parts = null;
        IOToken ioToken = null;
        if (line.equals("")) {
            line = "O\tO";
        }
        if ((parts = line.split("\\s+")).length == 2) {
            ioToken = this.mode == 1 ? new IOToken(parts[0], parts[1]) : new IOBToken(parts[0], parts[1]);
        } else {
            LOGGER.error("input format incorrect: two many columns in current line: " + line);
            System.exit(-1);
        }
        return ioToken;
    }

    public IOToken[] textToIOTokens(File src) throws FileNotFoundException {
        if (!src.exists()) {
            throw new FileNotFoundException();
        }
        BufferedReader br = null;
        ArrayList<IOToken> retList = new ArrayList<IOToken>();
        IOToken[] ret = new IOToken[]{};
        String line = null;
        try {
            br = new BufferedReader(new FileReader(src));
            while ((line = br.readLine()) != null) {
                retList.add(this.lineToIOToken(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret = retList.toArray(ret);
        return ret;
    }

    public IOToken[] textToIOTokens(ArrayList<String> lines) {
        ArrayList<IOToken> retList = new ArrayList<IOToken>();
        IOToken[] ret = new IOToken[]{};
        for (String line : lines) {
            retList.add(this.lineToIOToken(line));
        }
        ret = retList.toArray(ret);
        return ret;
    }
}

