/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jssf.commons.services;

import de.julielab.jssf.commons.services.IDownloadService;
import de.julielab.jssf.commons.util.ResourceAccessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadService
implements IDownloadService {
    private static final Logger log = LoggerFactory.getLogger(DownloadService.class);
    private Matcher contentDispositionFilenameMatcher = Pattern.compile("filename=\"([^\"]+)\"").matcher("");

    @Override
    public File store(URI address, File destination, String downloadName) throws ResourceAccessException {
        String archiveName = downloadName == null ? "archive" : downloadName;
        try {
            log.info("Trying to retrieve {} from {}", (Object)archiveName, (Object)address);
            URL url = address.toURL();
            if (!destination.exists()) {
                log.debug("{} destination directory {} does not exist, necessary directories are created.", (Object)archiveName, (Object)destination);
                if (!destination.mkdirs()) {
                    throw new ResourceAccessException("Could not create directories " + destination.getAbsolutePath());
                }
            }
            URLConnection connection = url.openConnection();
            InputStream is = connection.getInputStream();
            String fileName = this.getFilename(url, connection);
            log.debug("Storing the downloaded resource to {}", (Object)destination);
            File downloadedFile = new File(destination.getAbsolutePath() + File.separator + fileName);
            Files.copy(is, downloadedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return downloadedFile;
        }
        catch (ResourceAccessException e) {
            log.error("Error while trying to download the resource at " + address.toString());
            throw e;
        }
        catch (IOException e) {
            throw new ResourceAccessException(e);
        }
    }

    @Override
    public File store(URI uri, File destinationDirectory) throws ResourceAccessException {
        return this.store(uri, destinationDirectory, null);
    }

    synchronized String getFilename(URL url, URLConnection connection) {
        String fileName = connection.getHeaderField("Content-Disposition");
        if (fileName != null) {
            this.contentDispositionFilenameMatcher.reset(fileName);
            if (this.contentDispositionFilenameMatcher.find()) {
                fileName = this.contentDispositionFilenameMatcher.group(1);
            }
        }
        if (fileName == null) {
            fileName = new File(url.getFile()).getName();
        }
        log.debug("Extracted resource file name as: {}", (Object)fileName);
        return fileName;
    }
}

