package de.julielab.jssf.commons.spi;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

/**
 * An interface for all components that use the central configuration file. They expose their parameters
 * by filling in a configuration template. This template can be used by interactive configuration processes
 * or be serialized as an empty configuration, possible with default values for some parameters, as a
 * starting point for a manual configuration process.
 */
public interface ParameterExposing {
    /**
     * <p>
     * Adds the parameters of the implementing component to the template configuration. The component may insert
     * default values or empty values. For the sake of this template construction, the data type of parameters
     * values is not important. Thus, to indicate template for an integer-valued parameter, an empty string may
     * be given.
     * </p>
     * <p>When an application is run, every component only receives the sub configuration which is relevant to that
     * component by convention. Consequently, each component defines its own parameters relative to an imaginary
     * configuration root. Here, that path to that imaginary root is given by <tt>basePath</tt> . The base path
     * is constructed by the recursive calls of components to their sub components. Thus, each component adds
     * its imaginary root path to <tt>basePath</tt> with each call so that the leaf components add their parameters
     * to the complete path.
     * </p>
     * @param basePath The path that must be prepended to the parameter of the component.
     * @param template
     */
    void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template);
}
