package de.julielab.jssf.commons.services;

import de.julielab.jssf.commons.util.ResourceAccessException;

import java.io.File;
import java.net.URI;

public interface IDownloadService {
    /**
     *
     * Opens the resource at <tt>uri</tt> and copies it into the <tt>destinationDirectory</tt>.
     *
     * @param uri The resource address.
     * @param destinationDirectory The directory to copy the resource to.
     * @param downloadName The name of the resource, for logging purposes.
     * @return Path to the downloaded file
     * @throws ResourceAccessException If file operations fail.
     */
    File store(URI uri, File destinationDirectory, String downloadName) throws ResourceAccessException;
    /**
     *
     * Opens the resource at <tt>uri</tt> and copies it into the <tt>destinationDirectory</tt>.
     *
     * @param uri The resource address.
     * @param destinationDirectory The directory to copy the resource to.
     * @return Path to the downloaded file
     * @throws ResourceAccessException If file operations fail.
     */
    File store(URI uri, File destinationDirectory) throws ResourceAccessException;
}
