package de.julielab.jssf.commons.services;

import de.julielab.jssf.commons.symbols.ExternalToolConstants;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.tapestry5.ioc.internal.util.ClasspathResource;

import java.io.File;
import java.util.Objects;

public class ExternalToolService implements IExternalToolService {

    private final JSONConfiguration externalToolsConfiguration;

    public ExternalToolService() throws ConfigurationException {
        ClasspathResource resource = new ClasspathResource(ExternalToolConstants.EXTERNAL_TOOL_VERSIONS_FILE);
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder<JSONConfiguration> configBuilder =
                new FileBasedConfigurationBuilder<>(JSONConfiguration.class).configure(params.hierarchical()
                        .setLocationStrategy(new ClasspathLocationStrategy())
                        .setFileName(ExternalToolConstants.EXTERNAL_TOOL_VERSIONS_FILE));
        externalToolsConfiguration = configBuilder.getConfiguration();
    }

    @Override
    public String getRequiredVersion(String toolName) {
        return Objects.requireNonNull(externalToolsConfiguration.getString(toolName),
                "The external tool \"" + toolName + "\" does not have a configuration. " +
                        "This either means that the tool is not supported, the name contains a typo or that " +
                        "the file " + ExternalToolConstants.EXTERNAL_TOOL_VERSIONS_FILE + " is incomplete.");
    }
}
