package de.julielab.jssf.commons;

import de.julielab.jssf.commons.util.ResourceAccessException;
import de.julielab.jssf.commons.util.StorageException;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;

public class FileOperations {


    public static void checkDirectory(File directory) throws StorageException {
        if (!directory.exists())
            throw new IllegalStateException("The path " + directory.getAbsolutePath() + " should point to a " +
                    "directory but it does not exist.");
        if (!directory.isDirectory())
            throw new IllegalStateException("Path " + directory.getAbsolutePath() + " should point to " +
                    "a directory but it is not.");
    }
}
