/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.multiplier.xml;

import de.julielab.java.utilities.UriUtilities;
import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.casmultiplier.JCoReURI;
import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="XML Multiplier")
@OperationalProperties(outputsNewCases=true, modifiesCas=false)
public class XMLMultiplier
extends JCasMultiplier_ImplBase {
    private static Logger LOGGER = LoggerFactory.getLogger(XMLMultiplier.class);
    String fileToRead;
    public static final String PARAM_MAPPING_FILE = "MappingFile";
    public static final String PARAM_HEADER_TYPE = "HeaderType";
    public static final String PARAM_FOR_EACH = "DocumentXpath";
    private File[] files;
    private int currentIndex = 1;
    private XMLMapper xmlMapper;
    private Iterator<Map<String, Object>> rowIterator;
    private String currentUri;
    @ConfigurationParameter(name="MappingFile")
    private String mappingFileStr;
    @ConfigurationParameter(name="DocumentXpath")
    private String forEach;
    @ConfigurationParameter(name="HeaderType", mandatory=false)
    private String headerTypeName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.debug("initialize() - Initializing XML Multiplier...");
        super.initialize(aContext);
        this.headerTypeName = (String)aContext.getConfigParameterValue(PARAM_HEADER_TYPE);
        if (null == this.headerTypeName) {
            this.headerTypeName = "de.julielab.jcore.types.Header";
        }
        this.mappingFileStr = (String)aContext.getConfigParameterValue(PARAM_MAPPING_FILE);
        this.forEach = (String)aContext.getConfigParameterValue(PARAM_FOR_EACH);
        InputStream is = null;
        LOGGER.info("Header type set to {}. A header of this type is only created if no header is created using the XML mapping currentUri.", (Object)this.headerTypeName);
        LOGGER.info("Mapping file is searched as file or classpath resource at {}", (Object)this.mappingFileStr);
        File mappingFile = new File(this.mappingFileStr);
        if (mappingFile.exists()) {
            try {
                is = new FileInputStream(mappingFile);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new ResourceInitializationException((Throwable)e1);
            }
        } else {
            if (!this.mappingFileStr.startsWith("/")) {
                this.mappingFileStr = "/" + this.mappingFileStr;
            }
            if ((is = ((Object)((Object)this)).getClass().getResourceAsStream(this.mappingFileStr)) == null) {
                throw new IllegalArgumentException("MappingFile " + this.mappingFileStr + " could not be found as a file or on the classpath (note that the prefixing '/' is added automatically if not already present for classpath lookup)");
            }
        }
        try {
            this.xmlMapper = new XMLMapper(is);
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas cas) throws AnalysisEngineProcessException {
        JCoReURI xmlFile = (JCoReURI)JCasUtil.selectSingle((JCas)cas, JCoReURI.class);
        this.currentUri = xmlFile.getUri();
        this.currentIndex = 1;
        LOGGER.debug("Reading file " + this.currentUri);
        String[] fieldPaths = new String[]{"."};
        ArrayList fields = new ArrayList();
        for (int i = 0; i < fieldPaths.length; ++i) {
            String path = fieldPaths[i];
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", "fieldvalue" + i);
            field.put("xpath", path);
            field.put("returnXMLFragment", "true");
            fields.add(field);
        }
        try {
            this.rowIterator = JulieXMLTools.constructRowIterator((byte[])JulieXMLTools.readStream((InputStream)UriUtilities.getInputStreamFromUri((URI)new URI(this.currentUri)), (int)1024), (int)1024, (String)this.forEach, fields, (String)this.currentUri);
        }
        catch (IOException | URISyntaxException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        JCas cas = this.getEmptyJCas();
        Map<String, Object> row = this.rowIterator.next();
        String xmlFragment = (String)row.get("fieldvalue0");
        String identifier = this.currentUri + "#" + this.currentIndex++;
        try {
            this.xmlMapper.parse(xmlFragment.getBytes(), identifier.getBytes(), cas);
        }
        catch (Exception e) {
            LOGGER.error("Exception in next(): currentUri: " + this.currentUri, (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.checkHeader(this.currentUri, cas);
        }
        catch (CASException e) {
            LOGGER.error("Exception in next(): currentUri: " + this.currentUri, (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return cas;
    }

    public boolean hasNext() throws AnalysisEngineProcessException {
        return this.rowIterator.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkHeader(String name, JCas cas) throws CASException {
        Class<?> headerClass;
        Type headerType = cas.getTypeSystem().getType(this.headerTypeName);
        if (null == headerType) {
            throw new CASException("JCAS_INIT_ERROR", new Object[]{"Header type \"" + this.headerTypeName + "\" could not be found in the type system."});
        }
        FSIterator headerIter = cas.getAnnotationIndex(headerType).iterator();
        if (headerIter.hasNext()) {
            try {
                Header header = (Header)headerIter.next();
                if (header.getDocId() != null && header.getDocId() != "" && header.getDocId() != "-1") return;
                header.setDocId(name);
                return;
            }
            catch (ClassCastException e) {
                LOGGER.error("Configured header type is {}. However, the header type must be assignment compatible to de.julielab.jcore.types.Header.", (Object)this.headerTypeName);
                throw new CASException((Throwable)e);
            }
        }
        try {
            headerClass = Class.forName(this.headerTypeName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Header type class {} could not be found.", (Object)this.headerTypeName);
            throw new CASException((Throwable)e);
        }
        Header header = (Header)AnnotationFactory.createAnnotation((JCas)cas, (int)0, (int)0, headerClass);
        header.setDocId(name);
        header.addToIndexes();
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.currentIndex, this.files.length, "entities")};
    }

    public void close() throws IOException {
    }
}

