/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import de.julielab.jcore.types.Header;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLReader
extends CollectionReader_ImplBase {
    private static Logger LOGGER = LoggerFactory.getLogger(XMLReader.class);
    public static final String PARAM_INPUT_DIR = "InputDirectory";
    public static final String PARAM_INPUT_FILE = "InputFile";
    public static final String PARAM_MAPPING_FILE = "MappingFile";
    public static final String PARAM_HEADER_TYPE = "HeaderType";
    private File[] files;
    private int currentIndex = 0;
    private XMLMapper xmlMapper;
    @ConfigurationParameter(name="MappingFile")
    private String mappingFileStr;
    @ConfigurationParameter(name="HeaderType", mandatory=false)
    private String headerTypeName;
    @ConfigurationParameter(name="InputDirectory", mandatory=false)
    private String directoryName;
    @ConfigurationParameter(name="InputFile", mandatory=false)
    private String isSingleFileProcessing;

    public void initialize() throws ResourceInitializationException {
        LOGGER.debug("initialize() - Initializing Medline Reader...");
        this.headerTypeName = (String)this.getConfigParameterValue(PARAM_HEADER_TYPE);
        if (null == this.headerTypeName) {
            this.headerTypeName = "de.julielab.jcore.types.Header";
        }
        this.mappingFileStr = (String)this.getConfigParameterValue(PARAM_MAPPING_FILE);
        InputStream is = null;
        LOGGER.info("Header type set to {}. A header of this type is only created if no header is created using the XML mapping file.", (Object)this.headerTypeName);
        LOGGER.info("Mapping file is searched as file or classpath resource at {}", (Object)this.mappingFileStr);
        File mappingFile = new File(this.mappingFileStr);
        if (mappingFile.exists()) {
            try {
                is = new FileInputStream(mappingFile);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new ResourceInitializationException((Throwable)e1);
            }
        } else {
            if (!this.mappingFileStr.startsWith("/")) {
                this.mappingFileStr = "/" + this.mappingFileStr;
            }
            if ((is = ((Object)((Object)this)).getClass().getResourceAsStream(this.mappingFileStr)) == null) {
                throw new IllegalArgumentException("MappingFile " + this.mappingFileStr + " could not be found as a file or on the classpath (note that the prefixing '/' is added automatically if not already present for classpath lookup)");
            }
        }
        try {
            this.xmlMapper = new XMLMapper(is);
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.files = this.getFilesFromInputDirectory();
    }

    public void getNext(CAS cas) throws IOException, CollectionException {
        File file = this.files[this.currentIndex++];
        LOGGER.debug("getNext(CAS) - Reading file " + file.getName());
        try {
            this.xmlMapper.parse(file, cas.getJCas());
        }
        catch (Exception e) {
            LOGGER.error("Exception in getNext(): file: " + file, (Throwable)e);
            throw new CollectionException((Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.checkHeader(file.getName(), cas.getJCas());
        }
        catch (CASException e) {
            LOGGER.error("Exception in getNext(): file: " + file, (Throwable)e);
            throw new CollectionException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkHeader(String name, JCas cas) throws CollectionException {
        Class<?> headerClass;
        Type headerType = cas.getTypeSystem().getType(this.headerTypeName);
        if (null == headerType) {
            throw new CollectionException("JCAS_INIT_ERROR", new Object[]{"Header type \"" + this.headerTypeName + "\" could not be found in the type system."});
        }
        FSIterator headerIter = cas.getAnnotationIndex(headerType).iterator();
        if (headerIter.hasNext()) {
            try {
                Header header = (Header)headerIter.next();
                if (header.getDocId() != null && header.getDocId() != "" && header.getDocId() != "-1") return;
                header.setDocId(name);
                return;
            }
            catch (ClassCastException e) {
                LOGGER.error("Configured header type is {}. However, the header type must be assignment compatible to de.julielab.jcore.types.Header.", (Object)this.headerTypeName);
                throw new CollectionException((Throwable)e);
            }
        }
        try {
            headerClass = Class.forName(this.headerTypeName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Header type class {} could not be found.", (Object)this.headerTypeName);
            throw new CollectionException((Throwable)e);
        }
        Header header = (Header)AnnotationFactory.createAnnotation((JCas)cas, (int)0, (int)0, headerClass);
        header.setDocId(name);
        header.addToIndexes();
    }

    private File[] getFilesFromInputDirectory() throws ResourceInitializationException {
        this.currentIndex = 0;
        if (this.isSingleProcessing()) {
            return this.getSingleFile();
        }
        this.directoryName = (String)this.getConfigParameterValue(PARAM_INPUT_DIR);
        LOGGER.debug("InputDirectory=" + this.directoryName);
        if (this.directoryName == null) {
            throw new ResourceInitializationException("resource_data_not_valid", new Object[]{"null", PARAM_INPUT_DIR});
        }
        File inputDirectory = new File(this.directoryName.trim());
        if (!inputDirectory.exists() || !inputDirectory.isDirectory()) {
            throw new ResourceInitializationException("resource_data_not_valid", new Object[]{this.directoryName, PARAM_INPUT_DIR});
        }
        return inputDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
    }

    private File[] getSingleFile() throws ResourceInitializationException {
        LOGGER.info("getSingleFile() - MedlineReader is used in SINGLE FILE mode.");
        String singleFile = (String)this.getConfigParameterValue(PARAM_INPUT_FILE);
        if (singleFile == null) {
            return null;
        }
        File file = new File(singleFile.trim());
        if (!file.exists() || file.isDirectory()) {
            throw new ResourceInitializationException("resource_data_not_valid", new Object[]{"file does not exist or is a directoryInputFile"});
        }
        File[] fileList = new File[]{file};
        return fileList;
    }

    private boolean isSingleProcessing() {
        Object value = this.getConfigParameterValue(PARAM_INPUT_FILE);
        if (null != value) {
            this.isSingleFileProcessing = (String)value;
        }
        return this.isSingleFileProcessing != null;
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.currentIndex < this.files.length;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.currentIndex, this.files.length, "entities")};
    }

    public void close() throws IOException {
    }
}

