/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import de.julielab.jcore.reader.xml.Row2CasMapper;
import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.uima.resource.ResourceInitializationException;

public class Initializer {
    public static final String PARAM_ROW_MAPPING = "RowMapping";
    public static final String PARAM_MAPPING_FILE = "MappingFile";
    private final XMLMapper xmlMapper;
    private Row2CasMapper row2CasMapper;

    public Initializer(String mappingFileStr, String[] rowMappingArray, Supplier<List<Map<String, Object>>> columnsToRetrieveSupplier) throws ResourceInitializationException {
        InputStream is = null;
        File mappingFile = new File((String)mappingFileStr);
        if (mappingFile.exists()) {
            try {
                is = new FileInputStream(mappingFile);
            }
            catch (FileNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
        } else {
            if (!((String)mappingFileStr).startsWith("/")) {
                mappingFileStr = "/" + (String)mappingFileStr;
            }
            if ((is = this.getClass().getResourceAsStream((String)mappingFileStr)) == null) {
                throw new IllegalArgumentException("MappingFile " + (String)mappingFileStr + " could not be found as a file or on the classpath (note that the prefixing '/' is added automatically if not already present for classpath lookup)");
            }
        }
        try {
            this.xmlMapper = new XMLMapper(is);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        if (rowMappingArray != null && rowMappingArray.length > 0) {
            this.row2CasMapper = new Row2CasMapper(rowMappingArray, columnsToRetrieveSupplier);
        }
    }

    public XMLMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public Row2CasMapper getRow2CasMapper() {
        return this.row2CasMapper;
    }
}

