/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBReader;
import de.julielab.jcore.reader.xml.CasPopulationException;
import de.julielab.jcore.reader.xml.CasPopulator;
import de.julielab.jcore.reader.xml.Initializer;
import de.julielab.jcore.reader.xml.Row2CasMapper;
import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@ResourceMetaData(name="JCoRe XML Database Reader", description="A collection reader that employs the jcore-xml-mapper to parse XML documents from a PostgreSQL database into CAS instances. For this purpose, the reader requires a mapping file for the jcore-xml-mapper that defines how to map the document XML structure onto CAS types. Which exact data is read from the database table is determines by the table schema that is configured as active in the corpus storage system (CoStoSys) configuration file. If this table schema defines multiple columns to be retrieved, the 'RowMapping' parameter must be set to specify how the extra columns are mapped into the CAS. The reader also supports the joining with more tables to load data distributed across multiple data tables, which then also must be mapped via the 'RowMapping'. This mechanism and this component are part of the Jena Document Information System, JeDIS.", vendor="JULIE Lab Jena, Germany", copyright="JULIE Lab Jena, Germany")
public class XMLDBReader
extends DBReader {
    public static final String PARAM_ROW_MAPPING = "RowMapping";
    public static final String PARAM_MAPPING_FILE = "MappingFile";
    protected XMLMapper xmlMapper;
    protected int totalDocumentCount;
    protected int processedDocuments;
    public static final String DESC_ROW_MAPPING = "In case that the CoStoSys active table schema specified more than two columns to be retrieved, the other columns need a mapping into the CAS.A mapping item has the following form: <column index>=<uima type>#<type feature>:<feature datatype>:defaultValue where the defaultValue is optional. Example: 2=de.julielab.jules.types.max_xmi_id#id:int:0 maps the content of the third (index 2, zero-based) retrieved column (may also belong to an additional table!) to feature \"id\" of the type \"d.j.j.t.max_xmi_id\" which is an int. In case there is no value returned from the database for a document, use a 0 as default.";
    @ConfigurationParameter(name="RowMapping", description="In case that the CoStoSys active table schema specified more than two columns to be retrieved, the other columns need a mapping into the CAS.A mapping item has the following form: <column index>=<uima type>#<type feature>:<feature datatype>:defaultValue where the defaultValue is optional. Example: 2=de.julielab.jules.types.max_xmi_id#id:int:0 maps the content of the third (index 2, zero-based) retrieved column (may also belong to an additional table!) to feature \"id\" of the type \"d.j.j.t.max_xmi_id\" which is an int. In case there is no value returned from the database for a document, use a 0 as default.", mandatory=false)
    protected String[] rowMappingArray;
    public static final String DESC_MAPPING_FILE = "An XML mapping file following the specification required by the jcore-xml-mapper. The mapping file specifies how contents from an XML docuent are to be brought into the CAS.";
    @ConfigurationParameter(name="MappingFile", description="An XML mapping file following the specification required by the jcore-xml-mapper. The mapping file specifies how contents from an XML docuent are to be brought into the CAS.")
    protected String mappingFileStr;
    private Row2CasMapper row2CasMapper;
    private CasPopulator casPopulator;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.mappingFileStr = (String)this.getConfigParameterValue(PARAM_MAPPING_FILE);
        this.rowMappingArray = (String[])this.getConfigParameterValue(PARAM_ROW_MAPPING);
        Initializer initializer = new Initializer(this.mappingFileStr, this.rowMappingArray, () -> this.getAllRetrievedColumns());
        this.row2CasMapper = initializer.getRow2CasMapper();
        this.xmlMapper = initializer.getXmlMapper();
        this.casPopulator = new CasPopulator(this.dbc, this.xmlMapper, this.row2CasMapper, this.rowMappingArray);
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        byte[][] documentData = this.getNextArtifactData();
        this.populateCas(jcas, documentData);
    }

    private void populateCas(JCas jcas, byte[][] documentData) throws CollectionException {
        try {
            this.casPopulator.populateCas(jcas, documentData, (docData, jCas) -> XMLDBReader.setDBProcessingMetaData((DataBaseConnector)this.dbc, (boolean)this.readDataTable, (String)this.tableName, (byte[][])docData, (JCas)jCas));
        }
        catch (CasPopulationException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    protected String getReaderComponentName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

