/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBMultiplier;
import de.julielab.jcore.reader.db.DBReader;
import de.julielab.jcore.reader.xml.CasPopulationException;
import de.julielab.jcore.reader.xml.CasPopulator;
import de.julielab.jcore.reader.xml.Initializer;
import de.julielab.jcore.reader.xml.Row2CasMapper;
import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe XML Database Multiplier", description="This CAS multiplier receives information about documents to be read from an instance of the XML Database Multiplier reader from the jcore-db-reader project. The multiplier employs the jcore-xml-mapper to map the document XML structure into CAS instances. It also supports additional tables sent by the DB Multiplier Reader that are then joined to the main table. This mechanism is used to load separate data from additional database tables and populate the CAS with them via the 'RowMapping' parameter. This component is part of the Jena Document Information System, JeDIS.", vendor="JULIE Lab Jena, Germany", copyright="JULIE Lab Jena, Germany")
public class XMLDBMultiplier
extends DBMultiplier {
    private static final Logger log = LoggerFactory.getLogger(XMLDBMultiplier.class);
    public static final String PARAM_ROW_MAPPING = "RowMapping";
    public static final String PARAM_MAPPING_FILE = "MappingFile";
    protected XMLMapper xmlMapper;
    @ConfigurationParameter(name="RowMapping", mandatory=false, description="In case that the CoStoSys active table schema specified more than two columns to be retrieved, the other columns need a mapping into the CAS.A mapping item has the following form: <column index>=<uima type>#<type feature>:<feature datatype>:defaultValue where the defaultValue is optional. Example: 2=de.julielab.jules.types.max_xmi_id#id:int:0 maps the content of the third (index 2, zero-based) retrieved column (may also belong to an additional table!) to feature \"id\" of the type \"d.j.j.t.max_xmi_id\" which is an int. In case there is no value returned from the database for a document, use a 0 as default.")
    protected String[] rowMappingArray;
    @ConfigurationParameter(name="MappingFile", description="An XML mapping file following the specification required by the jcore-xml-mapper. The mapping file specifies how contents from an XML docuent are to be brought into the CAS.")
    protected String mappingFileStr;
    private Row2CasMapper row2CasMapper;
    private CasPopulator casPopulator;
    private boolean initialized;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mappingFileStr = (String)aContext.getConfigParameterValue(PARAM_MAPPING_FILE);
        this.rowMappingArray = (String[])aContext.getConfigParameterValue(PARAM_ROW_MAPPING);
        Initializer initializer = new Initializer(this.mappingFileStr, null, null);
        this.xmlMapper = initializer.getXmlMapper();
        this.initialized = false;
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        JCas jCas;
        block5: {
            jCas = this.getEmptyJCas();
            try {
                if (!this.documentDataIterator.hasNext()) break block5;
                if (!this.initialized) {
                    try {
                        this.row2CasMapper = new Row2CasMapper(this.rowMappingArray, () -> this.getAllRetrievedColumns());
                    }
                    catch (ResourceInitializationException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                    this.casPopulator = new CasPopulator(this.dbc, this.xmlMapper, this.row2CasMapper, this.rowMappingArray);
                    this.initialized = true;
                }
                byte[][] documentData = (byte[][])this.documentDataIterator.next();
                this.populateCas(jCas, documentData);
            }
            catch (Exception e) {
                log.error("Exception occurred: ", (Throwable)e);
                throw e;
            }
        }
        return jCas;
    }

    private void populateCas(JCas jCas, byte[][] documentData) throws AnalysisEngineProcessException {
        try {
            this.casPopulator.populateCas(jCas, documentData, (docData, jcas) -> DBReader.setDBProcessingMetaData((DataBaseConnector)this.dbc, (boolean)this.readDataTable, (String)this.tableName, (byte[][])docData, (JCas)jcas));
        }
        catch (CasPopulationException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected List<Map<String, Object>> getAllRetrievedColumns() {
        ArrayList fields = new ArrayList();
        Pair numColumnsAndFields = this.dbc.getNumColumnsAndFields(this.tables.length > 1, this.schemaNames);
        return ((List)numColumnsAndFields.getRight()).stream().map(HashMap::new).collect(Collectors.toList());
    }
}

