/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import de.julielab.jcore.reader.xml.CasPopulationException;
import de.julielab.jcore.reader.xml.Row2CasMapper;
import de.julielab.jcore.reader.xmlmapper.mapper.XMLMapper;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasPopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPopulator.class);
    protected static final byte[] comma = ",".getBytes();
    private final DataBaseConnector dbc;
    private final XMLMapper xmlMapper;
    private Row2CasMapper row2CasMapper;
    private String[] rowMappingArray;
    private BiConsumer<byte[][], JCas> dbProcessingMetaDataSetter;

    public CasPopulator(DataBaseConnector dbc, XMLMapper xmlMapper, Row2CasMapper row2CasMapper, String[] rowMappingArray) {
        this.dbc = dbc;
        this.xmlMapper = xmlMapper;
        this.row2CasMapper = row2CasMapper;
        this.rowMappingArray = rowMappingArray;
    }

    public void populateCas(JCas jcas, byte[][] arrayArray, BiConsumer<byte[][], JCas> dbProcessingMetaDataSetter) throws CasPopulationException {
        List pkIndices = this.dbc.getPrimaryKeyIndices();
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        for (int i = 0; i < arrayArray.length; ++i) {
            allIndices.add(i);
        }
        ArrayList xmlIndices = new ArrayList(allIndices);
        for (Integer pkIndex : pkIndices) {
            xmlIndices.remove(pkIndex);
        }
        int xmlIndex = (Integer)xmlIndices.get(0);
        ArrayList<byte[]> primaryKey = new ArrayList<byte[]>();
        int lengthIdentifier = pkIndices.size() - 1;
        for (Integer index : pkIndices) {
            byte[] pkElementValue = arrayArray[index];
            primaryKey.add(pkElementValue);
            lengthIdentifier += pkElementValue.length;
        }
        byte[] identifier = new byte[lengthIdentifier];
        int currentPosition = 0;
        for (int j = 0; j < primaryKey.size(); ++j) {
            System.arraycopy(primaryKey.get(j), 0, identifier, currentPosition, ((byte[])primaryKey.get(j)).length);
            currentPosition += ((byte[])primaryKey.get(j)).length;
            if (j >= primaryKey.size() - 1) continue;
            System.arraycopy(comma, 0, identifier, currentPosition, 1);
            ++currentPosition;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getNext(CAS), primaryKeyValue = {}", (Object)new String(identifier));
        }
        try {
            this.xmlMapper.parse(arrayArray[xmlIndex], identifier, jcas);
            if (arrayArray.length > pkIndices.size() + 1) {
                if (null == this.row2CasMapper || this.row2CasMapper.getRowMapping().size() < xmlIndices.size() - 1) {
                    throw new NullPointerException("There are elements in the returned array that are not mapped to UIMA type classes via the row mapping. Row mapping: " + (this.row2CasMapper == null ? Arrays.toString(this.rowMappingArray) : this.row2CasMapper.getRowMapping()));
                }
                this.row2CasMapper.mapRowToType(arrayArray, jcas);
            }
            dbProcessingMetaDataSetter.accept(arrayArray, jcas);
        }
        catch (Exception e) {
            LOGGER.error("getNext(CAS), primaryKeyValue = " + new String(identifier), (Throwable)e);
            throw new CasPopulationException(e);
        }
        catch (Throwable e) {
            throw new CasPopulationException(e);
        }
    }
}

