/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class Row2CasMapper {
    protected static final int TYPE = 0;
    protected static final int FEATURE_AND_DATATYPE = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(Row2CasMapper.class);
    protected LinkedHashMap<Integer, RowMapElement> rowMapping;
    protected Method addToIndexes;
    private Supplier<List<Map<String, Object>>> columnsToRetrieveSupplier;

    public Row2CasMapper(String[] rowMappingArray, Supplier<List<Map<String, Object>>> columnsToRetrieveSupplier) throws ResourceInitializationException {
        this.columnsToRetrieveSupplier = columnsToRetrieveSupplier;
        this.buildRowMapping(rowMappingArray);
        try {
            this.addToIndexes = TOP.class.getDeclaredMethod("addToIndexes", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public LinkedHashMap<Integer, RowMapElement> getRowMapping() {
        return this.rowMapping;
    }

    public void mapRowToType(byte[][] arrayArray, JCas jcas) throws CollectionException {
        HashMap<String, TOP> typeObjects = new HashMap<String, TOP>();
        HashSet typesToAddToIndexes = new HashSet();
        for (Map.Entry<Integer, RowMapElement> entry : this.rowMapping.entrySet()) {
            Integer index = entry.getKey();
            if (index >= arrayArray.length) {
                LOGGER.warn("There is a mapping definition for column {}. However, only {}\u00a0columns were retrieved from the database.", (Object)index, (Object)arrayArray.length);
            }
            RowMapElement rowMapElement = entry.getValue();
            byte[] data = arrayArray[index];
            if (null == data) {
                if (null == rowMapElement.defaultValue) {
                    List<Map<String, Object>> allRetrievedColumns = this.columnsToRetrieveSupplier.get();
                    throw new IllegalArgumentException("A mapping for database data column " + index + " (column name \"" + allRetrievedColumns.get(index).get("name") + "\") has been defined for the Medline reader, however the returned value is null (does not exist in the database) for this document and no default value was specified in the mapping.");
                }
                data = rowMapElement.defaultValue;
            }
            try {
                String typeClassName = rowMapElement.typeConstructor.getDeclaringClass().getName();
                TOP typeObject = (TOP)typeObjects.get(typeClassName);
                if (typeObject == null) {
                    typeObject = (TOP)rowMapElement.typeConstructor.newInstance(jcas);
                    typeObjects.put(typeClassName, typeObject);
                }
                Method setter = rowMapElement.setter;
                if (data == null) continue;
                FeatureValueCreator valueCreator = rowMapElement.featureValueCreator;
                Object featureValue = valueCreator.getFeatureValue(data);
                setter.invoke((Object)typeObject, featureValue);
                this.addToIndexes.invoke((Object)typeObject, new Object[0]);
            }
            catch (InstantiationException e) {
                LOGGER.error("Instantiation of the type class \"" + rowMapElement.typeConstructor.getName() + "\" specified in the DBMedlineReader descriptor failed.");
                throw new CollectionException((Throwable)e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new CollectionException((Throwable)e);
            }
        }
        try {
            for (Annotation typeObject : typesToAddToIndexes) {
                this.addToIndexes.invoke((Object)typeObject, jcas);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    private LinkedHashMap<Integer, RowMapElement> buildRowMapping(String[] rowMappingArray) throws ResourceInitializationException {
        if (rowMappingArray == null || rowMappingArray.length == 0) {
            return null;
        }
        LinkedHashMap<Integer, RowMapElement> rowMapping = new LinkedHashMap<Integer, RowMapElement>();
        for (String mapping : rowMappingArray) {
            String[] indexToType = mapping.split("=");
            Integer index = Integer.parseInt(indexToType[0].trim());
            String[] typeAndFeature = indexToType[1].trim().split("#");
            String type = typeAndFeature[0].trim();
            String[] featureDatatypeAndDefault = typeAndFeature[1].split(":");
            String feature = featureDatatypeAndDefault[0].trim();
            String datatype = featureDatatypeAndDefault[1].trim();
            byte[] defaultValue = featureDatatypeAndDefault.length > 2 ? featureDatatypeAndDefault[2].trim().getBytes() : null;
            String setterMethod = "set" + StringUtils.capitalize((String)feature);
            try {
                Class<?> typeClass = Class.forName(type);
                Class featureDataTypeClass = null;
                try {
                    featureDataTypeClass = ClassUtils.forName((String)datatype, null);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Feature datatype class \"" + datatype + "\" has not been found. Please deliver the fully qualified Java name.");
                    throw new ResourceInitializationException((Throwable)new IllegalArgumentException("Cannot proceed because feature datatype could not be found, see error log message."));
                }
                Constructor<?> constructor = typeClass.getDeclaredConstructor(JCas.class);
                Method featureSetter = null;
                try {
                    featureSetter = typeClass.getDeclaredMethod(setterMethod, featureDataTypeClass);
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("The type class \"" + type + "\" specified in the DBMedlineReader descriptor does not seem to have a feature called \"" + feature + "\" or this feature is not a String feature. No setter method \"" + setterMethod + "(" + datatype + ")\" has been found.");
                    throw new ResourceInitializationException((Throwable)e);
                }
                RowMapElement mapElement = new RowMapElement(featureSetter, constructor, new FeatureValueCreator(datatype), defaultValue);
                rowMapping.put(index, mapElement);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("The type class \"" + type + "\" specified in the DBMedlineReader descriptor has not been found.");
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
        return rowMapping;
    }

    private class FeatureValueCreator {
        private String featureDatatype;

        public FeatureValueCreator(String featureDatatype) {
            this.featureDatatype = featureDatatype;
        }

        Object getFeatureValue(byte[] data) {
            Object ret;
            if (null == data) {
                throw new IllegalArgumentException("The data to be converted to a feature value must not be null, but it is.");
            }
            switch (this.featureDatatype) {
                case "Integer": 
                case "int": {
                    ret = Integer.parseInt(new String(data));
                    break;
                }
                case "String": {
                    ret = new String(data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type \"" + this.featureDatatype + "\" is currently not supported. You  may however just add it to the " + this.getClass().getCanonicalName() + " class, if you have access to it.");
                }
            }
            return ret;
        }
    }

    private class RowMapElement {
        Method setter;
        Constructor<?> typeConstructor;
        FeatureValueCreator featureValueCreator;
        byte[] defaultValue;

        public RowMapElement(Method setter, Constructor<?> typeConstructor, FeatureValueCreator featureValueCreator, byte[] defaultValue) {
            this.setter = setter;
            this.typeConstructor = typeConstructor;
            this.featureValueCreator = featureValueCreator;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return "RowMapElement [setter=" + this.setter + ", typeConstructor=" + this.typeConstructor + ", featureValueCreator=" + this.featureValueCreator + ", defaultValue=" + (this.defaultValue != null ? new String(this.defaultValue) : null) + "]";
        }
    }
}

