/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CasToXmiConsumer
extends JCasAnnotator_ImplBase {
    private Logger LOGGER = LoggerFactory.getLogger(CasToXmiConsumer.class);
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String CREATE_BATCH_SUBDIRS = "CreateBatchSubDirs";
    private static final String PARAM_COMPRESS = "Compress";
    private static final String PARAM_COMPRESS_SINGLE = "CompressSingle";
    private static final String PARAM_FILE_NAME_TYPE = "FileNameType";
    private static final String PARAM_FILE_NAME_FEATURE = "FileNameFeature";
    private static final String XMI_EXTENSION = ".xmi";
    private static final String GZIP_EXTENSION = ".gz";
    private static final String DEFAULT_FILE_NAME_TYPE = "de.julielab.jcore.types.Header";
    private static final String DEFAULT_FILE_NAME_FEATURE = "source";
    private static final boolean DEFAULT_COMPRESS = false;
    private static final boolean DEFAULT_COMPRESS_SINGLE = false;
    private static final boolean DEFAULT_CREATE_BATCH_SUBDIRS = false;
    private static Set<Integer> randomNumbers = new HashSet<Integer>();
    @ConfigurationParameter(name="OutputDirectory", mandatory=true)
    private File outputDir;
    private File currentSubDir;
    private int doc;
    private boolean compress;
    private boolean compressSingle;
    @ConfigurationParameter(name="CreateBatchSubDirs", mandatory=false)
    private boolean createBatchSubdirs;
    private String fileNameTypeName;
    private String fileNameFeatureName;
    private ZipOutputStream zipOutStream;
    private BufferedOutputStream outStream;
    private boolean zipReady = false;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.LOGGER.info("initializing CasToXmiConsumer...");
        this.outputDir = new File((String)aContext.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (this.outputDir == null) {
            this.LOGGER.error("Mandatory parameter OutputDirectory is missing.");
            throw new ResourceInitializationException();
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.LOGGER.info("Writing XMI files to output directory '" + this.outputDir + "'");
        this.createBatchSubdirs = aContext.getConfigParameterValue(CREATE_BATCH_SUBDIRS) != null ? (Boolean)aContext.getConfigParameterValue(CREATE_BATCH_SUBDIRS) : false;
        this.LOGGER.info("creating subdirectories / giant zip files for each batch: " + this.createBatchSubdirs);
        this.fileNameTypeName = (String)aContext.getConfigParameterValue(PARAM_FILE_NAME_TYPE);
        if (this.fileNameTypeName == null) {
            this.fileNameTypeName = DEFAULT_FILE_NAME_TYPE;
        }
        this.fileNameFeatureName = (String)aContext.getConfigParameterValue(PARAM_FILE_NAME_FEATURE);
        if (this.fileNameFeatureName == null) {
            this.fileNameFeatureName = DEFAULT_FILE_NAME_FEATURE;
        }
        this.LOGGER.info("trying to read file name from " + this.fileNameTypeName + "." + this.fileNameFeatureName);
        this.compressSingle = aContext.getConfigParameterValue(PARAM_COMPRESS_SINGLE) != null ? (Boolean)aContext.getConfigParameterValue(PARAM_COMPRESS_SINGLE) : false;
        this.LOGGER.info("compressing XMIs in one batch in single gzip: " + this.compressSingle);
        if (this.compressSingle) {
            this.compress = false;
            this.LOGGER.info("ignoring 'compress' parameter");
            this.zipReady = false;
        } else {
            this.compress = aContext.getConfigParameterValue(PARAM_COMPRESS) != null ? (Boolean)aContext.getConfigParameterValue(PARAM_COMPRESS) : false;
            this.LOGGER.info("compressing XMIs with gzip (only plays a role because CompressSingle is false): " + this.compress);
            if (this.createBatchSubdirs) {
                String subDirName;
                try {
                    subDirName = this.getNewUniqueFileName();
                }
                catch (ResourceProcessException e) {
                    throw new ResourceInitializationException((Throwable)e);
                }
                this.currentSubDir = new File(this.outputDir, subDirName);
                this.currentSubDir.mkdirs();
                this.LOGGER.info("writing XMIs to subdir " + this.currentSubDir.getPath());
            }
        }
        this.doc = 0;
    }

    private String getNewUniqueFileName() throws ResourceProcessException {
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.LOGGER.error("getNewUniqueFileName() - could not create unique subdirectory name", (Throwable)e);
            throw new ResourceProcessException((Throwable)e);
        }
        String newUniqueFileName = "xmis-" + hostName + "-" + pid + "-" + this.createRandom();
        return newUniqueFileName;
    }

    private void setUpNewGiantZipFile() throws ResourceProcessException {
        FileOutputStream fs;
        String zipName = this.getNewUniqueFileName() + ".zip";
        this.LOGGER.info("creating giant zip file " + zipName);
        try {
            File zipFile = new File(this.outputDir, zipName);
            fs = new FileOutputStream(zipFile);
            this.LOGGER.debug("Preparing giant zip file " + zipFile.getPath());
        }
        catch (FileNotFoundException e) {
            this.LOGGER.error("setUpNewGiantZipFile(): could not prepare output file", (Throwable)e);
            throw new ResourceProcessException((Throwable)e);
        }
        CheckedOutputStream csum = new CheckedOutputStream(fs, new Adler32());
        this.zipOutStream = new ZipOutputStream(csum);
        this.outStream = new BufferedOutputStream(this.zipOutStream);
    }

    private synchronized int createRandom() {
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(1000000);
        while (randomNumbers.contains(randomInt)) {
            randomInt = randomGenerator.nextInt(1000000);
        }
        randomNumbers.add(randomInt);
        return randomInt;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        StringBuilder outFileName;
        block24: {
            ++this.doc;
            CAS aCAS = jcas.getCas();
            outFileName = new StringBuilder();
            Type fileNameType = aCAS.getTypeSystem().getType(this.fileNameTypeName);
            if (fileNameType != null) {
                Feature fileNameFeature = fileNameType.getFeatureByBaseName(this.fileNameFeatureName);
                if (fileNameFeature != null) {
                    JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                    FSIterator iter = indexes.getAllIndexedFS(fileNameType);
                    if (iter.hasNext()) {
                        FeatureStructure fs = (FeatureStructure)iter.next();
                        try {
                            String value = fs.getStringValue(fileNameFeature);
                            if (value != null) {
                                if (!(value = value.trim()).isEmpty()) {
                                    if (value.contains(File.separator)) {
                                        String[] path = value.split(File.separator);
                                        outFileName.append(path[path.length - 1]);
                                    } else {
                                        outFileName.append(value);
                                    }
                                }
                                break block24;
                            }
                            this.LOGGER.debug("No feature value found of type.feature " + this.fileNameTypeName + "." + this.fileNameFeatureName);
                        }
                        catch (CASRuntimeException e) {
                            this.LOGGER.warn("Choose feature with String value!");
                            try {
                                throw new ResourceProcessException();
                            }
                            catch (ResourceProcessException e1) {
                                e1.printStackTrace();
                            }
                        }
                    } else {
                        this.LOGGER.debug("No annotation found of type " + this.fileNameTypeName);
                    }
                } else {
                    this.LOGGER.debug("No feature of type " + this.fileNameTypeName + " found with name " + this.fileNameFeatureName);
                }
            } else {
                this.LOGGER.debug("No type found with name " + this.fileNameTypeName);
            }
        }
        if (outFileName.length() == 0) {
            outFileName.append(this.doc);
        }
        outFileName.append(XMI_EXTENSION);
        if (this.compress) {
            outFileName.append(GZIP_EXTENSION);
        }
        String fileName = outFileName.toString();
        try {
            this.writeXmi(jcas.getCas(), fileName);
            this.LOGGER.info(" Wrote file " + fileName);
        }
        catch (IOException e) {
            try {
                throw new ResourceProcessException((Throwable)e);
            }
            catch (ResourceProcessException e1) {
                e1.printStackTrace();
            }
        }
        catch (SAXException e) {
            try {
                throw new ResourceProcessException((Throwable)e);
            }
            catch (ResourceProcessException e1) {
                e1.printStackTrace();
            }
        }
        catch (ResourceProcessException e) {
            e.printStackTrace();
        }
    }

    private void writeXmi(CAS aCas, String fileName) throws IOException, SAXException, ResourceProcessException {
        if (this.compressSingle) {
            if (!this.zipReady) {
                this.setUpNewGiantZipFile();
                this.zipReady = true;
            }
            this.zipOutStream.putNextEntry(new ZipEntry(fileName));
            XmiCasSerializer.serialize((CAS)aCas, (OutputStream)this.outStream);
            this.outStream.flush();
        } else {
            File outFile = this.createBatchSubdirs ? new File(this.currentSubDir, fileName) : new File(this.outputDir, fileName);
            if (this.compress) {
                GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFile));
                XmiCasSerializer.serialize((CAS)aCas, (OutputStream)out);
                out.finish();
                out.close();
            } else {
                FileOutputStream out = new FileOutputStream(outFile);
                XmiCasSerializer.serialize((CAS)aCas, (OutputStream)out);
                out.close();
            }
        }
    }

    public void batchProcessComplete(ProcessTrace processTrace) throws IOException, ResourceProcessException {
        if (this.createBatchSubdirs) {
            if (this.compressSingle) {
                try {
                    this.outStream.close();
                    this.zipReady = false;
                }
                catch (IOException e) {
                    this.LOGGER.error("batchProcessComplete() - problems closing the output stream", (Throwable)e);
                    throw new IOException(e);
                }
            }
            try {
                String subDirName = this.getNewUniqueFileName();
                this.currentSubDir = new File(this.outputDir, subDirName);
                this.currentSubDir.mkdirs();
                this.LOGGER.info("writing XMIs to subdir " + this.currentSubDir.getPath());
            }
            catch (ResourceProcessException e) {
                this.LOGGER.error("batchProcessComplete(processTrace) - problems creating new unique subdirectory", (Throwable)e);
                throw new ResourceProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws IOException {
        if (this.compressSingle) {
            try {
                this.outStream.close();
                this.zipReady = false;
            }
            catch (IOException e) {
                this.LOGGER.error("collectionProcessComplete() - problems closing the output stream", (Throwable)e);
                throw new IOException(e);
            }
        }
    }
}

