/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml.binary;

import java.nio.charset.StandardCharsets;

public class XmlByteSpan {
    private int start;
    private int end;
    private byte[] xmlData;

    public XmlByteSpan(int start, int end, byte[] xmlData) {
        if (start < 0) {
            throw new IllegalArgumentException("Start offset must by >= 0 but was " + start + " for element " + new String(xmlData, StandardCharsets.UTF_8));
        }
        if (end < 0) {
            throw new IllegalArgumentException("End offset must be >= 0 but was " + end + " for element " + new String(xmlData, StandardCharsets.UTF_8));
        }
        if (end < start) {
            throw new IllegalArgumentException("End offset must be >= start offset but start = " + start + " and end = " + end + " for element " + new String(xmlData, StandardCharsets.UTF_8));
        }
        this.start = start;
        this.end = end;
        this.xmlData = xmlData;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public byte[] getXmlData() {
        return this.xmlData;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public String toString() {
        return new String(this.xmlData, this.start, this.end - this.start, StandardCharsets.UTF_8);
    }
}

