/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml.binary;

import de.julielab.xml.binary.PosDisclosingByteArrayInputStream;
import de.julielab.xml.binary.XmlAttribute;
import de.julielab.xml.binary.XmlStartTag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class AttributeParser {
    public XmlStartTag parse(byte[] elementData) {
        PosDisclosingByteArrayInputStream posBaos = new PosDisclosingByteArrayInputStream(elementData);
        InputStreamReader r = new InputStreamReader(posBaos);
        try {
            int c;
            State s = State.START;
            int tagEnd = -1;
            int elementNameBegin = -1;
            int elementNameEnd = -1;
            int attrNameBegin = -1;
            int attrNameEnd = -1;
            int attrValBegin = -1;
            int attrValEnd = -1;
            int lastPos = -2;
            ArrayList<XmlAttribute> xmlAttributes = new ArrayList<XmlAttribute>();
            int bytesRead = 0;
            while ((c = r.read()) != -1 && s != State.TAG_END) {
                s = this.doStateTransition(c, s);
                ++bytesRead;
                if (c > 127) {
                    ++bytesRead;
                }
                if (c > 2047) {
                    ++bytesRead;
                }
                if (c > 65535) {
                    ++bytesRead;
                }
                if (s == State.IN_ELEM_PREFIX && elementNameBegin == -1) {
                    elementNameBegin = lastPos;
                }
                if (s == State.ELEM_NAME_END && elementNameEnd == -1) {
                    elementNameEnd = lastPos;
                }
                if (s == State.IN_ATTR_NAME && attrNameBegin == -1) {
                    attrNameBegin = lastPos;
                }
                if (s == State.ATTR_NAME_END && attrNameEnd == -1) {
                    attrNameEnd = lastPos;
                }
                if (s == State.IN_ATTR_VALUE && attrValBegin == -1) {
                    attrValBegin = bytesRead;
                }
                if (s == State.ATTR_VALUE_END && attrValBegin != -1 && attrValEnd == -1) {
                    attrValEnd = lastPos;
                }
                if (s == State.TAG_END && tagEnd == -1) {
                    tagEnd = bytesRead;
                }
                lastPos = bytesRead;
                if (attrValEnd == -1) continue;
                XmlAttribute xmlAttribute = new XmlAttribute(attrNameBegin, attrNameEnd, attrValBegin, attrValEnd, elementData);
                xmlAttributes.add(xmlAttribute);
                attrNameBegin = -1;
                attrNameEnd = -1;
                attrValBegin = -1;
                attrValEnd = -1;
            }
            return new XmlStartTag(0, tagEnd, xmlAttributes, elementData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private State doStateTransition(int c, State s) {
        if (c == 34 && s != State.IN_ATTR_VALUE) {
            return State.IN_ATTR_VALUE;
        }
        if (c == 34) {
            return State.ATTR_VALUE_END;
        }
        if (!Character.isWhitespace(c) && c != 60) {
            if (s == State.START) {
                return State.IN_ELEM_PREFIX;
            }
            if (s == State.COLON_PASSED) {
                return State.IN_ELEM_NAME;
            }
            if (s == State.ELEM_NAME_END || s == State.ATTR_VALUE_END) {
                return State.IN_ATTR_NAME;
            }
        } else if (c != 60 && s == State.IN_ELEM_NAME) {
            return State.ELEM_NAME_END;
        }
        if (c == 58 && s == State.IN_ELEM_PREFIX) {
            return State.COLON_PASSED;
        }
        if (c == 61 && s == State.IN_ATTR_NAME) {
            return State.ATTR_NAME_END;
        }
        if (c == 62 && s != State.IN_ATTR_VALUE) {
            return State.TAG_END;
        }
        return s;
    }

    private static enum State {
        START,
        COLON_PASSED,
        IN_ELEM_PREFIX,
        IN_ELEM_NAME,
        ELEM_NAME_END,
        IN_ATTR_NAME,
        ATTR_NAME_END,
        ATTR_VALUE_END,
        IN_ATTR_VALUE,
        TAG_END;

    }
}

