/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.xml.sax.SAXException;

public class XmiCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDir";
    public static final String PARAM_RECURSIVE = "SearchRecursively";
    private ArrayList<File> mFiles;
    private int mCurrentIndex;
    @ConfigurationParameter(name="SearchRecursively", mandatory=false, defaultValue={"false"}, description="If set to true, also searches subdirectories of the input directory for XMI files to read.")
    private boolean searchRecursively;
    @ConfigurationParameter(name="InputDir", mandatory=true, description="File path to the directory to read XMI files from.")
    private String file;

    public void initialize() throws ResourceInitializationException {
        this.file = (String)this.getConfigParameterValue(PARAM_INPUTDIR);
        this.searchRecursively = false;
        if (this.getConfigParameterValue(PARAM_RECURSIVE) != null) {
            this.searchRecursively = (Boolean)this.getConfigParameterValue(PARAM_RECURSIVE);
        }
        File directory = new File(this.file.trim());
        this.mCurrentIndex = 0;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList();
        File[] mDirectories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.isDirectory();
            }
        });
        this.readXmiFilesInDir(this.mFiles, directory);
        if (this.searchRecursively) {
            for (File subDir : mDirectories) {
                this.readXmiFilesInDir(this.mFiles, subDir);
            }
        }
    }

    private void readXmiFilesInDir(List<File> files, File directory) {
        File[] xmiFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return fileName.endsWith("xmi") || fileName.endsWith("gz") || fileName.endsWith("gzip") || fileName.endsWith("zip");
            }
        });
        files.addAll(Arrays.asList(xmiFiles));
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        File currentFile = this.mFiles.get(this.mCurrentIndex++);
        InputStream is = new FileInputStream(currentFile);
        String fileName = currentFile.getName();
        if (fileName.endsWith("gz") || fileName.endsWith("gzip")) {
            is = new GZIPInputStream(is);
        } else if (fileName.endsWith("zip")) {
            is = new ZipInputStream(is);
            ((ZipInputStream)is).getNextEntry();
        }
        try {
            XmiCasDeserializer.deserialize((InputStream)is, (CAS)aCAS);
        }
        catch (SAXException e) {
            throw new CollectionException((Throwable)e);
        }
        finally {
            is.close();
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }
}

