/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import com.google.common.collect.Sets;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.ae.checkpoint.DocumentId;
import de.julielab.jcore.consumer.xmi.DocumentXmiData;
import de.julielab.jcore.consumer.xmi.XmiData;
import de.julielab.jcore.consumer.xmi.XmiDataInsertionException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiDataInserter {
    public static final String FIELD_MAX_XMI_ID = "max_xmi_id";
    private static final Logger log = LoggerFactory.getLogger(XmiDataInserter.class);
    private Boolean updateMode;
    private String schemaDocument;
    private Boolean storeAll;
    private Set<String> annotationModuleColumnNames;
    private DataBaseConnector dbc;
    private Map<DocumentId, Integer> maxXmiIdMap;
    private String componentDbName;
    private String hashColumnName;
    private DecimalFormat df = new DecimalFormat();
    private List<DocumentId> processedDocumentIds;

    public XmiDataInserter(Set<String> annotationModuleColumnNames, DataBaseConnector dbc, String schemaDocument, Boolean storeAll, Boolean updateMode, String componentDbName, String hashColumnName) {
        this.annotationModuleColumnNames = annotationModuleColumnNames;
        this.dbc = dbc;
        this.schemaDocument = schemaDocument;
        this.storeAll = storeAll;
        this.updateMode = updateMode;
        this.componentDbName = componentDbName;
        this.hashColumnName = hashColumnName;
        this.maxXmiIdMap = new HashMap<DocumentId, Integer>();
        this.processedDocumentIds = new ArrayList<DocumentId>();
    }

    public void sendXmiDataToDatabase(String xmiTableName, List<XmiData> annotationModules, String subsetTableName, Set<DocumentId> mirrorResetIds, final Set<DocumentId> unchangedDocuments, Boolean deleteObsolete, Map<DocumentId, String> shaMap) throws XmiDataInsertionException {
        long time;
        Sets.SetView documentIdsWithData;
        block13: {
            log.trace("Sending {} XMI data items", (Object)annotationModules.size());
            Map<DocumentId, List<XmiData>> dataByDoc = annotationModules.stream().collect(Collectors.groupingBy(XmiData::getDocId));
            documentIdsWithData = shaMap != null ? Sets.union(dataByDoc.keySet(), shaMap.keySet()) : dataByDoc.keySet();
            log.trace("There are {} documents with values to be updated in the database.", (Object)documentIdsWithData.size());
            time = System.currentTimeMillis();
            try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                log.debug("Obtained connection after {}ms", (Object)(System.currentTimeMillis() - time));
                conn.setAutoCommit(false);
                class RowIterator
                implements Iterator<Map<String, Object>> {
                    private Iterator<DocumentId> docIdIterator;
                    private FieldConfig fieldConfig;
                    private List<Map<String, String>> fields;
                    final /* synthetic */ Set val$documentIdsWithData;
                    final /* synthetic */ Map val$dataByDoc;
                    final /* synthetic */ Boolean val$deleteObsolete;
                    final /* synthetic */ Map val$shaMap;

                    public RowIterator(boolean returnDocumentsWithMirrorReset) {
                        this.val$documentIdsWithData = set2;
                        this.val$dataByDoc = map;
                        this.val$deleteObsolete = bl;
                        this.val$shaMap = map2;
                        this.fieldConfig = XmiDataInserter.this.dbc.getFieldConfiguration(XmiDataInserter.this.schemaDocument);
                        this.fields = this.fieldConfig.getFields();
                        Predicate<DocumentId> mirrorResetFilterPredicate = docId -> !unchangedDocuments.contains(docId);
                        if (!returnDocumentsWithMirrorReset) {
                            mirrorResetFilterPredicate = Predicate.not(mirrorResetFilterPredicate);
                        }
                        this.docIdIterator = Stream.concat(this.val$documentIdsWithData.stream(), XmiDataInserter.this.processedDocumentIds.stream()).filter(mirrorResetFilterPredicate).distinct().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.docIdIterator.hasNext();
                    }

                    @Override
                    public Map<String, Object> next() {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        DocumentId docId = this.docIdIterator.next();
                        List dataList = this.val$dataByDoc.getOrDefault(docId, Collections.emptyList());
                        Function<Integer, String> fName = num -> this.fields.get((int)num).get("name");
                        int i = 0;
                        for (Integer pkIndex : this.fieldConfig.getPrimaryKeyFieldNumbers()) {
                            row.put(fName.apply(pkIndex), docId.getId()[i++]);
                            if (!log.isTraceEnabled()) continue;
                            log.trace("{}={}", (Object)fName.apply(pkIndex), row.get(fName.apply(pkIndex)));
                        }
                        for (XmiData data : dataList) {
                            row.put(data.getColumnName(), data.data);
                            if (log.isTraceEnabled()) {
                                Object datarep = data.toString();
                                if (data.data instanceof byte[]) {
                                    datarep = "byte array of length " + ((byte[])data.data).length;
                                }
                                if (((String)datarep).length() > 79) {
                                    datarep = ((String)datarep).substring(0, 80);
                                }
                                log.trace("{}={}", (Object)data.getColumnName(), datarep);
                            }
                            if (!data.getClass().equals(DocumentXmiData.class) || XmiDataInserter.this.storeAll.booleanValue()) continue;
                            if (this.fieldConfig.getFields().size() - this.fieldConfig.getPrimaryKey().length < 3) {
                                throw new IllegalArgumentException("The XMI data table schema is set to the schema with name \"" + XmiDataInserter.this.schemaDocument + "\" that specifies the fields \"" + StringUtils.join((Object[])this.fieldConfig.getColumns(), (String)",") + "\". However, this schema is not compatible with XMI base document storage since the storage requires two extra fields to store the maximum XMI ID of the document and the sofa mapping.");
                            }
                            DocumentXmiData docResults = (DocumentXmiData)data;
                            row.put("sofa_mapping", docResults.serializedSofaXmiIdMap);
                            log.trace("{}={}", (Object)"sofa_mapping", (Object)docResults.serializedSofaXmiIdMap);
                        }
                        Integer maxXmiId = XmiDataInserter.this.maxXmiIdMap.get(docId);
                        if (maxXmiId != null) {
                            row.put(XmiDataInserter.FIELD_MAX_XMI_ID, maxXmiId);
                        }
                        if (this.val$deleteObsolete.booleanValue()) {
                            Set<String> missingColumns = this.fieldConfig.getFields().stream().map(f -> (String)f.get("name")).collect(Collectors.toSet());
                            for (String filledColumn : row.keySet()) {
                                missingColumns.remove(filledColumn);
                            }
                            missingColumns.forEach(c -> row.put((String)c, null));
                        }
                        if (XmiDataInserter.this.updateMode.booleanValue() && !unchangedDocuments.contains(docId)) {
                            Set annotationColumnsWithValues = dataList.stream().map(XmiData::getColumnName).collect(Collectors.toSet());
                            log.trace("Annotation columns with values: {}", annotationColumnsWithValues);
                            Sets.SetView columnsWithoutValues = Sets.difference(XmiDataInserter.this.annotationModuleColumnNames, annotationColumnsWithValues);
                            log.trace("Annotation columns without values: {}", (Object)columnsWithoutValues);
                            columnsWithoutValues.forEach(col -> {
                                row.put((String)col, null);
                                log.trace("{}=null", col);
                            });
                        }
                        if (this.val$shaMap != null && !this.val$shaMap.isEmpty()) {
                            String hash = (String)this.val$shaMap.get(docId);
                            row.put(XmiDataInserter.this.hashColumnName, hash);
                            log.trace("{}={}", (Object)XmiDataInserter.this.hashColumnName, (Object)hash);
                        }
                        return row;
                    }

                    @Override
                    public void remove() {
                        throw new NotImplementedException();
                    }
                }
                RowIterator iterator = new RowIterator(true);
                try {
                    if (this.updateMode.booleanValue()) {
                        log.debug("Updating {} XMI CAS data in database table '{}' for documents with mirror subset resets.", (Object)(this.processedDocumentIds.size() - unchangedDocuments.size()), (Object)xmiTableName);
                        this.dbc.updateFromRowIterator((Iterator)iterator, xmiTableName, false, true, this.schemaDocument);
                        log.debug("Updating {} XMI CAS data in database table '{}' for documents without mirror subset resets.", (Object)unchangedDocuments.size(), (Object)xmiTableName);
                        this.dbc.updateFromRowIterator((Iterator)new RowIterator(false), xmiTableName, false, false, this.schemaDocument);
                    } else {
                        log.debug("Inserting {} XMI CAS data into database table '{}'.", (Object)annotationModules.size(), (Object)xmiTableName);
                        this.dbc.importFromRowIterator((Iterator)iterator, xmiTableName, false, this.schemaDocument);
                    }
                }
                catch (Exception e) {
                    log.error("Error occurred while sending data to database. Exception:", (Throwable)e);
                    throw new XmiDataInsertionException(e);
                }
                this.setLastComponent(conn, subsetTableName);
                this.processedDocumentIds.clear();
                log.debug("Committing XMI data to database.");
                conn.commit();
                this.maxXmiIdMap.clear();
            }
            catch (SQLException e) {
                log.error("Database error occurred while updating max-xmi-IDs: {}", (Throwable)e);
                e.printStackTrace();
                SQLException ne = e.getNextException();
                if (null == ne) break block13;
                ne.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            log.debug("Database import of {} XMI documents took {}ms ({}ms per document)", new Object[]{documentIdsWithData.size(), time, this.df.format((double)time / (double)documentIdsWithData.size())});
        }
    }

    private void setLastComponent(CoStoSysConnection conn, String subsetTableName) throws XmiDataInsertionException {
        if (this.processedDocumentIds.isEmpty() || StringUtils.isBlank((CharSequence)subsetTableName)) {
            return;
        }
        FieldConfig annotationFieldConfig = this.dbc.getFieldConfiguration(this.schemaDocument);
        String[] primaryKey = annotationFieldConfig.getPrimaryKey();
        if (primaryKey.length > 1) {
            throw new IllegalArgumentException("Currently, only one-element primary keys are supported.");
        }
        String primaryKeyPsString = StringUtils.join((Object[])annotationFieldConfig.expandPKNames("%s = ?"), (String)" AND ");
        log.debug("Marking {} documents to having been processed by component \"{}\".", (Object)this.processedDocumentIds.size(), (Object)this.componentDbName);
        String sql = String.format("UPDATE %s SET %s='%s' WHERE %s", subsetTableName, "last_component", this.componentDbName, primaryKeyPsString);
        try {
            boolean tryagain;
            do {
                tryagain = false;
                PreparedStatement ps = conn.prepareStatement(sql);
                for (DocumentId docId : this.processedDocumentIds) {
                    for (int i = 0; i < docId.getId().length; ++i) {
                        String pkElement = docId.getId()[i];
                        ps.setString(i + 1, pkElement);
                    }
                    ps.addBatch();
                }
                try {
                    ps.executeBatch();
                }
                catch (BatchUpdateException e) {
                    if (!e.getMessage().contains("deadlock detected")) continue;
                    log.debug("Database transaction deadlock detected while trying to set the last component. Trying again.");
                    tryagain = true;
                }
            } while (tryagain);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException nextException = e.getNextException();
            if (null == nextException) {
                throw new XmiDataInsertionException(e);
            }
            nextException.printStackTrace();
            throw new XmiDataInsertionException(nextException);
        }
    }

    public void putXmiIdMapping(DocumentId docId, Integer newXmiId) {
        this.maxXmiIdMap.put(docId, newXmiId);
    }

    public void addProcessedDocumentId(DocumentId docId) {
        this.processedDocumentIds.add(docId);
    }
}

