/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.costosys.cli.TableNotFoundException;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.TableSchemaMismatchException;
import de.julielab.jcore.ae.checkpoint.DocumentId;
import de.julielab.jcore.ae.checkpoint.DocumentReleaseCheckpoint;
import de.julielab.jcore.consumer.xmi.AnnotationTableManager;
import de.julielab.jcore.consumer.xmi.DocumentXmiData;
import de.julielab.jcore.consumer.xmi.MetaTableManager;
import de.julielab.jcore.consumer.xmi.XmiBufferItem;
import de.julielab.jcore.consumer.xmi.XmiData;
import de.julielab.jcore.consumer.xmi.XmiDataInserter;
import de.julielab.jcore.consumer.xmi.XmiDataInsertionException;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.XmiMetaData;
import de.julielab.jcore.types.ext.DBProcessingMetaData;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.xml.StaxXmiSplitter;
import de.julielab.xml.WholeXmiStaxSplitter;
import de.julielab.xml.XmiSplitter;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.binary.BinaryJeDISNodeEncoder;
import de.julielab.xml.binary.BinaryStorageAnalysisResult;
import de.julielab.xml.util.MissingBinaryMappingException;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ResourceMetaData(name="JCoRe XMI Database Writer", vendor="JULIE Lab Jena, Germany", description="This component is capable of storing the standard UIMA serialization of documents in one or even multiple database tables. The UIMA serialization format is XMI, an XML format that expressed an annotation graph. This component either stores the whole annotation graph in XMI format in a database row, together with the document ID. Alternatively, it makes use of the jcore-xmi-splitter to segment the annotation graph with respect to a user specified list of annotation types. Then, the XMI data of each annotation type is extracted from the document XMI data and stored in a separate table. The tables are created automatically according to the primary key of the active table schema in the Corpus Storage System (CoStoSys) configuration file that is also given as a parameter. The jcore-xmi-db-reader is capable of reading this kind of distributed annotation graph and reassemble a valid XMI document which then cas be deserialized into a CAS. This consumer is UIMA DUCC compatible. It requires the collection reader to forward the work item CAS to the consumer. This is required so the consumer knows that a work item has been finished and that all cached data - in this case the XMI data - should be flushed. This is important! Without the forwarding of the work item CAS, the last batch of cached XMI data will not be written into the database. This component is part of the Jena Document Information System, JeDIS.")
public class XMIDBWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_COSTOSYS_CONFIG = "CostosysConfigFile";
    public static final String PARAM_UPDATE_MODE = "UpdateMode";
    public static final String PARAM_DO_GZIP = "PerformGZIP";
    public static final String PARAM_USE_BINARY_FORMAT = "UseBinaryFormat";
    public static final String PARAM_STORE_ALL = "StoreEntireXmiData";
    public static final String PARAM_TABLE_DOCUMENT = "DocumentTable";
    public static final String PARAM_ANNOS_TO_STORE = "AnnotationsToStore";
    public static final String PARAM_STORE_RECURSIVELY = "StoreRecursively";
    public static final String PARAM_BASE_DOCUMENT_ANNOTATION_TYPES = "BaseDocumentAnnotationTypes";
    public static final String PARAM_DELETE_OBSOLETE_ANNOTATIONS = "DeleteObsoleteAnnotations";
    public static final String PARAM_ATTRIBUTE_SIZE = "IncreasedAttributeSize";
    public static final String PARAM_ANNO_DEFAULT_QUALIFIER = "DefaultAnnotationColumnQualifier";
    public static final String PARAM_COMPONENT_DB_NAME = "ComponentDbName";
    public static final String PARAM_STORE_BASE_DOCUMENT = "StoreBaseDocument";
    public static final String PARAM_WRITE_BATCH_SIZE = "WriteBatchSize";
    public static final String PARAM_XMI_META_SCHEMA = "XmiMetaTablesSchema";
    public static final String PARAM_FEATURES_TO_MAP_DRYRUN = "BinaryFeaturesToMapDryRun";
    public static final String PARAM_BINARY_FEATURES_BLACKLIST = "BinaryFeaturesBlacklist";
    public static final String PARAM_ADD_SHA_HASH = "AddShaHash";
    private static final Logger log = LoggerFactory.getLogger(XMIDBWriter.class);
    private static Map<String, Map<String, Integer>> binaryStringMapping = Collections.emptyMap();
    private static Map<String, Map<String, Boolean>> binaryMappedFeatures = Collections.emptyMap();
    private static Map<String, Map<DocumentId, XmiBufferItem>> splitterResultMap;
    private static Map<String, Map<String, Pair<List<XmiBufferItem>, CountDownLatch>>> xmiBufferItemsToProcess;
    private static CountDownLatch missingMappingsGatheringLatch;
    private static ReentrantLock mappingUpdateLock;
    private DataBaseConnector dbc;
    @ConfigurationParameter(name="UpdateMode", description="If set to false, the attempt to write new data into an XMI document or annotation table that already has data for the respective document, will result in an error. If set to true, there will first occur a check if there already is XMI data for the currently written document and, if so, the contents will be updated. It is important to keep in mind that the update also includes empty data. That is, if an annotation type is specified in 'AnnotationsToStore' for which the current does not have data, possibly existing data will just be deleted.")
    private Boolean updateMode;
    @ConfigurationParameter(name="DeleteObsoleteAnnotations", mandatory=false, defaultValue={"false"}, description="Only in effect if 'StoreBaseDocument' is set to 'true'. Then, already existing annotation tables are retrieved from an internal database table that is specifically maintained to list existing annotation tables. When storing the base document, the annotations in these tables are removed for the document if this parameter is set to 'true', except tables specified in 'AnnotationsToStore'. The idea is that when storing the base document, all existing annotations become obsolete since they refer to a base document that no longer exists.")
    private Boolean deleteObsolete;
    @ConfigurationParameter(name="PerformGZIP", description="Determines if the XMI data should be stored compressed or uncompressed. Without compression, the data will be directly viewable in a database browser, whereas compressed data appears as opaque byte sequence. Compression is supposed to reduce traffic over the network and save storage space on the database server.")
    private Boolean doGzip;
    @ConfigurationParameter(name="IncreasedAttributeSize", mandatory=false, description="Integer that defines the maximum attribute size for the XMIs. Standard (parser wise) is 65536 * 8. It may be necessary to rise this value for larger documents since the document text is stored as an attribute of an XMI element.")
    private Integer attributeSize;
    @ConfigurationParameter(name="StoreEntireXmiData", description="Boolean parameter indicating if the whole document should be stored as one large XMI data block. In this case there must not be any annotations specified for selection and the 'StoreBaseDocument' parameter will have no effect.")
    private Boolean storeAll;
    @ConfigurationParameter(name="DocumentTable", description="String parameter indicating the name of the table where the XMI data will be stored (if StoreEntireXmiData is true) or where the base document is (to be) stored (if the base document or annotation data is written). If the name is schema qualified, i.e. contains a dot, the table name will be used as provided. If no schema is qualified, the active data postgres schema as configured in the CoStoSys configuration will be used to find or create the table.")
    private String docTableParamValue;
    private List<String> unqualifiedAnnotationNames;
    @ConfigurationParameter(name="StoreRecursively", description="Only in effect when storing annotations separately from the base document. If set to true, annotations that are referenced by other annotations, i.e. are (direct or indirect) features of other annotations, they will be stored in the same table as the referencing annotation. For example, POS tags may be store together with tokens this way. If, however, a referenced annotation type is itself to be stored, it will be segmented away and stored in its own table.")
    private Boolean recursively;
    @ConfigurationParameter(name="StoreBaseDocument", description="Boolean parameter indicating if the base document should be stored as well when annotations are specified for selection. The base document is the part of the XMI file that includes the document text. If you want to store annotations right with the base document, specify those in the 'BaseDocumentAnnotationTypes' parameter.")
    private Boolean storeBaseDocument;
    @ConfigurationParameter(name="BaseDocumentAnnotationTypes", mandatory=false, description="Array parameter that takes Java annotation type names. These names will be stored with the base document, if the 'StoreBaseDocument' parameter is set to true.")
    private Set<String> baseDocumentAnnotationTypes;
    @ConfigurationParameter(name="DefaultAnnotationColumnQualifier", mandatory=false, description="This optional parameter specifies the qualifier given to annotation storage columns in the XMI by default. If omitted, no qualifier will added. The column names derived from the annotation types specified with the 'AnnotationsToStore' parameter will be prefixed with this qualifier, separated by the dollar character. The default can be overwritten for individual types. See the description of the 'AnnotationsToStore' parameter.")
    private String defaultAnnotationColumnQualifier;
    @ConfigurationParameter(name="WriteBatchSize", mandatory=false, defaultValue={"50"}, description="The number of processed CASes after which the XMI data should be flushed into the database. Defaults to 50.")
    private int writeBatchSize;
    @ConfigurationParameter(name="XmiMetaTablesSchema", mandatory=false, defaultValue={"public"}, description="Each XMI file defines a number of XML namespaces according to the types used in the document. Those namespaces are stored in a table named '_xmi_namespaces' when splitting annotations in annotation modules for later retrieval by the XMI DB reader. This parameter allows to specify in which Postgres schema this table should be stored. Also, the table listing the annotation tables is stored in this Postgres schema. Defaults to 'public'.")
    private String xmiMetaSchema;
    @ConfigurationParameter(name="UseBinaryFormat", mandatory=false, defaultValue={"false"}, description="If set to true, the XMI data is stored in a binary format to avoid a lot of the XML format overhead. This is meant to reduce storage size.")
    private boolean useBinaryFormat;
    private XmiSplitter splitter;
    private BinaryJeDISNodeEncoder binaryEncoder;
    private List<XmiBufferItem> xmiItemBuffer = new ArrayList<XmiBufferItem>();
    private List<XmiData> annotationModules = new ArrayList<XmiData>();
    private String schemaDocument;
    private String effectiveDocTableName;
    private MetaTableManager metaTableManager;
    private AnnotationTableManager annotationTableManager;
    private int headerlessDocuments = 0;
    private int currentBatchSize = 0;
    private XmiDataInserter annotationInserter;
    @ConfigurationParameter(name="ComponentDbName", description=" Subset tables store the name of the last component that has sent data for a document. This parameter allows to specify a custom name for each CAS DB Consumer. Defaults to the implementation class name.", defaultValue={"XMIDBWriter"})
    private String componentDbName;
    private String subsetTable;
    @ConfigurationParameter(name="CostosysConfigFile", description="File path or classpath resource location of a Corpus Storage System (CoStoSys) configuration file. This file specifies the database to write the XMI data into and the data table schema. This schema must at least define the primary key columns that the storage tables should have for each document. The primary key is currently just the document ID. Thus, at the moment, primary keys can only consist of a single element when using this component. This is a shortcoming of this specific component and must be changed here, if necessary.")
    private String dbcConfigPath;
    @ConfigurationParameter(name="AnnotationsToStore", mandatory=false, description="An array of qualified UIMA type names, for instance de.julielab.jcore.types.Sentence. Annotations of those types are segmented away from the serialized document annotation graph in XMI format for storage in separate tables. When the 'StoreRecursively' parameter is set to true, annotations are stored together with referenced annotations, if those are not specified in the list of additional tables themselves. The table names are directly derived from the annotation type names by converting dots to underlines and adding a postgres schema qualification according to the active data postgres schema defined in the CoStoSys configuration. If an annotation table should be stored or looked up in another postgres schema, prepend the type name with the string '<schema>:', e.g. 'myschema:de.julielab.jcore.types.Token.")
    private String[] annotations;
    @ConfigurationParameter(name="BinaryFeaturesToMapDryRun", mandatory=false, defaultValue={"false"}, description="This parameter is useful when using the binary format and has no effect if not. Then, the UIMA type features that should be mapped to integers will be determined automatically from the input. For each document that has a string (!) feature not seen before, the ratio of occurrences of that feature in the document to the number of distinct values of the feature in the document determines whether or not the feature values will be mapped. This purely one-instance statistical approach can have unwanted results in that a feature is mapped or not mapped that should not be or should. Setting this parameter to true will cause the algorithm that determines which features to map to output details about which features would be mapped without actually writing anything into the database. This is done on the INFO log level. This can be used for new corpora in order to check which features should manually be switched on or off for mapping.")
    private boolean featuresToMapDryRun;
    @ConfigurationParameter(name="BinaryFeaturesBlacklist", mandatory=false, description="A blacklist of full UIMA feature names. The listed features will be excluded from binary value mapping. This makes sense for features with a lot of different values that still come up as being mapping from the automatic features-to-map selection algorithm.It also makes sense for features that only consist of strings of length around 4 characters length or shorter. Then, the replacement with an integer of 4 bytes won't probably make much sense (unless the strings mainly consist of characters that require more than 1 byte, of course).")
    private String[] binaryFeaturesBlacklistParameter;
    @ConfigurationParameter(name="AddShaHash", mandatory=false, description="Possible values: document_text. If this parameter is set to a valid value, the SHA256 hash for the given value will be calculated, base64 encoded and added to each document as a new column in the document table. The column will be named after the parameter value, suffixed by '_sha256'.")
    private String documentItemToHash;
    private Map<DocumentId, String> shaMap;
    private Set<DocumentId> mirrorResetIds;
    private Set<DocumentId> unchangedDocuments;
    private String mappingCacheKey;
    private DocumentReleaseCheckpoint docReleaseCheckpoint;
    private List<DocumentId> currentDocumentIdBatch;
    @ConfigurationParameter(name="JedisSynchronizationKey", mandatory=false, description="If set, the value of this parameter is used to synchronize the 'processed' mark in the subset table documents processed by the pipeline. This is useful when document data is sent batchwise to the database by multiple components: In the case of a crash or manual cancellation of a pipeline run without synchronization is might happen that some components have sent their data and others haven't at the time of termination. To avoid an inconsistent database state,a document will only be marked as finished processed in the JeDIS subset table if all synchronized components in the pipeline have released the document. This is done by the DBCheckpointAE which must be at the end of the pipeline and have the 'IndicateFinished' parameter set to 'true'. Synchronized components are those that disclose this parameter and have a value set to it.")
    private String jedisSyncKey;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        List<String> obsoleteAnnotationTableNames;
        super.initialize(aContext);
        this.checkParameters(aContext);
        this.dbcConfigPath = (String)aContext.getConfigParameterValue(PARAM_COSTOSYS_CONFIG);
        try {
            this.dbc = new DataBaseConnector(this.dbcConfigPath);
        }
        catch (FileNotFoundException e1) {
            throw new ResourceInitializationException((Throwable)e1);
        }
        this.updateMode = aContext.getConfigParameterValue(PARAM_UPDATE_MODE) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_UPDATE_MODE);
        this.doGzip = aContext.getConfigParameterValue(PARAM_DO_GZIP) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_DO_GZIP);
        this.storeAll = aContext.getConfigParameterValue(PARAM_STORE_ALL) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL);
        this.docTableParamValue = (String)aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT);
        this.documentItemToHash = (String)aContext.getConfigParameterValue(PARAM_ADD_SHA_HASH);
        this.storeBaseDocument = aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT);
        this.deleteObsolete = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_DELETE_OBSOLETE_ANNOTATIONS)).orElse(false);
        this.deleteObsolete = this.deleteObsolete & this.storeBaseDocument;
        this.baseDocumentAnnotationTypes = Arrays.stream(Optional.ofNullable((String[])aContext.getConfigParameterValue(PARAM_BASE_DOCUMENT_ANNOTATION_TYPES)).orElse(new String[0])).collect(Collectors.toSet());
        this.attributeSize = (Integer)aContext.getConfigParameterValue(PARAM_ATTRIBUTE_SIZE);
        this.writeBatchSize = Optional.ofNullable((Integer)aContext.getConfigParameterValue(PARAM_WRITE_BATCH_SIZE)).orElse(50);
        this.componentDbName = Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_COMPONENT_DB_NAME)).orElse(((Object)((Object)this)).getClass().getSimpleName());
        this.defaultAnnotationColumnQualifier = (String)aContext.getConfigParameterValue(PARAM_ANNO_DEFAULT_QUALIFIER);
        this.annotations = (String[])Optional.ofNullable(aContext.getConfigParameterValue(PARAM_ANNOS_TO_STORE)).orElse(new String[0]);
        Set annotationsSet = Arrays.stream(this.annotations).collect(Collectors.toCollection(LinkedHashSet::new));
        if (annotationsSet.size() != this.annotations.length) {
            log.warn("Some annotation module names for storage were duplicated. They are de-duplicated to avoid errors when adding the annotation modules into the database.");
        }
        this.xmiMetaSchema = Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_XMI_META_SCHEMA)).orElse("public");
        this.useBinaryFormat = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_USE_BINARY_FORMAT)).orElse(false);
        this.featuresToMapDryRun = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_FEATURES_TO_MAP_DRYRUN)).orElse(false);
        this.binaryFeaturesBlacklistParameter = (String[])aContext.getConfigParameterValue(PARAM_BINARY_FEATURES_BLACKLIST);
        if (this.useBinaryFormat) {
            this.mappingCacheKey = this.dbcConfigPath + "_" + this.xmiMetaSchema;
            binaryMappedFeatures = new ConcurrentHashMap<String, Map<String, Boolean>>();
            binaryMappedFeatures.put(this.mappingCacheKey, new ConcurrentHashMap());
            binaryStringMapping = new ConcurrentHashMap<String, Map<String, Integer>>();
            binaryStringMapping.put(this.mappingCacheKey, new ConcurrentHashMap());
            splitterResultMap = new ConcurrentHashMap<String, Map<DocumentId, XmiBufferItem>>();
            splitterResultMap.put(this.mappingCacheKey, new ConcurrentHashMap());
            xmiBufferItemsToProcess = new ConcurrentHashMap<String, Map<String, Pair<List<XmiBufferItem>, CountDownLatch>>>();
            xmiBufferItemsToProcess.put(this.mappingCacheKey, new ConcurrentHashMap(this.writeBatchSize));
            mappingUpdateLock = new ReentrantLock();
        }
        if (this.useBinaryFormat && this.binaryFeaturesBlacklistParameter != null) {
            binaryMappedFeatures.put(this.mappingCacheKey, Arrays.stream(this.binaryFeaturesBlacklistParameter).collect(Collectors.toMap(Function.identity(), x -> false, (x, y) -> x != false && y != false, ConcurrentHashMap::new)));
        }
        if (this.xmiMetaSchema.isBlank()) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The XMI meta table Postgres schema must either be omitted at all or non-empty but was '" + this.xmiMetaSchema + "'."));
        }
        this.unqualifiedAnnotationNames = Collections.emptyList();
        this.dbc.reserveConnection();
        String hashColumnName = null;
        if (this.storeAll.booleanValue()) {
            this.schemaDocument = this.dbc.addXmiDocumentFieldConfiguration(this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList()), this.doGzip != false || this.useBinaryFormat).getName();
            this.dbc.setActiveTableSchema(this.schemaDocument);
        } else {
            ArrayList<Map> xmiAnnotationColumnsDefinitions = new ArrayList<Map>();
            for (String qualifiedAnnotation : this.annotations) {
                String columnName = AnnotationTableManager.convertQualifiedAnnotationTypeToColumnName(qualifiedAnnotation, this.defaultAnnotationColumnQualifier);
                Map field = FieldConfig.createField((String[])new String[]{"name", columnName, "gzip", String.valueOf(this.doGzip), "retrieve", "true", "type", this.doGzip != false || this.useBinaryFormat ? "bytea" : "xml"});
                xmiAnnotationColumnsDefinitions.add(field);
            }
            if (this.documentItemToHash != null) {
                this.shaMap = new HashMap<DocumentId, String>();
                hashColumnName = this.documentItemToHash + "_sha256";
                xmiAnnotationColumnsDefinitions.add(FieldConfig.createField((String[])new String[]{"name", hashColumnName, "type", "text"}));
                if (this.dbc.tableExists(this.docTableParamValue)) {
                    this.dbc.assureColumnsExist(this.docTableParamValue, Collections.singletonList(hashColumnName), "text");
                }
            }
            String[] fieldConfig = this.dbc.addXmiTextFieldConfiguration(this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList()), xmiAnnotationColumnsDefinitions, this.doGzip != false || this.useBinaryFormat);
            this.schemaDocument = fieldConfig.getName();
            if (null != this.annotations) {
                this.unqualifiedAnnotationNames = new ArrayList<String>(this.annotations.length);
                for (int i = 0; i < this.annotations.length; ++i) {
                    int colonIndex = this.annotations[i].indexOf(58);
                    if (colonIndex < 0) {
                        this.unqualifiedAnnotationNames.add(this.annotations[i]);
                        continue;
                    }
                    String typeName = this.annotations[i].substring(colonIndex + 1);
                    this.unqualifiedAnnotationNames.add(typeName);
                }
            } else {
                this.unqualifiedAnnotationNames = Collections.emptyList();
            }
            this.recursively = aContext.getConfigParameterValue(PARAM_STORE_RECURSIVELY) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_RECURSIVELY);
        }
        try {
            this.annotationTableManager = new AnnotationTableManager(this.dbc, this.docTableParamValue, Arrays.asList(this.annotations), this.doGzip != false || this.useBinaryFormat, this.schemaDocument, this.storeAll, this.storeBaseDocument, this.defaultAnnotationColumnQualifier, this.xmiMetaSchema);
        }
        catch (TableSchemaMismatchException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        HashSet<String> annotationModulesColumnNames = new HashSet<String>();
        this.effectiveDocTableName = this.annotationTableManager.getEffectiveDocumentTableName(this.docTableParamValue);
        if (!this.storeAll.booleanValue()) {
            for (String annotation : this.annotations) {
                String annotationModuleColumName = this.annotationTableManager.convertUnqualifiedAnnotationTypetoColumnName(annotation, this.storeAll);
                annotationModulesColumnNames.add(annotationModuleColumName);
            }
        }
        if (this.dbc.tableExists(this.effectiveDocTableName)) {
            this.checkTableDefinition(this.effectiveDocTableName, this.schemaDocument);
        }
        if (this.updateMode.booleanValue() && !(obsoleteAnnotationTableNames = this.annotationTableManager.getObsoleteAnnotationTableNames()).isEmpty()) {
            log.info("Annotations from the following tables will be obsolete by updating the base document and will be deleted: {}", obsoleteAnnotationTableNames);
        }
        this.splitter = this.storeAll.booleanValue() ? (null != this.attributeSize ? new WholeXmiStaxSplitter(this.docTableParamValue, this.attributeSize.intValue()) : new WholeXmiStaxSplitter(this.docTableParamValue)) : (null != this.attributeSize ? new StaxXmiSplitter(new HashSet<String>(this.unqualifiedAnnotationNames), this.recursively.booleanValue(), this.storeBaseDocument.booleanValue(), this.baseDocumentAnnotationTypes, this.attributeSize.intValue()) : new StaxXmiSplitter(new HashSet<String>(this.unqualifiedAnnotationNames), this.recursively.booleanValue(), this.storeBaseDocument.booleanValue(), this.baseDocumentAnnotationTypes));
        if (this.useBinaryFormat) {
            this.binaryEncoder = new BinaryJeDISNodeEncoder();
        }
        this.mirrorResetIds = new HashSet<DocumentId>();
        this.unchangedDocuments = new HashSet<DocumentId>();
        log.info(XMIDBWriter.class.getName() + " initialized.");
        log.info("Effective document table name: {}", (Object)this.effectiveDocTableName);
        log.info("Is base document stored: {}", (Object)this.storeBaseDocument);
        log.info("CAS XMI data will be GZIPed: {}", (Object)this.doGzip);
        log.info("Use binary format: {}", (Object)this.useBinaryFormat);
        log.info("Is the whole, unsplit XMI document stored: {}", (Object)this.storeAll);
        log.info("Annotations belonging to the base document: {}", this.baseDocumentAnnotationTypes);
        log.info("Annotation types to store in the columns of {}: {}", (Object)this.effectiveDocTableName, this.unqualifiedAnnotationNames);
        log.info("Store annotations recursively: {}", (Object)this.recursively);
        log.info("Update mode: {}", (Object)this.updateMode);
        log.info("Base document table schema: {}", (Object)this.schemaDocument);
        log.info("Batch size of cached documents sent to database: {}", (Object)this.writeBatchSize);
        log.info("Do a dry run and output binary features to map: {}", (Object)this.featuresToMapDryRun);
        this.metaTableManager = new MetaTableManager(this.dbc, this.xmiMetaSchema);
        this.annotationInserter = new XmiDataInserter(annotationModulesColumnNames, this.dbc, this.schemaDocument, this.storeAll, this.updateMode, this.componentDbName, hashColumnName);
        this.dbc.releaseConnections();
        this.jedisSyncKey = (String)aContext.getConfigParameterValue("JedisSynchronizationKey");
        if (this.jedisSyncKey != null) {
            this.docReleaseCheckpoint = DocumentReleaseCheckpoint.get();
            this.docReleaseCheckpoint.register(this.jedisSyncKey);
        }
        this.currentDocumentIdBatch = new ArrayList<DocumentId>();
    }

    private void checkTableDefinition(String annotationTableName, String schemaAnnotation) throws ResourceInitializationException {
        try {
            this.dbc.checkTableHasSchemaColumns(annotationTableName, schemaAnnotation);
        }
        catch (TableNotFoundException | TableSchemaMismatchException e) {
            throw new ResourceInitializationException(e);
        }
    }

    private void checkParameters(UimaContext aContext) throws ResourceInitializationException {
        if (aContext.getConfigParameterValue(PARAM_COSTOSYS_CONFIG) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The database configuration file is null. You must provide the path to a valid configuration file."));
        }
        if (aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The document table is null. You must provide it to either store the entire xmi data, to store the base document  or to update the next possible xmi id."));
        }
        String[] annotations = (String[])aContext.getConfigParameterValue(PARAM_ANNOS_TO_STORE);
        if (aContext.getConfigParameterValue(PARAM_STORE_ALL) == null && annotations == null && aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The parameter to store the entire xmi data is not checked, but there are no annotations specified to store instead. You must provide the names of the selected annotations, if you do not want to  write the entire CAS data."));
        }
        if (aContext.getConfigParameterValue(PARAM_STORE_ALL) != null && ((Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL)).booleanValue() && annotations != null && annotations.length > 0) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The parameter to store the entire xmi data is checked and there are annotations specified to store. You can only either write the entire CAS data or select annotations, but not both."));
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            try {
                Workitem workitem = (Workitem)JCasUtil.selectSingle((JCas)aJCas, Workitem.class);
                log.trace("Work item feature structure found in the current CAS. Sending data to the database and returning.");
                if (workitem.getLastBlock()) {
                    this.collectionProcessComplete();
                } else {
                    this.batchProcessComplete();
                }
                return;
            }
            catch (IllegalArgumentException workitem) {
                Collection metaDatas = JCasUtil.select((JCas)aJCas, DBProcessingMetaData.class);
                if (metaDatas.size() > 1) {
                    throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("There is more than one type of DBProcessingMetaData in document " + JCoReTools.getDocId((JCas)aJCas)));
                }
                Optional<DBProcessingMetaData> metaData = metaDatas.stream().findAny();
                DocumentId docId = this.getDocumentId(aJCas, metaData);
                this.setMirrorResetStateForDocId(docId, metaData);
                if (metaData.isPresent() && metaData.get().getIsDocumentHashUnchanged()) {
                    this.unchangedDocuments.add(docId);
                }
                if (docId == null) {
                    log.warn("The current document does not have a document ID. It is omitted from database import.");
                    return;
                }
                this.currentDocumentIdBatch.add(docId);
                if (this.subsetTable == null && !metaData.isEmpty()) {
                    this.subsetTable = metaData.get().getSubsetTable();
                    if (this.subsetTable != null && this.storeBaseDocument.booleanValue()) {
                        try (CoStoSysConnection costoConn = this.dbc.obtainOrReserveConnection();){
                            Map mirrorSubsetNames = this.dbc.getMirrorSubsetNames(costoConn, this.effectiveDocTableName);
                            if (mirrorSubsetNames.keySet().contains(this.subsetTable.replace("^[^.]\\.", ""))) {
                                throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("The read subset table " + this.subsetTable + " is a mirror subset of the target document table " + this.effectiveDocTableName + " and the base document should be stored. This base document storage would cause all its subset to reset the updated documents. Thus, the subset " + this.subsetTable + " would be partially reset while processing, reading the same documents over and over again. This is therefore illegal."));
                            }
                        }
                    }
                }
                try {
                    this.serializeCasIntoBuffer(aJCas, docId);
                }
                catch (SAXParseException e) {
                    log.error("Could not serialize CAS for document {}", (Object)Arrays.toString(docId.getId()), (Object)e);
                    return;
                }
                this.handleAddhash(aJCas, docId);
                ++this.currentBatchSize;
                if (this.currentBatchSize % this.writeBatchSize == 0) {
                    log.trace("Document nr {} processed, filling batch nr {} of size {}, sending to database.", new Object[]{this.currentBatchSize, this.currentBatchSize / this.writeBatchSize, this.writeBatchSize});
                    this.batchProcessComplete();
                }
            }
        }
        catch (Throwable throwable) {
            String docid = "<unknown>";
            try {
                docid = ((Header)JCasUtil.selectSingle((JCas)aJCas, Header.class)).getDocId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error occurred at document {}: ", (Object)docid, (Object)throwable);
            throw throwable;
        }
    }

    private void setMirrorResetStateForDocId(DocumentId docId, Optional<DBProcessingMetaData> metaData) {
        if (metaData.isPresent()) {
            if (this.storeBaseDocument.booleanValue() && !metaData.get().getIsDocumentHashUnchanged()) {
                this.mirrorResetIds.add(docId);
            }
        } else {
            this.mirrorResetIds.add(docId);
        }
    }

    private void handleAddhash(JCas aJCas, DocumentId docId) {
        if (this.documentItemToHash != null) {
            String documentText = aJCas.getDocumentText();
            byte[] sha = DigestUtils.sha256((byte[])documentText.getBytes());
            String finalHash = Base64.encodeBase64String((byte[])sha);
            this.shaMap.put(docId, finalHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processXmiBuffer() throws AnalysisEngineProcessException {
        if (this.xmiItemBuffer.isEmpty()) {
            log.debug("The XMI item buffer is empty, nothing to do.");
            return false;
        }
        if (this.storeAll.booleanValue()) {
            for (XmiBufferItem item2 : this.xmiItemBuffer) {
                try {
                    DocumentId docId = item2.getDocId();
                    byte[] completeXmiData = item2.getXmiData();
                    Object storedData = this.handleDataZipping(completeXmiData, this.schemaDocument);
                    String dataColumnName = (String)((Map)this.dbc.getActiveTableFieldConfiguration().getFieldsToRetrieve().get(this.dbc.getActiveTableFieldConfiguration().getPrimaryKey().length)).get("name");
                    this.annotationModules.add(new DocumentXmiData(dataColumnName, docId, storedData, null));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (this.useBinaryFormat) {
                boolean hasMissingMappingItems;
                BinaryStorageAnalysisResult requiredMappingAnalysisResult;
                ImmutablePair unanalyzedItems;
                TypeSystem ts = this.xmiItemBuffer.get(0).getTypeSystem();
                Map<DocumentId, XmiSplitterResult> splitterResultsToProcess = this.xmiItemBuffer.stream().collect(Collectors.toMap(XmiBufferItem::getDocId, XmiBufferItem::getSplitterResult, (res1, res2) -> res2));
                Map<String, Map<String, Boolean>> dataColumnName = binaryMappedFeatures;
                synchronized (dataColumnName) {
                    unanalyzedItems = new ImmutablePair(this.xmiItemBuffer.stream().filter(Predicate.not(XmiBufferItem::isProcessedForBinaryMappings)).collect(Collectors.toList()), (Object)new CountDownLatch(2));
                    requiredMappingAnalysisResult = this.binaryEncoder.findMissingItemsForMapping((Collection)((List)unanalyzedItems.getLeft()).stream().flatMap(item -> item.getSplitterResult().jedisNodesInAnnotationModules.stream()).collect(Collectors.toList()), ts, binaryStringMapping.get(this.mappingCacheKey), binaryMappedFeatures.get(this.mappingCacheKey), this.featuresToMapDryRun);
                    boolean bl = hasMissingMappingItems = !requiredMappingAnalysisResult.getMissingValuesToMap().isEmpty();
                    if (hasMissingMappingItems) {
                        xmiBufferItemsToProcess.compute(this.mappingCacheKey, (k, v) -> v != null ? v : new ConcurrentHashMap()).put(Thread.currentThread().getName(), unanalyzedItems);
                    }
                }
                if (hasMissingMappingItems) {
                    log.trace("Required mappings: {}", (Object)requiredMappingAnalysisResult.getMissingValuesToMap());
                    try {
                        while (((CountDownLatch)unanalyzedItems.getRight()).getCount() == 2L) {
                            if (this.updateBinaryMapping(requiredMappingAnalysisResult, splitterResultsToProcess, ts)) continue;
                            missingMappingsGatheringLatch.await();
                            if (((CountDownLatch)unanalyzedItems.getRight()).getCount() != 2L) continue;
                            mappingUpdateLock.lock();
                        }
                    }
                    catch (InterruptedException e) {
                        log.error("Interruption happened while waiting for another thread to gather the missing items of this thread ({}).", (Object)Thread.currentThread().getName());
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                    if (mappingUpdateLock.isHeldByCurrentThread()) {
                        mappingUpdateLock.unlock();
                    }
                    try {
                        ((CountDownLatch)unanalyzedItems.getRight()).await();
                    }
                    catch (InterruptedException e) {
                        log.error("Interruption happened while waiting for another thread to update the missing binary mapping items for this thread ({}).", (Object)Thread.currentThread().getName());
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
                ((List)unanalyzedItems.getLeft()).stream().map(XmiBufferItem::getDocId).forEach(splitterResultMap.get(this.mappingCacheKey)::remove);
            }
            this.createAnnotationModules();
        }
        this.xmiItemBuffer.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBinaryMapping(BinaryStorageAnalysisResult requiredMappingAnalysisResult, Map<DocumentId, XmiSplitterResult> splitterResultsToProcess, TypeSystem ts) throws AnalysisEngineProcessException {
        if (mappingUpdateLock.tryLock()) {
            try {
                missingMappingsGatheringLatch = new CountDownLatch(1);
                List splitterResults = splitterResultMap.get(this.mappingCacheKey).keySet().stream().map(splitterResultMap.get(this.mappingCacheKey)::remove).filter(Objects::nonNull).collect(Collectors.toList());
                List<XmiBufferItem> xmiBufferItemsFromOtherThreads = splitterResults.stream().filter(i -> !splitterResultsToProcess.containsKey(i.getDocId())).collect(Collectors.toList());
                ArrayList<Pair<List<XmiBufferItem>, CountDownLatch>> xmiBufferItemsWaitedFor = new ArrayList<Pair<List<XmiBufferItem>, CountDownLatch>>(xmiBufferItemsToProcess.get(this.mappingCacheKey).values());
                xmiBufferItemsWaitedFor.stream().map(Pair::getLeft).flatMap(Collection::stream).forEach(xmiBufferItemsFromOtherThreads::add);
                xmiBufferItemsWaitedFor.stream().map(Pair::getRight).forEach(CountDownLatch::countDown);
                missingMappingsGatheringLatch.countDown();
                List nodesFromOtherThreads = xmiBufferItemsFromOtherThreads.stream().flatMap(i -> i.getSplitterResult().jedisNodesInAnnotationModules.stream()).collect(Collectors.toList());
                log.trace("Got {} XmiBufferItems from other threads to check for missing mappings", (Object)xmiBufferItemsFromOtherThreads.size());
                BinaryStorageAnalysisResult missingItemsForMapping = this.binaryEncoder.findMissingItemsForMapping(nodesFromOtherThreads, ts, binaryStringMapping.get(this.mappingCacheKey), binaryMappedFeatures.get(this.mappingCacheKey), this.featuresToMapDryRun);
                missingItemsForMapping.getMissingValuesToMap().addAll(requiredMappingAnalysisResult.getMissingValuesToMap());
                missingItemsForMapping.getMissingFeaturesToMap().putAll(requiredMappingAnalysisResult.getMissingFeaturesToMap());
                Pair<Map<String, Integer>, Map<String, Boolean>> updatedMappingAndMappedFeatures = this.metaTableManager.updateBinaryStringMappingTable(missingItemsForMapping, binaryStringMapping.get(this.mappingCacheKey), binaryMappedFeatures.get(this.mappingCacheKey), !this.featuresToMapDryRun);
                Map<String, Map<String, Boolean>> map = binaryMappedFeatures;
                synchronized (map) {
                    binaryStringMapping.put(this.mappingCacheKey, Collections.synchronizedMap((Map)updatedMappingAndMappedFeatures.getLeft()));
                    binaryMappedFeatures.put(this.mappingCacheKey, Collections.synchronizedMap((Map)updatedMappingAndMappedFeatures.getRight()));
                }
                xmiBufferItemsFromOtherThreads.forEach(item -> item.setProcessedForBinaryMappings(true));
                log.debug("Releasing the locks of {} lists of XmiBufferItems to process", (Object)xmiBufferItemsWaitedFor.size());
                for (Pair pair : xmiBufferItemsWaitedFor) {
                    ((List)pair.getLeft()).forEach(item -> item.setProcessedForBinaryMappings(true));
                    ((List)pair.getLeft()).clear();
                    ((CountDownLatch)pair.getRight()).countDown();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                mappingUpdateLock.unlock();
            }
        }
        return false;
    }

    private void createAnnotationModules() throws AnalysisEngineProcessException {
        log.debug("Creating annotation modules for {} items in the XMI buffer", (Object)this.xmiItemBuffer.size());
        for (int i = 0; i < this.xmiItemBuffer.size(); ++i) {
            XmiBufferItem item = this.xmiItemBuffer.get(i);
            DocumentId docId = item.getDocId();
            try {
                XmiSplitterResult result = this.xmiItemBuffer.get(i).getSplitterResult();
                Map<Object, Object> splitXmiData = result.xmiData;
                Integer newXmiId = result.maxXmiId;
                Map currentSofaXmiIdMap = result.currentSofaIdMap;
                if (this.useBinaryFormat) {
                    try {
                        Map encodedXmiData = this.binaryEncoder.encode((Collection)result.jedisNodesInAnnotationModules, item.getTypeSystem(), binaryStringMapping.get(this.mappingCacheKey), binaryMappedFeatures.get(this.mappingCacheKey));
                        splitXmiData = encodedXmiData;
                    }
                    catch (MissingBinaryMappingException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
                splitXmiData = this.convertModuleLabelsToColumnNames((Map<String, ByteArrayOutputStream>)splitXmiData);
                log.trace("The following columns have XMI data: {}", splitXmiData.keySet());
                for (String string : splitXmiData.keySet()) {
                    boolean isBaseDocumentColumn = string.equals("base_document");
                    ByteArrayOutputStream dataBaos = (ByteArrayOutputStream)splitXmiData.get(string);
                    if (null == dataBaos) continue;
                    byte[] dataBytes = dataBaos.toByteArray();
                    Object storedData = this.handleDataZipping(dataBytes, this.schemaDocument);
                    if (this.storeBaseDocument.booleanValue() && isBaseDocumentColumn) {
                        this.annotationModules.add(new DocumentXmiData("base_document", docId, storedData, currentSofaXmiIdMap));
                    } else if (!isBaseDocumentColumn) {
                        this.annotationModules.add(new XmiData(string, docId, storedData));
                    }
                    this.annotationInserter.putXmiIdMapping(docId, newXmiId);
                    log.trace("{} has new value for column {} of length {}, new max xmi ID is {}", new Object[]{docId.getId(), string, dataBytes.length, newXmiId});
                }
                this.annotationInserter.addProcessedDocumentId(docId);
                continue;
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private void serializeCasIntoBuffer(JCas aJCas, DocumentId docId) throws AnalysisEngineProcessException, SAXParseException {
        block13: {
            try {
                ByteArrayOutputStream baos;
                ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
                XmiCasSerializer.serialize((CAS)aJCas.getCas(), (OutputStream)baos);
                ((OutputStream)os).close();
                int nextXmiId = this.determineNextXmiId(aJCas, docId);
                Map<String, Integer> baseDocumentSofaIdMap = this.getOriginalSofaIdMappings(aJCas, docId);
                Collection xmiMetaData = JCasUtil.select((JCas)aJCas, XmiMetaData.class);
                if (xmiMetaData.size() > 1) {
                    throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("There are multiple XmiMetaData annotations in the cas for document " + docId + "."));
                }
                xmiMetaData.forEach(TOP::removeFromIndexes);
                if (this.storeAll.booleanValue()) {
                    this.xmiItemBuffer.add(new XmiBufferItem(baos.toByteArray(), docId, baseDocumentSofaIdMap, nextXmiId, aJCas.getTypeSystem()));
                    break block13;
                }
                XmiSplitterResult result = this.splitter.process(baos.toByteArray(), aJCas.getTypeSystem(), nextXmiId, baseDocumentSofaIdMap);
                XmiBufferItem xmiBufferItem = new XmiBufferItem(result, docId, baseDocumentSofaIdMap, nextXmiId, aJCas.getTypeSystem());
                this.xmiItemBuffer.add(xmiBufferItem);
                if (this.useBinaryFormat) {
                    Map<DocumentId, XmiBufferItem> map = splitterResultMap.get(this.mappingCacheKey);
                    synchronized (map) {
                        splitterResultMap.get(this.mappingCacheKey).put(xmiBufferItem.getDocId(), xmiBufferItem);
                    }
                }
                if (!this.featuresToMapDryRun || !this.useBinaryFormat) {
                    this.metaTableManager.manageXMINamespaces(result.namespaces);
                }
                if (result.currentSofaIdMap.isEmpty()) {
                    throw new IllegalStateException("The XmiSplitter returned an empty Sofa XMI ID map. This is a critical errors since it means that the splitter was not able to resolve the correct Sofa XMI IDs for the annotations that should be stored now.");
                }
            }
            catch (SAXParseException e) {
                log.error("Serialization error occurred, skipping this document: ", (Throwable)e);
                throw e;
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (XMISplitterException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    @NotNull
    private Map<String, ByteArrayOutputStream> convertModuleLabelsToColumnNames(Map<String, ByteArrayOutputStream> splitXmiData) {
        HashMap<String, ByteArrayOutputStream> convertedMap = new HashMap<String, ByteArrayOutputStream>();
        for (Map.Entry<String, ByteArrayOutputStream> e : splitXmiData.entrySet()) {
            if (!e.getKey().equals("DOCUMENT-MODULE")) {
                convertedMap.put(this.annotationTableManager.convertUnqualifiedAnnotationTypetoColumnName(e.getKey(), this.storeAll), e.getValue());
                continue;
            }
            convertedMap.put("base_document", e.getValue());
        }
        return convertedMap;
    }

    private DocumentId getDocumentId(JCas aJCas, Optional<DBProcessingMetaData> metaData) {
        DocumentId docId = null;
        if (metaData.isPresent()) {
            docId = new DocumentId(metaData.get());
        } else {
            log.trace("Could not find the primary key in the DBProcessingMetaData because no meta data annotation is set. Using the document ID as primary key.");
        }
        if (docId == null) {
            AnnotationIndex headerIndex = aJCas.getAnnotationIndex(Header.type);
            FSIterator headerIt = headerIndex.iterator();
            if (!headerIt.hasNext()) {
                String docText = "<no text>";
                if (aJCas.getDocumentText() != null) {
                    int min = Math.min(100, aJCas.getDocumentText().length());
                    docText = aJCas.getDocumentText().substring(0, min);
                }
                log.warn("Got document without a header and without DBProcessingMetaData; cannot obtain document ID. This document will not be written into the database. Document text begins with: {}", (Object)docText);
                ++this.headerlessDocuments;
                return null;
            }
            Header header = (Header)headerIt.next();
            docId = new DocumentId(new String[]{header.getDocId()});
        }
        return docId;
    }

    private Map<String, Integer> getOriginalSofaIdMappings(JCas aJCas, DocumentId docId) {
        XmiMetaData xmiMetaData;
        if (this.storeAll.booleanValue()) {
            return Collections.emptyMap();
        }
        try {
            xmiMetaData = (XmiMetaData)JCasUtil.selectSingle((JCas)aJCas, XmiMetaData.class);
            if (xmiMetaData.getSofaIdMappings() == null) {
                return Collections.emptyMap();
            }
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyMap();
        }
        Map<String, Integer> map = Stream.of(xmiMetaData.getSofaIdMappings().toArray()).map(line -> line.split("=")).collect(Collectors.toMap(split -> split[1], split -> Integer.parseInt(split[0])));
        log.trace("Got Sofa XMI map from the CAS: {} for document {}", map, (Object)docId);
        return map;
    }

    private int determineNextXmiId(JCas aJCas, DocumentId docId) throws AnalysisEngineProcessException {
        int nextXmiId;
        block5: {
            nextXmiId = 0;
            try {
                nextXmiId = ((XmiMetaData)JCasUtil.selectSingle((JCas)aJCas, XmiMetaData.class)).getMaxXmiId();
            }
            catch (IllegalArgumentException e) {
                if (this.storeBaseDocument.booleanValue() || this.storeAll.booleanValue()) break block5;
                throw new AnalysisEngineProcessException((Throwable)new NullPointerException("Error: Could not find the max XMI ID in the CAS. Explanation: The option to store the base document (i.e. the document and possible same basic document meta data annotations) is set to false. Thus, it is assumed that the XMI DB Reader was used to read an existing base document and that only annotation data should be written now. In this case, the current maximum XMI ID for the respective document is required to be found in the CAS to keep this XMI ID unique for each annotation. This information is written into the CAS by the XMI DB Reader, if the respective configuration parameter is set to true. This seems not to be the case since the max XMI ID could not be found. Make sure that the reader adds the max XMI IDto the CAS and run the pipeline again."));
            }
        }
        if (this.storeAll.booleanValue() || this.storeBaseDocument.booleanValue() || this.unqualifiedAnnotationNames.isEmpty()) {
            nextXmiId = 0;
            log.trace("Counting XMI IDs from 0 for document {} since the whole document is stored or the base document is stored or no additional annotations are stored.", (Object)docId);
        } else {
            log.trace("Counting XMI IDs from {} for document {}.", (Object)nextXmiId, (Object)docId);
            if (nextXmiId == 0) {
                log.warn("XMI IDs are counted from 0 for document {}. This is most probably a mistake since annotations should be stored but not the base document. In the base document are always some annotation elements with XMI IDs so those IDs will most probably already be taken and should not be assigned to new annotations.", (Object)docId);
            }
        }
        return nextXmiId;
    }

    protected Object handleDataZipping(byte[] dataBytes, String tableSchemaName) throws IOException {
        Object storedData;
        Map field = (Map)this.dbc.getFieldConfiguration(tableSchemaName).getFields().get(1);
        String xmiFieldType = (String)field.get("type");
        if (this.doGzip.booleanValue() || this.useBinaryFormat) {
            if (!xmiFieldType.equalsIgnoreCase("bytea")) {
                log.warn("The table schema \"" + tableSchemaName + "\" specifies the data type \"" + xmiFieldType + "\" for the field \"" + (String)field.get("name") + "\" which is supposed to be filled with gzipped XMI data. However, binary data should go to a field of type bytea.");
            }
            if (this.doGzip.booleanValue()) {
                ByteArrayOutputStream gzipBaos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(gzipBaos);
                gzos.write(dataBytes);
                gzos.close();
                storedData = gzipBaos.toByteArray();
            } else {
                storedData = dataBytes;
            }
        } else {
            if (!xmiFieldType.equalsIgnoreCase("text") && !xmiFieldType.equalsIgnoreCase("xml")) {
                log.warn("The table schema \"" + tableSchemaName + "\" specifies the data type \"" + xmiFieldType + "\" for the field \"" + (String)field.get("name") + "\" and the contents to be written should be XML. Please use the field type xml or text for such contents.");
            }
            storedData = new String(dataBytes, "UTF-8");
        }
        return storedData;
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        log.debug("Running batchProcessComplete.");
        if (splitterResultMap != null && splitterResultMap.get(this.mappingCacheKey).size() > 10000) {
            log.warn("The 'splitterResultMap' field has size {}. If this number does not shrink again, there is a memory leak.", (Object)splitterResultMap.get(this.mappingCacheKey).size());
        }
        if (xmiBufferItemsToProcess != null && xmiBufferItemsToProcess.get(this.mappingCacheKey).size() > 10000) {
            log.trace("Current size of 'xmiBufferItemsToProcess': {}", (Object)xmiBufferItemsToProcess.get(this.mappingCacheKey).size());
            log.warn("The 'xmiBufferITemsToProcess' field has size {}. If this number does not shrink again, there is a memory leak.", (Object)xmiBufferItemsToProcess.get(this.mappingCacheKey).size());
        }
        if (this.xmiItemBuffer.size() > 100000) {
            log.warn("The 'xmiItemBuffer' field has size {}. If this number does not shrink again, there is a memory leak.", (Object)this.xmiItemBuffer.size());
        }
        if (this.annotationModules.size() > 10000) {
            log.warn("The 'annotationModules' field has size {}. If this number does not shrink again, there is a memory leak.", (Object)this.annotationModules.size());
        }
        try {
            boolean readyToSendData = this.processXmiBuffer();
            if (readyToSendData) {
                if (!this.featuresToMapDryRun || !this.useBinaryFormat) {
                    this.annotationInserter.sendXmiDataToDatabase(this.effectiveDocTableName, this.annotationModules, this.subsetTable, this.mirrorResetIds, this.unchangedDocuments, this.deleteObsolete, this.shaMap);
                } else {
                    log.info("The dry run to see details about features to be mapped in the binary format is activated. No contents are written into the database.");
                }
                log.trace("Clearing {} annotation modules", (Object)this.annotationModules.size());
                this.annotationModules.clear();
                if (this.shaMap != null) {
                    this.shaMap.clear();
                }
                if (this.docReleaseCheckpoint != null) {
                    this.docReleaseCheckpoint.release(this.jedisSyncKey, this.currentDocumentIdBatch.stream());
                }
                this.currentDocumentIdBatch.clear();
                this.mirrorResetIds.clear();
                this.unchangedDocuments.clear();
            }
        }
        catch (XmiDataInsertionException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        log.debug("Running collectionProcessComplete.");
        try {
            this.processXmiBuffer();
            if (!this.featuresToMapDryRun || !this.useBinaryFormat) {
                this.annotationInserter.sendXmiDataToDatabase(this.effectiveDocTableName, this.annotationModules, this.subsetTable, this.mirrorResetIds, this.unchangedDocuments, this.deleteObsolete, this.shaMap);
            } else {
                log.info("The dry run to see details about features to be mapped in the binary format is activated. No contents are written into the database.");
            }
            this.annotationModules.clear();
            if (this.shaMap != null) {
                this.shaMap.clear();
            }
            if (this.docReleaseCheckpoint != null) {
                this.docReleaseCheckpoint.release(this.jedisSyncKey, this.currentDocumentIdBatch.stream());
            }
            this.currentDocumentIdBatch.clear();
            this.mirrorResetIds.clear();
            this.unchangedDocuments.clear();
        }
        catch (XmiDataInsertionException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        if (this.headerlessDocuments > 0) {
            log.info("{} documents without a head occured overall. Those could not be written into the database.", (Object)this.headerlessDocuments);
        }
        this.dbc.close();
    }

    static {
        missingMappingsGatheringLatch = new CountDownLatch(0);
    }
}

