/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import com.google.common.collect.Sets;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.xml.binary.BinaryStorageAnalysisResult;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTableManager {
    public static final String BINARY_MAPPING_TABLE = "_binary_string_mapping";
    public static final String BINARY_FEATURES_TO_MAP_TABLE = "_binary_features_to_map";
    public static final String BINARY_MAPPING_COL_STRING = "mapping_string";
    public static final String BINARY_MAPPING_COL_ID = "mapping_id";
    public static final String BINARY_FEATURES_TO_MAP_COL_FEATURE = "feature";
    public static final String BINARY_FEATURES_TO_MAP_COL_MAP = "map";
    public static final String XMI_NS_TABLE = "_xmi_namespaces";
    public static final String PREFIX = "prefix";
    public static final String NS_URI = "ns_uri";
    private static final Logger log = LoggerFactory.getLogger(MetaTableManager.class);
    private Set<String> knownNSPrefixes = new HashSet<String>();
    private DataBaseConnector dbc;
    private String xmiMetaSchema;

    public MetaTableManager(DataBaseConnector dbc, String xmiMetaSchema) {
        this.dbc = dbc;
        this.xmiMetaSchema = xmiMetaSchema;
        this.createNamespaceTable(dbc);
    }

    void manageXMINamespaces(Map<String, String> nsAndXmiVersionMap) {
        block14: {
            ArrayList<Map.Entry<String, String>> notFound = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> nsEntry : nsAndXmiVersionMap.entrySet()) {
                if (this.knownNSPrefixes.contains(nsEntry.getKey())) continue;
                notFound.add(nsEntry);
            }
            String prefix = null;
            String uri = null;
            if (notFound.size() > 0) {
                try (CoStoSysConnection conn = this.dbc.reserveConnection();){
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s FROM %s", PREFIX, this.xmiMetaSchema + "._xmi_namespaces");
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        String knownPrefix = rs.getString(1);
                        this.knownNSPrefixes.add(knownPrefix);
                    }
                    String template = "INSERT INTO %s VALUES('%s','%s')";
                    for (Map.Entry entry : notFound) {
                        prefix = (String)entry.getKey();
                        uri = (String)entry.getValue();
                        sql = String.format(template, this.xmiMetaSchema + "._xmi_namespaces", prefix, uri);
                        stmt.execute(sql);
                    }
                    for (Map.Entry entry : notFound) {
                        this.knownNSPrefixes.add((String)entry.getKey());
                    }
                }
                catch (PSQLException e) {
                    log.debug("Tried to add already existing namespace \"{}={}\", ignoring.", prefix, uri);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block14;
                    ne.printStackTrace();
                }
            }
        }
    }

    private void createNamespaceTable(DataBaseConnector dbc) {
        block10: {
            if (!dbc.tableExists(this.xmiMetaSchema + "._xmi_namespaces")) {
                try (CoStoSysConnection conn = dbc.obtainOrReserveConnection();){
                    conn.setAutoCommit(true);
                    if (!dbc.schemaExists(this.xmiMetaSchema)) {
                        dbc.createSchema(this.xmiMetaSchema);
                    }
                    Statement stmt = conn.createStatement();
                    log.info("Creating XMI namespace table {}", (Object)(this.xmiMetaSchema + "._xmi_namespaces"));
                    String sql = String.format("CREATE TABLE %s (%s text PRIMARY KEY, %s text)", this.xmiMetaSchema + "._xmi_namespaces", PREFIX, NS_URI);
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block10;
                    ne.printStackTrace();
                }
            }
        }
    }

    public Pair<Map<String, Integer>, Map<String, Boolean>> updateBinaryStringMappingTable(BinaryStorageAnalysisResult analysisResult, Map<String, Integer> currentMappingState, Map<String, Boolean> currentMappedAttributes, boolean writeToDatabase) throws AnalysisEngineProcessException {
        Map<String, Boolean> completeMappedAttributes;
        Map<String, Integer> completeMapping;
        block9: {
            List<String> missingValuesToMap = analysisResult.getMissingValuesToMap().stream().filter(value -> !currentMappingState.containsKey(value)).collect(Collectors.toList());
            Map<String, Boolean> missingFeaturesToMap = analysisResult.getMissingFeaturesToMap().keySet().stream().filter(key -> !currentMappedAttributes.containsKey(key)).collect(Collectors.toMap(Function.identity(), analysisResult.getMissingFeaturesToMap()::get));
            completeMapping = currentMappingState;
            completeMappedAttributes = currentMappedAttributes;
            if (!missingValuesToMap.isEmpty()) {
                String mappingTableName = this.xmiMetaSchema + "._binary_string_mapping";
                String featuresToMapTableName = this.xmiMetaSchema + "._binary_features_to_map";
                Object sql = null;
                try (CoStoSysConnection costoConn = this.dbc.obtainOrReserveConnection();){
                    costoConn.getConnection().beginRequest();
                    boolean wasAutoCommit = costoConn.getAutoCommit();
                    costoConn.setAutoCommit(false);
                    Statement stmt = costoConn.createStatement();
                    this.createBinaryMetaTables(mappingTableName, featuresToMapTableName, costoConn);
                    long time = System.currentTimeMillis();
                    this.obtainLockToMappingTable(mappingTableName, stmt);
                    this.obtainLockToMappedFeaturesTable(featuresToMapTableName, stmt);
                    time = System.currentTimeMillis() - time;
                    log.debug("Thread {} obtained locks to the binary mapping tables after {}ms.", (Object)Thread.currentThread(), (Object)time);
                    time = System.currentTimeMillis();
                    Map<String, Integer> existingMappingWithDbUpdate = this.updateMapping(mappingTableName, currentMappingState, stmt);
                    Map<String, Boolean> featuresToMapFromDatabase = this.readFeaturesToMapFromDatabase(featuresToMapTableName, stmt);
                    ImmutablePair<Map<String, Integer>, Map<String, Boolean>> missing = this.performMappingUpdate(missingValuesToMap, missingFeaturesToMap, featuresToMapFromDatabase, currentMappedAttributes, existingMappingWithDbUpdate, mappingTableName, featuresToMapTableName, costoConn, wasAutoCommit, writeToDatabase);
                    time = System.currentTimeMillis() - time;
                    log.debug("Thread {} had the table lock for {}ms", (Object)Thread.currentThread().getName(), (Object)time);
                    Map missingItemsAfterDbComparison = (Map)missing.getLeft();
                    Map missingFeaturesToMapAfterDbComparison = (Map)missing.getRight();
                    completeMapping = existingMappingWithDbUpdate;
                    completeMapping.putAll(missingItemsAfterDbComparison);
                    completeMappedAttributes = featuresToMapFromDatabase;
                    completeMappedAttributes.putAll(missingFeaturesToMapAfterDbComparison);
                    break block9;
                }
                catch (SQLException e) {
                    log.error("Could not retrieve or update binary meta data tables. The last sent SQL query was {}", sql, (Object)e);
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            log.debug("Not actually updating anything because the missing mappings had been added while waiting for the lock.");
        }
        return new ImmutablePair(completeMapping, completeMappedAttributes);
    }

    private void writeMappingsToDatabase(Map<String, Boolean> currentMappedAttributes, String mappingTableName, String featuresToMapTableName, CoStoSysConnection costoConn, boolean wasAutoCommit, Map<String, Boolean> featuresToMapFromDatabase, Map<String, Integer> stillMissingValuesMap, Map<String, Boolean> stillMissingFeaturesToMap) throws SQLException {
        this.insertMissingMappings(mappingTableName, costoConn, stillMissingValuesMap);
        this.insertMissingFeaturesToMap(featuresToMapTableName, costoConn, stillMissingFeaturesToMap, currentMappedAttributes, featuresToMapFromDatabase);
        log.debug("Thread {} is committing mapping changes to the database.", (Object)Thread.currentThread().getName());
        costoConn.commit();
        costoConn.setAutoCommit(wasAutoCommit);
        costoConn.getConnection().endRequest();
    }

    private ImmutablePair<Map<String, Integer>, Map<String, Boolean>> performMappingUpdate(List<String> missingValuesToMap, Map<String, Boolean> missingFeaturesToMap, Map<String, Boolean> featuresToMapFromDatabase, Map<String, Boolean> currentMappedAttributes, Map<String, Integer> existingMappingWithDbUpdate, String mappingTableName, String featuresToMapTableName, CoStoSysConnection costoConn, boolean wasAutoCommit, boolean writeToDatabase) throws SQLException {
        HashSet stillMissingValuesToMap = new HashSet();
        HashMap<String, Boolean> stillMissingFeaturesToMap = new HashMap<String, Boolean>();
        missingValuesToMap.stream().filter(value -> !existingMappingWithDbUpdate.containsKey(value)).forEach(stillMissingValuesToMap::add);
        missingFeaturesToMap.keySet().stream().filter(key -> !featuresToMapFromDatabase.containsKey(key)).forEach(feature -> stillMissingFeaturesToMap.put((String)feature, (Boolean)missingFeaturesToMap.get(feature)));
        HashMap<String, Integer> stillMissingValuesMap = new HashMap<String, Integer>();
        int id = existingMappingWithDbUpdate.size();
        for (String value2 : stillMissingValuesToMap) {
            stillMissingValuesMap.put(value2, id++);
        }
        if (writeToDatabase) {
            this.writeMappingsToDatabase(currentMappedAttributes, mappingTableName, featuresToMapTableName, costoConn, wasAutoCommit, featuresToMapFromDatabase, stillMissingValuesMap, stillMissingFeaturesToMap);
        }
        return new ImmutablePair(stillMissingValuesMap, stillMissingFeaturesToMap);
    }

    private void obtainLockToMappingTable(String mappingTableName, Statement stmt) throws AnalysisEngineProcessException {
        String sql = null;
        try {
            sql = String.format("LOCK TABLE ONLY %s IN ACCESS EXCLUSIVE MODE", mappingTableName);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            log.error("Could not lock table {}. SQL was: {}", (Object)mappingTableName, sql);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void obtainLockToMappedFeaturesTable(String featuresToMapTableName, Statement stmt) throws AnalysisEngineProcessException {
        String sql = null;
        try {
            sql = String.format("LOCK TABLE ONLY %s IN ACCESS EXCLUSIVE MODE", featuresToMapTableName);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            log.error("Could not lock table {}. SQL was: {}", (Object)featuresToMapTableName, sql);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private Map<String, Integer> updateMapping(String mappingTableName, Map<String, Integer> currentMappingState, Statement stmt) throws AnalysisEngineProcessException {
        long time = System.currentTimeMillis();
        String sql = null;
        try {
            HashMap<String, Integer> existingMapping = new HashMap<String, Integer>(currentMappingState);
            sql = String.format("SELECT %s,%s FROM %s ORDER BY %s DESC LIMIT (SELECT count(%s) FROM %s)-%d", BINARY_MAPPING_COL_STRING, BINARY_MAPPING_COL_ID, mappingTableName, BINARY_MAPPING_COL_ID, BINARY_MAPPING_COL_ID, mappingTableName, currentMappingState.size());
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                existingMapping.put(rs.getString(1), rs.getInt(2));
                ++count;
            }
            log.debug("Received {} previously unknown mappings from the database", (Object)count);
            HashMap<String, Integer> hashMap = existingMapping;
            return hashMap;
        }
        catch (SQLException e) {
            log.error("Could not retrieve mappings from the mapping table {}. SQL was: {}", (Object)mappingTableName, sql);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        finally {
            time = System.currentTimeMillis() - time;
            log.debug("Updating the mapping from the database took {}ms", (Object)time);
        }
    }

    private Map<String, Boolean> readFeaturesToMapFromDatabase(String featuresToMapTableName, Statement stmt) throws AnalysisEngineProcessException {
        String sql = null;
        try {
            HashMap<String, Boolean> existingFeaturesToMap = new HashMap<String, Boolean>();
            sql = String.format("SELECT %s,%s FROM %s", BINARY_FEATURES_TO_MAP_COL_FEATURE, BINARY_FEATURES_TO_MAP_COL_MAP, featuresToMapTableName);
            ResultSet rsFeaturesToMap = stmt.executeQuery(sql);
            while (rsFeaturesToMap.next()) {
                existingFeaturesToMap.put(rsFeaturesToMap.getString(1), rsFeaturesToMap.getBoolean(2));
            }
            return existingFeaturesToMap;
        }
        catch (SQLException e) {
            log.error("Could not retrieve the features to be mapped from {}. SQL was: {}", (Object)featuresToMapTableName, sql);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void insertMissingMappings(String mappingTableName, CoStoSysConnection costoConn, Map<String, Integer> missingItems) {
        log.debug("Inserting {} missing mappings into the mapping table {}", (Object)missingItems.size(), (Object)mappingTableName);
        log.trace("Inserting {}", missingItems.keySet());
        if (missingItems.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        String sql = null;
        try {
            sql = String.format("INSERT INTO %s values(?, ?)", mappingTableName);
            PreparedStatement ps = costoConn.prepareStatement(sql);
            for (String mappedString : missingItems.keySet()) {
                ps.setString(1, mappedString);
                ps.setInt(2, missingItems.get(mappedString));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            log.error("Could not insert new mapping into the table {}. SQL was: ", (Object)mappingTableName, sql);
            time = System.currentTimeMillis() - time;
            log.debug("Inserting new mapping took {}ms", (Object)time);
        }
    }

    private void insertMissingFeaturesToMap(String featuresToMapTableName, CoStoSysConnection costoConn, Map<String, Boolean> stillMissingFeaturesToMap, Map<String, Boolean> currentMappedAttributes, Map<String, Boolean> featuresToMapFromDatabase) {
        String sql = null;
        try {
            HashMap<String, Boolean> toInsert = new HashMap<String, Boolean>(stillMissingFeaturesToMap);
            Sets.SetView predefinedFeaturesToMap = Sets.difference(currentMappedAttributes.keySet(), featuresToMapFromDatabase.keySet());
            predefinedFeaturesToMap.forEach(feature -> {
                toInsert.put((String)feature, (Boolean)currentMappedAttributes.get(feature));
                featuresToMapFromDatabase.put((String)feature, (Boolean)currentMappedAttributes.get(feature));
            });
            sql = String.format("INSERT INTO %s values(?, ?)", featuresToMapTableName);
            PreparedStatement psFeaturesToMap = costoConn.prepareStatement(sql);
            for (String mappedString : toInsert.keySet()) {
                psFeaturesToMap.setString(1, mappedString);
                psFeaturesToMap.setBoolean(2, (Boolean)toInsert.get(mappedString));
                psFeaturesToMap.addBatch();
            }
            psFeaturesToMap.executeBatch();
        }
        catch (SQLException e) {
            log.error("Could not insert new features to be mapped into the table {}. SQL was: {}", (Object)featuresToMapTableName, sql);
        }
    }

    private void createBinaryMetaTables(String mappingTableName, String featuresToMapTableName, CoStoSysConnection costoConn) throws SQLException {
        String sql;
        Statement stmt = costoConn.createStatement();
        try {
            if (!this.dbc.tableExists(mappingTableName)) {
                sql = String.format("CREATE TABLE %s (%s TEXT, %s INTEGER PRIMARY KEY)", mappingTableName, BINARY_MAPPING_COL_STRING, BINARY_MAPPING_COL_ID);
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            log.debug("Tried to create table {} but did not succeed. The table was probably already created by another process or thread.", (Object)mappingTableName);
        }
        costoConn.commit();
        try {
            if (!this.dbc.tableExists(featuresToMapTableName)) {
                sql = String.format("CREATE TABLE %s (%s TEXT, %s BOOL)", featuresToMapTableName, BINARY_FEATURES_TO_MAP_COL_FEATURE, BINARY_FEATURES_TO_MAP_COL_MAP);
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            log.debug("Tried to create table {} but did not succeed. The table was probably already created by another process or thread.", (Object)mappingTableName);
        }
        costoConn.commit();
    }
}

