/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.costosys.cli.TableNotFoundException;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysSQLRuntimeException;
import de.julielab.costosys.dbconnection.util.TableSchemaMismatchException;
import de.julielab.jcore.consumer.xmi.XMIDBWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTableManager {
    public static final String ANNOTATION_LIST_TABLE = "_annotation_tables";
    public static final String TABLE_NAME = "tablename";
    private static final Logger log = LoggerFactory.getLogger(AnnotationTableManager.class);
    private DataBaseConnector dbc;
    private boolean binaryAnnotationColumns;
    private Boolean storeAll;
    private String dbDocumentTableName;
    private String defaultAnnotationQualifier;
    private String xmiMetaSchema;
    private Boolean storeBaseDocument;
    private List<String> obsoleteAnnotationTables;
    private List<String> annotationsToStore;
    private Map<String, String> annotationPgSchemaMap = new HashMap<String, String>();

    public AnnotationTableManager(DataBaseConnector dbc, String rawDocumentTableName, List<String> qualifiedAnnotationsToStore, boolean binaryAnnotationColumns, String documentTableSchema, Boolean storeAll, Boolean storeBaseDocument, String defaultAnnotationQualifier, String xmiMetaSchema) throws TableSchemaMismatchException {
        this.dbc = dbc;
        this.annotationsToStore = qualifiedAnnotationsToStore;
        this.binaryAnnotationColumns = binaryAnnotationColumns;
        this.storeAll = storeAll;
        this.storeBaseDocument = storeBaseDocument;
        this.dbDocumentTableName = this.getEffectiveDocumentTableName(rawDocumentTableName);
        this.defaultAnnotationQualifier = defaultAnnotationQualifier;
        this.xmiMetaSchema = xmiMetaSchema;
        this.createTable(rawDocumentTableName, qualifiedAnnotationsToStore, documentTableSchema);
        this.createAnnotationListTable();
        for (String qualifiedAnnotation : qualifiedAnnotationsToStore) {
            int colonIndex = qualifiedAnnotation.indexOf(58);
            if (colonIndex >= 0) {
                String typeName = qualifiedAnnotation.substring(colonIndex + 1);
                String schemaName = qualifiedAnnotation.substring(0, colonIndex);
                this.annotationPgSchemaMap.put(typeName, schemaName);
                continue;
            }
            if (defaultAnnotationQualifier == null || defaultAnnotationQualifier.isBlank()) continue;
            this.annotationPgSchemaMap.put(qualifiedAnnotation, defaultAnnotationQualifier);
        }
    }

    public static String convertQualifiedAnnotationTypeToColumnName(String qualifiedAnnotationName, String defaultAnnotationColumnQualifier) {
        Object qualifier;
        String[] split = qualifiedAnnotationName.split(":");
        boolean nameIsQualified = qualifiedAnnotationName.contains(":");
        String annotationName = nameIsQualified ? split[1] : split[0];
        Object object = qualifier = nameIsQualified ? split[0] + "$" : "";
        if (((String)qualifier).isEmpty() && defaultAnnotationColumnQualifier != null && !defaultAnnotationColumnQualifier.isBlank()) {
            qualifier = defaultAnnotationColumnQualifier + "$";
        }
        String pgCompatibleAnnotationName = annotationName.toLowerCase().replace(".", "_");
        return (String)qualifier + pgCompatibleAnnotationName;
    }

    public String convertUnqualifiedAnnotationTypetoColumnName(String typeName, boolean storeAll) {
        if (storeAll || typeName.equals(this.dbDocumentTableName)) {
            return this.getEffectiveDocumentTableName(typeName);
        }
        String effectiveTableName = typeName.contains(":") ? typeName.substring(typeName.indexOf(58) + 1) : typeName;
        effectiveTableName = effectiveTableName.replace(".", "_").toLowerCase();
        String schema = this.annotationPgSchemaMap.get(typeName);
        if (schema == null && typeName.contains(":")) {
            schema = typeName.substring(0, typeName.indexOf(58));
        }
        return AnnotationTableManager.convertQualifiedAnnotationTypeToColumnName((String)(schema != null ? schema + ":" : "") + effectiveTableName, this.defaultAnnotationQualifier);
    }

    String getEffectiveDocumentTableName(String documentTableParameter) {
        if (documentTableParameter.contains(".")) {
            return documentTableParameter;
        }
        return this.dbc.getActiveDataPGSchema() + "." + documentTableParameter;
    }

    List<String> getObsoleteAnnotationTableNames() {
        if (!this.storeBaseDocument.booleanValue()) {
            return Collections.emptyList();
        }
        if (null == this.obsoleteAnnotationTables) {
            this.obsoleteAnnotationTables = new ArrayList<String>();
            try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT tablename FROM " + this.xmiMetaSchema + "._annotation_tables");
                while (rs.next()) {
                    this.obsoleteAnnotationTables.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            HashSet<String> annotationsToStoreTableNameSet = new HashSet<String>();
            for (String annotationTypeToStore : this.annotationsToStore) {
                annotationsToStoreTableNameSet.add(this.convertUnqualifiedAnnotationTypetoColumnName(annotationTypeToStore, false));
            }
            Iterator<String> it = this.obsoleteAnnotationTables.iterator();
            while (it.hasNext()) {
                String tablename = it.next();
                if (!annotationsToStoreTableNameSet.contains(tablename)) continue;
                it.remove();
            }
        }
        return this.obsoleteAnnotationTables;
    }

    void createTable(String tableName, List<String> annotationsToStore, String schema) throws TableSchemaMismatchException {
        String effectiveTableName = this.convertUnqualifiedAnnotationTypetoColumnName(tableName, this.storeAll);
        List<String> annotationColumns = annotationsToStore.stream().map(annotationName -> this.convertUnqualifiedAnnotationTypetoColumnName((String)annotationName, this.storeAll)).collect(Collectors.toList());
        if (this.getEffectiveDocumentTableName(tableName).equals(this.dbDocumentTableName)) {
            effectiveTableName = this.dbDocumentTableName;
        }
        try {
            FieldConfig fieldConfig = this.dbc.getFieldConfiguration(schema);
            if (!this.dbc.tableExists(effectiveTableName)) {
                log.info("Creating table '{}' with schema '{}' (columns: {}).", new Object[]{effectiveTableName, schema, fieldConfig.getColumns()});
                String pgSchema = this.getTableSchema(effectiveTableName);
                if (!this.dbc.schemaExists(pgSchema)) {
                    this.dbc.createSchema(pgSchema);
                }
                if (this.storeAll.booleanValue()) {
                    this.dbc.createTable(effectiveTableName, schema, "Created by " + XMIDBWriter.class.getName() + " on " + new Date());
                } else {
                    this.dbc.createTable(effectiveTableName, schema, "Created by " + XMIDBWriter.class.getName() + " on " + new Date() + " to store the base documents and linguistic or semantic annotations. The annotations are stored in the columns named after the annotation type.");
                }
            }
            this.dbc.assureColumnsExist(effectiveTableName, annotationColumns, this.binaryAnnotationColumns ? "bytea" : "xml");
            this.dbc.checkTableHasSchemaColumns(effectiveTableName, schema);
            annotationColumns.forEach(this::addAnnotationTableToList);
        }
        catch (CoStoSysSQLRuntimeException e) {
            log.warn("SQLException was thrown when creating tables. Possibly it is a concurrency issue and it has been tried to create the tables although they had already been created by another process in the meantime. Error was: {}", (Throwable)e);
        }
        catch (TableNotFoundException e) {
            log.error("Table not found", (Throwable)e);
        }
    }

    private String getTableSchema(String effectiveTableName) {
        int dotIndex = effectiveTableName.indexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return effectiveTableName.substring(0, dotIndex);
    }

    void addAnnotationTableToList(String tablename) {
        block9: {
            try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                conn.setAutoCommit(true);
                Statement stmt = conn.createStatement();
                String template = "INSERT INTO %s VALUES('%s')";
                String sql = String.format(template, this.xmiMetaSchema + "._annotation_tables", tablename);
                stmt.execute(sql);
            }
            catch (PSQLException e) {
                log.debug("Tried to add already existing annotation table to annotation list: \"{}\", ignoring.", (Object)tablename);
            }
            catch (SQLException e) {
                e.printStackTrace();
                SQLException ne = e.getNextException();
                if (null == ne) break block9;
                ne.printStackTrace();
            }
        }
    }

    private void createAnnotationListTable() {
        block10: {
            if (!this.dbc.tableExists(this.xmiMetaSchema + "._annotation_tables")) {
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                    conn.setAutoCommit(true);
                    if (!this.dbc.schemaExists(this.xmiMetaSchema)) {
                        this.dbc.createSchema(this.xmiMetaSchema);
                    }
                    Statement stmt = conn.createStatement();
                    String sql = String.format("CREATE TABLE %s (%s text PRIMARY KEY)", this.xmiMetaSchema + "._annotation_tables", TABLE_NAME);
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block10;
                    ne.printStackTrace();
                }
            }
        }
    }
}

