/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.jcore.consumer.xmi.AnnotationTableManager;
import de.julielab.jcore.consumer.xmi.DocumentId;
import de.julielab.jcore.consumer.xmi.DocumentXmiData;
import de.julielab.jcore.consumer.xmi.MetaTableManager;
import de.julielab.jcore.consumer.xmi.XmiData;
import de.julielab.jcore.consumer.xmi.XmiDataInserter;
import de.julielab.jcore.consumer.xmi.XmiDataInsertionException;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.XmiMetaData;
import de.julielab.jcore.types.ext.DBProcessingMetaData;
import de.julielab.xml.StaxXmiSplitter;
import de.julielab.xml.WholeXmiStaxSplitter;
import de.julielab.xml.XmiSplitter;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.util.XMISplitterException;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ResourceMetaData(name="JCoRe XMI Database Writer", vendor="JULIE Lab Jena, Germany", description="This component is capable of storing the standard UIMA serialization of documents in one or even multiple database tables. The UIMA serialization format is XMI, an XML format that expressed an annotation graph. This component either stores the whole annotation graph in XMI format in a database row, together with the document ID. Alternatively, it makes use of the jcore-xmi-splitter to segment the annotation graph with respect to a user specified list of annotation types. Then, the XMI data of each annotation type is extracted from the document XMI data and stored in a separate table. The tables are created automatically according to the primary key of the active table schema in the Corpus Storage System (CoStoSys) configuration file that is also given as a parameter. The jcore-xmi-db-reader is capable of reading this kind of distributed annotation graph and reassemble a valid XMI document which then cas be deserialized into a CAS. This consumer is UIMA DUCC compatible. It requires the collection reader to forward the work item CAS to the consumer. This is required so the consumer knows that a work item has been finished and that all cached data - in this case the XMI data - should be flushed. This is important! Without the forwarding of the work item CAS, the last batch of cached XMI data will not be written into the database. This component is part of the Jena Document Information System, JeDIS.")
public class XMIDBWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_COSTOSYS_CONFIG = "CostosysConfigFile";
    public static final String PARAM_UPDATE_MODE = "UpdateMode";
    public static final String PARAM_DO_GZIP = "PerformGZIP";
    public static final String PARAM_STORE_ALL = "StoreEntireXmiData";
    public static final String PARAM_TABLE_DOCUMENT = "DocumentTable";
    public static final String PARAM_ANNOS_TO_STORE = "AnnotationsToStore";
    public static final String PARAM_STORE_RECURSIVELY = "StoreRecursively";
    public static final String PARAM_BASE_DOCUMENT_ANNOTATION_TYPES = "BaseDocumentAnnotationTypes";
    public static final String PARAM_DELETE_OBSOLETE_ANNOTATIONS = "DeleteObsoleteAnnotations";
    public static final String PARAM_ATTRIBUTE_SIZE = "IncreasedAttributeSize";
    public static final String PARAM_ANNO_STORAGE_PG_SCHEMA = "AnnotationStoragePostgresSchema";
    public static final String PARAM_COMPONENT_DB_NAME = "ComponentDbName";
    public static final String PARAM_STORE_BASE_DOCUMENT = "StoreBaseDocument";
    public static final String PARAM_WRITE_BATCH_SIZE = "WriteBatchSize";
    private static final Logger log = LoggerFactory.getLogger(XMIDBWriter.class);
    private DataBaseConnector dbc;
    @ConfigurationParameter(name="UpdateMode", description="If set to false, the attempt to write new data into an XMI document or annotation table that already has data for the respective document, will result in an error. If set to true, there will first occur a check if there already is XMI data for the currently written document and, if so, the contents will be updated. It is important to keep in mind that the update also includes empty data. That is, if an annotation type is specified in 'AnnotationsToStore' for which the current does not have data, possibly existing data will just be deleted.")
    private Boolean updateMode;
    @ConfigurationParameter(name="DeleteObsoleteAnnotations", mandatory=false, defaultValue={"false"}, description="Only in effect if 'StoreBaseDocument' is set to 'true'. Then, already existing annotation tables are retrieved from an internal database table the is specifically maintained to list existing annotation tables. When storing the base document, the annotations in these tables are removed for the document if this parameter is set to 'true', except tables specified in 'AnnotationsToStore'. The idea is that when storing the base document, all existing annotations become obsolete since they refer to a base document that no longer exists.")
    private Boolean deleteObsolete;
    @ConfigurationParameter(name="PerformGZIP", description="Determines if the XMI data should be stored compressed or uncompressed. Without compression, the data will be directly viewable in a database browser, whereas compressed data appears as opaque byte sequence. Compression is supposed to reduce traffic over the network and save storage space on the database server.")
    private Boolean doGzip;
    @ConfigurationParameter(name="IncreasedAttributeSize", mandatory=false, description="Integer that defines the maximum attribute size for the XMIs. Standard (parser wise) is 65536 * 8. It may be necessary to rise this value for larger documents since the document text is stored as an attribute of an XMI element.")
    private Integer attributeSize;
    @ConfigurationParameter(name="StoreEntireXmiData", description="Boolean parameter indicating if the whole document should be stored as one large XMI data block. In this case there must not be any annotations specified for selection and the 'StoreBaseDocument' parameter will have no effect.")
    private Boolean storeAll;
    @ConfigurationParameter(name="DocumentTable", description="String parameter indicating the name of the table where the XMI data will be stored (if StoreEntireXmiData is true) or where the base document is (to be) stored (if the base document or annotation data is written). If the name is schema qualified, i.e. contains a dot, the table name will be used as provided. If no schema is qualified, the active data postgres schema as configured in the CoStoSys configuration will be used to find or create the table.")
    private String docTableParamValue;
    private List<String> annotationsToStore;
    @ConfigurationParameter(name="StoreRecursively", description="Only in effect when storing annotations separately from the base document. If set to true, annotations that are referenced by other annotations, i.e. are (direct or indirect) features of other annotations, they will be stored in the same table as the referencing annotation. For example, POS tags may be store together with tokens this way. If, however, a referenced annotation type is itself to be stored, it will be segmented away and stored in its own table.")
    private Boolean recursively;
    @ConfigurationParameter(name="StoreBaseDocument", description="Boolean parameter indicating if the base document should be stored as well when annotations are specified for selection. The base document is the part of the XMI file that includes the document text. If you want to store annotations right with the base document, specify those in the 'BaseDocumentAnnotationTypes' parameter.")
    private Boolean storeBaseDocument;
    @ConfigurationParameter(name="BaseDocumentAnnotationTypes", mandatory=false, description="Array parameter that takes Java annotation type names. These names will be stored with the base document, if the 'StoreBaseDocument' parameter is set to true.")
    private Set<String> baseDocumentAnnotationTypes;
    @ConfigurationParameter(name="AnnotationStoragePostgresSchema", mandatory=false, description="This optional parameter specifies the Postgres schema in which the XMI annotation storage tables are located by default. If omitted, the active data schema from the CoStoSys configuration is used. The tables derived from the annotation types specified with the 'AnnotationsToStore' parameter will be stored in this postgres schema. The default can be overwritten for individual types. See the description of the 'AnnotationsToStore' parameter.")
    private String annotationStorageSchema;
    @ConfigurationParameter(name="WriteBatchSize", mandatory=false, defaultValue={"50"}, description="The number of processed CASes after which the XMI data should be flushed into the database. Defaults to 50.")
    private int writeBatchSize;
    private XmiSplitter splitter;
    private LinkedHashMap<String, List<XmiData>> serializedCASes = new LinkedHashMap();
    private Map<String, List<DocumentId>> tablesWithoutData = new HashMap<String, List<DocumentId>>();
    private String schemaDocument;
    private String schemaAnnotation;
    private String effectiveDocTableName;
    private MetaTableManager metaTableManager;
    private AnnotationTableManager annotationTableManager;
    private int headerlessDocuments = 0;
    private int currentBatchSize = 0;
    private XmiDataInserter annotationInserter;
    @ConfigurationParameter(name="ComponentDbName", description=" Subset tables store the name of the last component that has sent data for a document. This parameter allows to specify a custom name for each CAS DB Consumer. Defaults to the implementation class name.", defaultValue={"XMIDBWriter"})
    private String componentDbName;
    private String subsetTable;
    @ConfigurationParameter(name="CostosysConfigFile", description="File path or classpath resource location of a Corpus Storage System (CoStoSys) configuration file. This file specifies the database to write the XMI data into and the data table schema. This schema must at least define the primary key columns that the storage tables should have for each document. The primary key is currently just the document ID. Thus, at the moment, primary keys can only consist of a single element when using this component. This is a shortcoming of this specific component and must be changed here, if necessary.")
    private String dbcConfigPath;
    @ConfigurationParameter(name="AnnotationsToStore", mandatory=false, description="An array of qualified UIMA type names, for instance de.julielab.jcore.types.Sentence. Annotations of those types are segmented away from the serialized document annotation graph in XMI format for storage in separate tables. When the 'StoreRecursively' parameter is set to true, annotations are stored together with referenced annotations, if those are not specified in the list of additional tables themselves. The table names are directly derived from the annotation type names by converting dots to underlines and adding a postgres schema qualification according to the active data postgres schema defined in the CoStoSys configuration. If an annotation table should be stored or looked up in another postgres schema, prepend the type name with the string '<schema>:', e.g. 'myschema:de.julielab.jcore.types.Token.")
    private String[] annotations;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        List<String> obsoleteAnnotationTableNames;
        super.initialize(aContext);
        this.checkParameters(aContext);
        this.dbcConfigPath = (String)aContext.getConfigParameterValue(PARAM_COSTOSYS_CONFIG);
        try {
            this.dbc = new DataBaseConnector(this.dbcConfigPath);
        }
        catch (FileNotFoundException e1) {
            throw new ResourceInitializationException((Throwable)e1);
        }
        this.updateMode = aContext.getConfigParameterValue(PARAM_UPDATE_MODE) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_UPDATE_MODE);
        this.deleteObsolete = aContext.getConfigParameterValue(PARAM_DELETE_OBSOLETE_ANNOTATIONS) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_DELETE_OBSOLETE_ANNOTATIONS);
        this.doGzip = aContext.getConfigParameterValue(PARAM_DO_GZIP) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_DO_GZIP);
        this.storeAll = (Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL);
        this.docTableParamValue = (String)aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT);
        this.storeBaseDocument = aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT);
        this.baseDocumentAnnotationTypes = Arrays.stream((Object[])Optional.ofNullable((String[])aContext.getConfigParameterValue(PARAM_BASE_DOCUMENT_ANNOTATION_TYPES)).orElse(new String[0])).collect(Collectors.toSet());
        this.attributeSize = (Integer)aContext.getConfigParameterValue(PARAM_ATTRIBUTE_SIZE);
        this.writeBatchSize = Optional.ofNullable((Integer)aContext.getConfigParameterValue(PARAM_WRITE_BATCH_SIZE)).orElse(50);
        this.componentDbName = Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_COMPONENT_DB_NAME)).orElse(((Object)((Object)this)).getClass().getSimpleName());
        this.annotationStorageSchema = Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_ANNO_STORAGE_PG_SCHEMA)).orElse(this.dbc.getActiveDataPGSchema());
        ArrayList<String> annotationsToStoreTableNames = new ArrayList<String>();
        this.annotationsToStore = Collections.emptyList();
        if (this.storeAll.booleanValue()) {
            this.schemaDocument = this.dbc.addXmiDocumentFieldConfiguration(this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList()), this.doGzip.booleanValue()).getName();
        } else {
            this.schemaDocument = this.dbc.addXmiTextFieldConfiguration(this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList()), this.doGzip.booleanValue()).getName();
            this.schemaAnnotation = this.dbc.addXmiAnnotationFieldConfiguration(this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList()), this.doGzip.booleanValue()).getName();
            this.annotations = (String[])aContext.getConfigParameterValue(PARAM_ANNOS_TO_STORE);
            this.annotationsToStore = null != this.annotations ? new ArrayList<String>(Arrays.asList(this.annotations)) : Collections.emptyList();
            this.recursively = (Boolean)aContext.getConfigParameterValue(PARAM_STORE_RECURSIVELY) == null ? false : (Boolean)aContext.getConfigParameterValue(PARAM_STORE_RECURSIVELY);
        }
        this.dbc.reserveConnection();
        try {
            this.annotationTableManager = new AnnotationTableManager(this.dbc, this.docTableParamValue, this.annotationsToStore, this.schemaDocument, this.schemaAnnotation, this.storeAll, this.storeBaseDocument, this.annotationStorageSchema);
        }
        catch (TableSchemaMismatchException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.effectiveDocTableName = this.annotationTableManager.getEffectiveDocumentTableName(this.docTableParamValue);
        if (this.storeBaseDocument.booleanValue() || this.storeAll.booleanValue()) {
            this.serializedCASes.put(this.effectiveDocTableName, new ArrayList());
        }
        if (!this.storeAll.booleanValue()) {
            for (String annotation : this.annotationsToStore) {
                String annotationTableName = this.annotationTableManager.convertAnnotationTypeToTableName(annotation, this.storeAll);
                if (this.dbc.tableExists(annotationTableName)) {
                    this.checkTableDefinition(annotationTableName, this.schemaAnnotation);
                }
                this.serializedCASes.put(annotationTableName, new ArrayList());
                this.tablesWithoutData.put(annotationTableName, new ArrayList());
                annotationsToStoreTableNames.add(annotationTableName);
            }
        }
        if (this.dbc.tableExists(this.effectiveDocTableName)) {
            this.checkTableDefinition(this.effectiveDocTableName, this.schemaDocument);
        }
        if (this.updateMode.booleanValue() && !(obsoleteAnnotationTableNames = this.annotationTableManager.getObsoleteAnnotationTableNames()).isEmpty()) {
            log.info("Annotations from the following tables will be obsolete by updating the base document and will be deleted: {}", obsoleteAnnotationTableNames);
            for (String table : obsoleteAnnotationTableNames) {
                this.tablesWithoutData.put(table, new ArrayList());
            }
        }
        this.splitter = this.storeAll.booleanValue() ? (null != this.attributeSize ? new WholeXmiStaxSplitter(this.docTableParamValue, this.attributeSize.intValue()) : new WholeXmiStaxSplitter(this.docTableParamValue)) : (null != this.attributeSize ? new StaxXmiSplitter(new HashSet<String>(this.annotationsToStore), this.recursively.booleanValue(), this.storeBaseDocument.booleanValue(), this.docTableParamValue, this.baseDocumentAnnotationTypes, this.attributeSize.intValue()) : new StaxXmiSplitter(new HashSet<String>(this.annotationsToStore), this.recursively.booleanValue(), this.storeBaseDocument.booleanValue(), this.docTableParamValue, this.baseDocumentAnnotationTypes));
        log.info(XMIDBWriter.class.getName() + " initialized.");
        log.info("Effective document table name: {}", (Object)this.effectiveDocTableName);
        log.info("Is base document stored: {}", (Object)this.storeBaseDocument);
        log.info("CAS XMI data will be GZIPed: {}", (Object)this.doGzip);
        log.info("Is the whole, unsplit XMI document stored: {}", (Object)this.storeAll);
        log.info("Annotations belonging to the base document: {}", this.baseDocumentAnnotationTypes);
        log.info("Annotation types to store in separate tables: {}", this.annotationsToStore);
        log.info("Store annotations recursively: {}", (Object)this.recursively);
        log.info("Update mode: {}", (Object)this.updateMode);
        log.info("Base document table schema: {}", (Object)this.schemaDocument);
        log.info("Annotation table schema (only required if annotations are stored separatly): {}", (Object)this.schemaAnnotation);
        log.info("Batch size of cached documents sent to database: {}", (Object)this.writeBatchSize);
        this.metaTableManager = new MetaTableManager(this.dbc);
        this.annotationInserter = new XmiDataInserter(annotationsToStoreTableNames, this.effectiveDocTableName, this.dbc, this.schemaDocument, this.schemaAnnotation, this.storeAll, this.storeBaseDocument, this.updateMode, this.componentDbName);
        this.dbc.releaseConnections();
    }

    private void checkTableDefinition(String annotationTableName, String schemaAnnotation) throws ResourceInitializationException {
        try {
            this.dbc.checkTableDefinition(annotationTableName, schemaAnnotation);
        }
        catch (TableSchemaMismatchException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void checkParameters(UimaContext aContext) throws ResourceInitializationException {
        if (aContext.getConfigParameterValue(PARAM_COSTOSYS_CONFIG) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The database configuration file is null. You must provide the path to a valid configuration file."));
        }
        if (aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The document table is null. You must provide it to either store the entire xmi data, to store the base document  or to update the next possible xmi id."));
        }
        String[] annotations = (String[])aContext.getConfigParameterValue(PARAM_ANNOS_TO_STORE);
        if ((Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL) == null && annotations == null && (Boolean)aContext.getConfigParameterValue(PARAM_STORE_BASE_DOCUMENT) == null) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The parameter to store the entire xmi data is not checked, but there are no annotations specified to store instead. You must provide the names of the selected annotations, if you do not want to  write the entire CAS data."));
        }
        if (aContext.getConfigParameterValue(PARAM_STORE_ALL) != null && ((Boolean)aContext.getConfigParameterValue(PARAM_STORE_ALL)).booleanValue() && annotations != null && annotations.length > 0) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("The parameter to store the entire xmi data is checked and there are annotations specified to store. You can only either write the entire CAS data or select annotations, but not both."));
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            try {
                Workitem workitem = (Workitem)JCasUtil.selectSingle((JCas)aJCas, Workitem.class);
                log.trace("Work item feature structure found in the current CAS. Sending data to the database and returning.");
                if (workitem.getLastBlock()) {
                    this.collectionProcessComplete();
                } else {
                    this.batchProcessComplete();
                }
                return;
            }
            catch (IllegalArgumentException workitem) {
                ByteArrayOutputStream baos;
                Collection metaData;
                DocumentId docId = this.getDocumentId(aJCas);
                if (docId == null) {
                    return;
                }
                int nextXmiId = this.determineNextXmiId(aJCas, docId);
                Map<String, Integer> baseDocumentSofaIdMap = this.getOriginalSofaIdMappings(aJCas, docId);
                Collection xmiMetaData = JCasUtil.select((JCas)aJCas, XmiMetaData.class);
                if (xmiMetaData.size() > 1) {
                    throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("There are multiple XmiMetaData annotations in the cas for document " + docId + "."));
                }
                xmiMetaData.forEach(TOP::removeFromIndexes);
                if (this.subsetTable == null && !(metaData = JCasUtil.select((JCas)aJCas, DBProcessingMetaData.class)).isEmpty()) {
                    if (metaData.size() > 1) {
                        throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("There is more than one type of DBProcessingMetaData in document " + docId));
                    }
                    this.subsetTable = ((DBProcessingMetaData)metaData.stream().findAny().get()).getSubsetTable();
                }
                try {
                    ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
                    XmiCasSerializer.serialize((CAS)aJCas.getCas(), (OutputStream)baos);
                    ((OutputStream)os).close();
                }
                catch (SAXParseException e) {
                    log.error("Serialization error occurred, skipping this document: ", (Throwable)e);
                    return;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                byte[] completeXmiData = baos.toByteArray();
                try {
                    if (this.storeAll.booleanValue()) {
                        Object storedData = this.handleDataZipping(completeXmiData, this.schemaDocument);
                        this.serializedCASes.get(this.effectiveDocTableName).add(new DocumentXmiData(docId, storedData, 0, null));
                    } else {
                        XmiSplitterResult result = this.splitter.process(completeXmiData, aJCas, nextXmiId, baseDocumentSofaIdMap);
                        HashMap splitXmiData = result.xmiData;
                        HashMap convertedMap = new HashMap();
                        for (Map.Entry e : splitXmiData.entrySet()) {
                            if (!((String)e.getKey()).equals(this.docTableParamValue)) {
                                convertedMap.put(this.annotationTableManager.convertAnnotationTypeToTableName((String)e.getKey(), this.storeAll), e.getValue());
                                continue;
                            }
                            convertedMap.put(this.effectiveDocTableName, e.getValue());
                        }
                        splitXmiData = convertedMap;
                        Integer newXmiId = result.maxXmiId;
                        Map nsAndXmiVersionMap = result.namespaces;
                        Map currentSofaXmiIdMap = result.currentSofaIdMap;
                        this.metaTableManager.manageXMINamespaces(nsAndXmiVersionMap);
                        if (currentSofaXmiIdMap.isEmpty()) {
                            throw new IllegalStateException("The XmiSplitter returned an empty Sofa XMI ID map. This is a critical errors since it means that the splitter was not able to resolve the correct Sofa XMI IDs for the annotations that should be stored now.");
                        }
                        log.trace("Updating max xmi id of document {}. New max xmi id: {}", (Object)docId, (Object)newXmiId);
                        log.trace("Sofa ID map for this document: {}", (Object)currentSofaXmiIdMap);
                        for (String tableName : this.serializedCASes.keySet()) {
                            boolean isDocumentTable = tableName.equals(this.effectiveDocTableName);
                            ByteArrayOutputStream dataBaos = (ByteArrayOutputStream)splitXmiData.get(tableName);
                            if (null != dataBaos) {
                                byte[] dataBytes = dataBaos.toByteArray();
                                String tableSchemaName = isDocumentTable ? this.schemaDocument : this.schemaAnnotation;
                                Object storedData = this.handleDataZipping(dataBytes, tableSchemaName);
                                if (this.storeBaseDocument.booleanValue() && isDocumentTable) {
                                    this.serializedCASes.get(tableName).add(new DocumentXmiData(docId, storedData, newXmiId, currentSofaXmiIdMap));
                                    continue;
                                }
                                this.serializedCASes.get(tableName).add(new XmiData(docId, storedData));
                                if (this.storeBaseDocument.booleanValue()) continue;
                                this.annotationInserter.putXmiIdMapping(docId, newXmiId);
                                continue;
                            }
                            if (!this.updateMode.booleanValue()) continue;
                            this.tablesWithoutData.get(tableName).add(docId);
                        }
                        if (this.deleteObsolete.booleanValue()) {
                            for (String obsoleteTable : this.annotationTableManager.getObsoleteAnnotationTableNames()) {
                                this.tablesWithoutData.get(obsoleteTable).add(docId);
                            }
                        }
                    }
                    this.annotationInserter.addProcessedDocumentId(docId);
                }
                catch (XMISplitterException | IOException e) {
                    throw new AnalysisEngineProcessException(e);
                }
                ++this.currentBatchSize;
                if (this.currentBatchSize % this.writeBatchSize == 0) {
                    log.trace("Document nr {} processed, filling batch nr {} of size {}, sending to database.", new Object[]{this.currentBatchSize, this.currentBatchSize / this.writeBatchSize, this.writeBatchSize});
                    this.batchProcessComplete();
                }
            }
        }
        catch (Throwable throwable) {
            String docid = "<unknown>";
            try {
                docid = ((Header)JCasUtil.selectSingle((JCas)aJCas, Header.class)).getDocId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error occurred at document {}: ", (Object)docid, (Object)throwable);
            throw throwable;
        }
    }

    private DocumentId getDocumentId(JCas aJCas) {
        DocumentId docId = null;
        try {
            DBProcessingMetaData dbProcessingMetaData = (DBProcessingMetaData)JCasUtil.selectSingle((JCas)aJCas, DBProcessingMetaData.class);
            docId = new DocumentId(dbProcessingMetaData);
        }
        catch (IllegalArgumentException e) {
            log.debug("Could not find the primary key in the DBProcessingMetaData due to exception: {}. Using the document ID as primary key.", (Object)DBProcessingMetaData.class.getSimpleName());
        }
        if (docId == null) {
            AnnotationIndex headerIndex = aJCas.getAnnotationIndex(Header.type);
            FSIterator headerIt = headerIndex.iterator();
            if (!headerIt.hasNext()) {
                int min = Math.min(100, aJCas.getDocumentText().length());
                log.warn("Got document without a header and without DBProcessingMetaData; cannot obtain document ID. This document will not be written into the database. Document text begins with: {}", (Object)aJCas.getDocumentText().substring(0, min));
                ++this.headerlessDocuments;
                return null;
            }
            Header header = (Header)headerIt.next();
            docId = new DocumentId(header.getDocId());
        }
        return docId;
    }

    private Map<String, Integer> getOriginalSofaIdMappings(JCas aJCas, DocumentId docId) {
        XmiMetaData xmiMetaData;
        if (this.storeAll.booleanValue()) {
            return Collections.emptyMap();
        }
        try {
            xmiMetaData = (XmiMetaData)JCasUtil.selectSingle((JCas)aJCas, XmiMetaData.class);
            if (xmiMetaData.getSofaIdMappings() == null) {
                return Collections.emptyMap();
            }
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyMap();
        }
        Map<String, Integer> map = Stream.of(xmiMetaData.getSofaIdMappings().toArray()).map(line -> line.split("=")).collect(Collectors.toMap(split -> split[1], split -> Integer.parseInt(split[0])));
        log.trace("Got Sofa XMI map from the CAS: {}", map);
        return map;
    }

    private int determineNextXmiId(JCas aJCas, DocumentId docId) throws AnalysisEngineProcessException {
        int nextXmiId;
        block5: {
            nextXmiId = 0;
            try {
                nextXmiId = ((XmiMetaData)JCasUtil.selectSingle((JCas)aJCas, XmiMetaData.class)).getMaxXmiId();
            }
            catch (IllegalArgumentException e) {
                if (this.storeBaseDocument.booleanValue() || this.storeAll.booleanValue()) break block5;
                throw new AnalysisEngineProcessException((Throwable)new NullPointerException("Error: Could not find the max XMI ID in the CAS. Explanation: The option to store the base document (i.e. the document and possible same basic document meta data annotations) is set to false. Thus, it is assumed that the XMI DB Reader was used to read an existing base document and that only annotation data should be written now. In this case, the current maximum XMI ID for the respective document is required to be found in the CAS to keep this XMI ID unique for each annotation. This information is written into the CAS by the XMI DB Reader, if the respective configuration parameter is set to true. This seems not to be the case since the max XMI ID could not be found. Make sure that the reader adds the max XMI IDto the CAS and run the pipeline again."));
            }
        }
        if (this.storeAll.booleanValue() || this.storeBaseDocument.booleanValue() || this.annotationsToStore.isEmpty()) {
            nextXmiId = 0;
            log.trace("Counting XMI IDs from 0 for document {} since the whole document is stored or the base document is stored or no additional annotations are stored.", (Object)docId);
        } else {
            log.trace("Counting XMI IDs from {} for document {}.", (Object)nextXmiId, (Object)docId);
            if (nextXmiId == 0) {
                log.warn("XMI IDs are counted from 0 for document {}. This is most probably a mistake since annotations should be stored but not the base document. In the base document are always some annotation elements with XMI IDs so those IDs will most probably already be taken and should not be assigned to new annotations.", (Object)docId);
            }
        }
        return nextXmiId;
    }

    protected Object handleDataZipping(byte[] dataBytes, String tableSchemaName) throws IOException {
        Object storedData = null;
        Map field = (Map)this.dbc.getFieldConfiguration(tableSchemaName).getFields().get(1);
        String xmiFieldType = (String)field.get("type");
        if (this.doGzip.booleanValue()) {
            if (!xmiFieldType.equalsIgnoreCase("bytea")) {
                log.warn("The table schema \"" + tableSchemaName + "\" specifies the data type \"" + xmiFieldType + "\" for the field \"" + (String)field.get("name") + "\" which is supposed to be filled with gzipped XMI data. However, binary data should go to a field of type bytea.");
            }
            ByteArrayOutputStream gzipBaos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(gzipBaos);
            gzos.write(dataBytes);
            gzos.close();
            storedData = gzipBaos.toByteArray();
        } else {
            if (!xmiFieldType.equalsIgnoreCase("text") && !xmiFieldType.equalsIgnoreCase("xml")) {
                log.warn("The table schema \"" + tableSchemaName + "\" specifies the data type \"" + xmiFieldType + "\" for the field \"" + (String)field.get("name") + "\" and the contents to be written should be XML. Please use the field type xml or text for such contents.");
            }
            storedData = new String(dataBytes, "UTF-8");
        }
        return storedData;
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        log.debug("Running batchProcessComplete.");
        try {
            this.annotationInserter.sendXmiDataToDatabase(this.serializedCASes, this.tablesWithoutData, this.subsetTable);
            for (List<XmiData> list : this.serializedCASes.values()) {
                list.clear();
            }
            for (List<Object> list : this.tablesWithoutData.values()) {
                list.clear();
            }
        }
        catch (XmiDataInsertionException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        log.debug("Running collectionProcessComplete.");
        try {
            this.annotationInserter.sendXmiDataToDatabase(this.serializedCASes, this.tablesWithoutData, this.subsetTable);
            for (List<XmiData> list : this.serializedCASes.values()) {
                list.clear();
            }
            for (List<Object> list : this.tablesWithoutData.values()) {
                list.clear();
            }
        }
        catch (XmiDataInsertionException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        log.info("{} documents without a head occured overall. Those could not be written into the database.", (Object)this.headerlessDocuments);
        this.dbc.close();
    }
}

