/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.jcore.consumer.xmi.DocumentId;
import de.julielab.jcore.consumer.xmi.DocumentXmiData;
import de.julielab.jcore.consumer.xmi.XmiData;
import de.julielab.jcore.consumer.xmi.XmiDataInsertionException;
import de.julielab.xmlData.config.FieldConfig;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiDataInserter {
    private static final Logger log = LoggerFactory.getLogger(XmiDataInserter.class);
    private static final String FIELD_MAX_XMI_ID = "max_xmi_id";
    private Boolean updateMode;
    private String schemaDocument;
    private String schemaAnnotation;
    private Boolean storeAll;
    private String effectiveDocTableName;
    private DataBaseConnector dbc;
    private List<String> annotationsToStore;
    private Boolean storeBaseDocument;
    private Map<DocumentId, Integer> maxXmiIdMap;
    private String componentDbName;
    private List<DocumentId> processedDocumentIds;

    public XmiDataInserter(List<String> annotationsToStore, String effectiveDocTableName, DataBaseConnector dbc, String schemaDocument, String schemaAnnotation, Boolean storeAll, Boolean storeBaseDocument, Boolean updateMode, String componentDbName) {
        this.annotationsToStore = annotationsToStore;
        this.effectiveDocTableName = effectiveDocTableName;
        this.dbc = dbc;
        this.schemaDocument = schemaDocument;
        this.schemaAnnotation = schemaAnnotation;
        this.storeAll = storeAll;
        this.storeBaseDocument = storeBaseDocument;
        this.updateMode = updateMode;
        this.componentDbName = componentDbName;
        this.maxXmiIdMap = new HashMap<DocumentId, Integer>();
        this.processedDocumentIds = new ArrayList<DocumentId>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendXmiDataToDatabase(final LinkedHashMap<String, List<XmiData>> serializedCASes, Map<String, List<DocumentId>> tablesWithoutData, String subsetTableName) throws XmiDataInsertionException {
        if (log.isTraceEnabled()) {
            log.trace("Sending XMI data for {} tables to the database", (Object)serializedCASes.size());
            log.trace("Sending {} XMI data items", (Object)serializedCASes.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.summingInt(v -> v.size())));
        }
        Connection conn = this.dbc.reserveConnection();
        try {
            conn.setAutoCommit(false);
            for (String tableName : serializedCASes.keySet()) {
                if (serializedCASes.get(tableName).size() == 0) {
                    log.trace("No XMI data for table \"" + tableName + "\" (annotation type \"" + tableName + "\"), skipping.");
                    continue;
                }
                class RowIterator
                implements Iterator<Map<String, Object>> {
                    private int index = 0;
                    private List<XmiData> tableDataList;

                    public RowIterator(String table) {
                        this.tableDataList = (List)serializedCASes.get(table);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.tableDataList.size();
                    }

                    @Override
                    public Map<String, Object> next() {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        XmiData results = this.tableDataList.get(this.index);
                        FieldConfig fieldConfig = results.getClass().equals(DocumentXmiData.class) ? XmiDataInserter.this.dbc.getFieldConfiguration(XmiDataInserter.this.schemaDocument) : XmiDataInserter.this.dbc.getFieldConfiguration(XmiDataInserter.this.schemaAnnotation);
                        List fields = fieldConfig.getFields();
                        Function<Integer, String> fName = num -> (String)((Map)fields.get((int)num)).get("name");
                        int i = 0;
                        for (Integer pkIndex : fieldConfig.getPrimaryKeyFieldNumbers()) {
                            row.put(fName.apply(pkIndex), results.docId.getId()[i++]);
                            if (!log.isTraceEnabled()) continue;
                            log.trace("{}={}", (Object)fName.apply(pkIndex), row.get(fName.apply(pkIndex)));
                        }
                        row.put(fName.apply(i++), results.data);
                        if (log.isTraceEnabled()) {
                            log.trace("{}={}", (Object)fName.apply(i - 1), row.get(fName.apply(i - 1)));
                        }
                        if (results.getClass().equals(DocumentXmiData.class) && !XmiDataInserter.this.storeAll.booleanValue()) {
                            if (fieldConfig.getFields().size() - fieldConfig.getPrimaryKey().length < 3) {
                                throw new IllegalArgumentException("The XMI data table schema is set to the schema with name \"" + XmiDataInserter.this.schemaDocument + "\" that specifies the fields \"" + StringUtils.join((Object[])fieldConfig.getColumns(), (String)",") + "\". However, this schema is not compatible with XMI base document storage since the storage requires two extra fields to store the maximum XMI ID of the document and the sofa mapping.");
                            }
                            DocumentXmiData docResults = (DocumentXmiData)results;
                            row.put(XmiDataInserter.FIELD_MAX_XMI_ID, docResults.newXmiId);
                            log.trace("{}={}", (Object)XmiDataInserter.FIELD_MAX_XMI_ID, (Object)docResults.newXmiId);
                            row.put("sofa_mapping", docResults.serializedSofaXmiIdMap);
                            log.trace("{}={}", (Object)"sofa_mapping", (Object)docResults.serializedSofaXmiIdMap);
                        }
                        ++this.index;
                        return row;
                    }

                    @Override
                    public void remove() {
                        throw new NotImplementedException();
                    }
                }
                RowIterator iterator = new RowIterator(tableName);
                try {
                    if (this.updateMode.booleanValue()) {
                        log.debug("Updating {} XMI CAS data in database table '{}'.", (Object)serializedCASes.get(tableName).size(), (Object)tableName);
                        if (this.storeAll.booleanValue()) {
                            this.dbc.updateFromRowIterator((Iterator)iterator, tableName, false, this.schemaDocument);
                            continue;
                        }
                        this.dbc.updateFromRowIterator((Iterator)iterator, tableName, false, tableName.equals(this.effectiveDocTableName) ? this.schemaDocument : this.schemaAnnotation);
                        continue;
                    }
                    log.debug("Inserting {} XMI CAS data into database table '{}'.", (Object)serializedCASes.get(tableName).size(), (Object)tableName);
                    if (this.storeAll.booleanValue()) {
                        this.dbc.importFromRowIterator((Iterator)iterator, tableName, false, this.schemaDocument);
                        continue;
                    }
                    this.dbc.importFromRowIterator((Iterator)iterator, tableName, false, tableName.equals(this.effectiveDocTableName) ? this.schemaDocument : this.schemaAnnotation);
                }
                catch (Exception e) {
                    log.error("Error occurred while sending data to database. Exception:", (Throwable)e);
                    throw new XmiDataInsertionException(e);
                }
            }
            this.updateMaxXmiId(conn);
            this.deleteRowsFromTablesWithoutData(tablesWithoutData, conn, this.dbc, this.annotationsToStore);
            this.setLastComponent(conn, subsetTableName);
            log.debug("Committing XMI data to database.");
            conn.commit();
        }
        catch (SQLException e) {
            log.error("Database error occurred while updating max-xmi-IDs: {}", (Throwable)e);
            e.printStackTrace();
            SQLException ne = e.getNextException();
            if (null != ne) {
                ne.printStackTrace();
            }
        }
        finally {
            this.dbc.releaseConnection(conn);
        }
    }

    private void setLastComponent(Connection conn, String subsetTableName) throws XmiDataInsertionException {
        if (this.processedDocumentIds.isEmpty() || StringUtils.isBlank((CharSequence)subsetTableName)) {
            return;
        }
        FieldConfig annotationFieldConfig = this.dbc.getFieldConfiguration(this.schemaDocument);
        String[] primaryKey = annotationFieldConfig.getPrimaryKey();
        if (primaryKey.length > 1) {
            throw new IllegalArgumentException("Currently, only one-element primary keys are supported.");
        }
        String primaryKeyPsString = StringUtils.join((Object[])annotationFieldConfig.expandPKNames("%s = ?"), (String)" AND ");
        log.debug("Marking {} documents to having been processed by component \"{}\".", (Object)this.processedDocumentIds.size(), (Object)this.componentDbName);
        String sql = String.format("UPDATE %s SET %s='%s' WHERE %s", subsetTableName, "last_component", this.componentDbName, primaryKeyPsString);
        try {
            boolean tryagain;
            do {
                tryagain = false;
                PreparedStatement ps = conn.prepareStatement(sql);
                for (DocumentId docId : this.processedDocumentIds) {
                    for (int i = 0; i < docId.getId().length; ++i) {
                        String pkElement = docId.getId()[i];
                        ps.setString(i + 1, pkElement);
                    }
                    ps.addBatch();
                }
                try {
                    ps.executeBatch();
                }
                catch (BatchUpdateException e) {
                    if (!e.getMessage().contains("deadlock detected")) continue;
                    log.debug("Database transaction deadlock detected while trying to set the last component. Trying again.");
                    tryagain = true;
                }
            } while (tryagain);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException nextException = e.getNextException();
            if (null == nextException) {
                throw new XmiDataInsertionException(e);
            }
            nextException.printStackTrace();
            throw new XmiDataInsertionException(nextException);
        }
        finally {
            this.processedDocumentIds.clear();
        }
    }

    private void deleteRowsFromTablesWithoutData(Map<String, List<DocumentId>> tablesWithoutData, Connection conn, DataBaseConnector dbc, List<String> annotationsToStore) throws XmiDataInsertionException {
        if (!this.updateMode.booleanValue() || this.storeAll.booleanValue() || annotationsToStore.isEmpty()) {
            return;
        }
        FieldConfig annotationFieldConfig = dbc.getFieldConfiguration(this.schemaAnnotation);
        String[] primaryKey = annotationFieldConfig.getPrimaryKey();
        if (primaryKey.length > 1) {
            throw new IllegalArgumentException("Currently, only one-element primary keys are supported.");
        }
        for (Map.Entry<String, List<DocumentId>> entry : tablesWithoutData.entrySet()) {
            List<DocumentId> docIds = entry.getValue();
            if (docIds.size() == 0) continue;
            String tableName = entry.getKey();
            String pkElementPsString = StringUtils.join((Object[])annotationFieldConfig.expandPKNames("%s = ?"), (String)" AND ");
            String deleteString = "DELETE FROM " + tableName + " WHERE " + pkElementPsString;
            try {
                PreparedStatement deleteRowWithoutData = conn.prepareStatement(deleteString);
                for (DocumentId docId : docIds) {
                    for (int i = 0; i < docId.getId().length; ++i) {
                        String pkElement = docId.getId()[i];
                        deleteRowWithoutData.setString(i + 1, pkElement);
                    }
                    deleteRowWithoutData.addBatch();
                }
                deleteRowWithoutData.executeBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
                SQLException nextException = e.getNextException();
                if (null == nextException) {
                    throw new XmiDataInsertionException(e);
                }
                nextException.printStackTrace();
                throw new XmiDataInsertionException(nextException);
            }
            finally {
                docIds.clear();
            }
        }
    }

    public void updateMaxXmiId(Connection conn) throws XmiDataInsertionException {
        if (this.storeAll.booleanValue() || this.storeBaseDocument.booleanValue()) {
            return;
        }
        log.debug("Updating {} max XMI IDs.", (Object)this.maxXmiIdMap.size());
        FieldConfig annotationFieldConfig = this.dbc.getFieldConfiguration(this.schemaAnnotation);
        Object[] pkPsPlaceholder = annotationFieldConfig.expandPKNames("%s = ?");
        String pkElementCondition = StringUtils.join((Object[])pkPsPlaceholder, (String)" AND ");
        String updateString = "UPDATE " + this.effectiveDocTableName + " SET " + FIELD_MAX_XMI_ID + " = ? WHERE " + pkElementCondition;
        try {
            PreparedStatement updateMaxXmiId = conn.prepareStatement(updateString);
            for (DocumentId docId : this.maxXmiIdMap.keySet()) {
                Integer maxXmiId = this.maxXmiIdMap.get(docId);
                updateMaxXmiId.setInt(1, maxXmiId);
                for (int i = 0; i < docId.getId().length; ++i) {
                    String pkElement = docId.getId()[i];
                    updateMaxXmiId.setString(i + 2, pkElement);
                }
                updateMaxXmiId.addBatch();
            }
            updateMaxXmiId.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException nextException = e.getNextException();
            if (null == nextException) {
                throw new XmiDataInsertionException(e);
            }
            throw new XmiDataInsertionException(nextException);
        }
        finally {
            this.maxXmiIdMap.clear();
        }
    }

    public void putXmiIdMapping(DocumentId docId, Integer newXmiId) {
        this.maxXmiIdMap.put(docId, newXmiId);
    }

    public void addProcessedDocumentId(DocumentId docId) {
        this.processedDocumentIds.add(docId);
    }
}

