/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTableManager {
    private static final Logger log = LoggerFactory.getLogger(MetaTableManager.class);
    public static final String XMI_NS_TABLE = "_xmi_namespaces";
    public static final String PREFIX = "prefix";
    public static final String NS_URI = "ns_uri";
    private Set<String> knownNSPrefixes = new HashSet<String>();
    private DataBaseConnector dbc;

    public MetaTableManager(DataBaseConnector dbc) {
        this.dbc = dbc;
        this.createNamespaceTable(dbc);
    }

    void manageXMINamespaces(Map<String, String> nsAndXmiVersionMap) {
        block20: {
            ArrayList<Map.Entry<String, String>> notFound = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> nsEntry : nsAndXmiVersionMap.entrySet()) {
                if (this.knownNSPrefixes.contains(nsEntry.getKey())) continue;
                notFound.add(nsEntry);
            }
            String prefix = null;
            String uri = null;
            if (notFound.size() > 0) {
                try (Connection conn = this.dbc.reserveConnection();){
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s FROM %s", PREFIX, this.dbc.getActiveDataPGSchema() + "." + XMI_NS_TABLE);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        String knownPrefix = rs.getString(1);
                        this.knownNSPrefixes.add(knownPrefix);
                    }
                    String template = "INSERT INTO %s VALUES('%s','%s')";
                    for (Map.Entry entry : notFound) {
                        prefix = (String)entry.getKey();
                        uri = (String)entry.getValue();
                        sql = String.format(template, this.dbc.getActiveDataPGSchema() + "." + XMI_NS_TABLE, prefix, uri);
                        stmt.execute(sql);
                    }
                    for (Map.Entry entry : notFound) {
                        this.knownNSPrefixes.add((String)entry.getKey());
                    }
                }
                catch (PSQLException e) {
                    log.debug("Tried to add already existing namespace \"{}={}\", ignoring.", prefix, uri);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block20;
                    ne.printStackTrace();
                }
            }
        }
    }

    private void createNamespaceTable(DataBaseConnector dbc) {
        block3: {
            if (!dbc.tableExists(dbc.getActiveDataPGSchema() + "." + XMI_NS_TABLE)) {
                try {
                    Connection conn = dbc.obtainConnection();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("CREATE TABLE %s (%s text PRIMARY KEY, %s text)", dbc.getActiveDataPGSchema() + "." + XMI_NS_TABLE, PREFIX, NS_URI);
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block3;
                    ne.printStackTrace();
                }
            }
        }
    }
}

